/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.SecureDocumentBuilderFactory;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CALMDocument {
    private Document fDocument;
    private XPathFactory fFactory;
    private NamespaceContext fDefaultNamespaceContext;

    public CALMDocument(String xmlContent) throws DocumentParseException, IllegalArgumentException {
        if (!CALMDocument.isValidString(xmlContent)) {
            throw new IllegalArgumentException();
        }
        this.initializeDocument(new InputSource(new StringReader(xmlContent)));
    }

    public CALMDocument(InputStream xmlContent) throws DocumentParseException, IllegalArgumentException {
        if (xmlContent == null) {
            throw new IllegalArgumentException();
        }
        this.initializeDocument(new InputSource(xmlContent));
    }

    public NamespaceContext getDefaultNamespaceContext() {
        if (this.fDefaultNamespaceContext == null) {
            HashMap<String, String> nsUriToPefixSuggestions = new HashMap<String, String>();
            nsUriToPefixSuggestions.put("http://jazz.net/xmlns/prod/jazz/presentation/1.0/", "jp");
            nsUriToPefixSuggestions.put("http://jazz.net/xmlns/prod/jazz/process/1.0/", "jp10");
            CustomNamespaceContext result = Namespaces.createDefaultContext();
            result.setPrefixSuggestions(nsUriToPefixSuggestions);
            this.fDefaultNamespaceContext = result;
        }
        return this.fDefaultNamespaceContext;
    }

    public Document getRoot() {
        return this.fDocument;
    }

    public String getText(String xPathQuery, NamespaceContext namespaceContext) throws DocumentParseException {
        return this.getText(xPathQuery, this.fDocument, namespaceContext);
    }

    public String getText(XPathQuery query) throws DocumentParseException {
        if (query == null) {
            throw new DocumentParseException(Messages.getString("CALMDocument.ERROR_NULL_XPATH_QUERY"));
        }
        return this.getText(query.getXPath(), this.fDocument, query.getNamespaceContext());
    }

    public String getText(String xPathQuery) throws DocumentParseException {
        return this.getText(xPathQuery, this.fDocument, null);
    }

    public String getText(String xPathQuery, Object node) throws DocumentParseException {
        return this.getText(xPathQuery, node, null);
    }

    public String getText(String xPathQuery, Object node, NamespaceContext namespaceContext) throws DocumentParseException {
        if (xPathQuery == null) {
            throw new DocumentParseException(Messages.getString("CALMDocument.ERROR_NULL_XPATH_QUERY"));
        }
        if (node == null) {
            throw new DocumentParseException(Messages.getString("CALMDocument.ERROR_NULL_XML_NODE"));
        }
        try {
            XPath xPath = this.fFactory.newXPath();
            xPath.setNamespaceContext(namespaceContext != null ? namespaceContext : this.getDefaultNamespaceContext());
            return xPath.evaluate(xPathQuery, node);
        }
        catch (XPathExpressionException ex) {
            throw new DocumentParseException(ex);
        }
    }

    public String getText(Node node) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() == 1 && childNodes.item(0) instanceof Text) {
            return ((Text)childNodes.item(0)).getTextContent();
        }
        return null;
    }

    public String getText(XPathQuery query, Object node) throws DocumentParseException {
        if (query == null) {
            throw new DocumentParseException(Messages.getString("CALMDocument.ERROR_NULL_XPATH_QUERY"));
        }
        return this.getText(query.getXPath(), node, query.getNamespaceContext());
    }

    public NodeList getNodes(String xPathQuery) throws DocumentParseException {
        return this.getNodes(xPathQuery, null);
    }

    public NodeList getNodes(String xPathQuery, NamespaceContext namespaceContext) throws DocumentParseException {
        return this.getNodes(xPathQuery, this.fDocument, namespaceContext);
    }

    public NodeList getNodes(String xPathQuery, Object node, NamespaceContext namespaceContext) throws DocumentParseException {
        if (xPathQuery == null) {
            throw new DocumentParseException(Messages.getString("CALMDocument.ERROR_NULL_XPATH_QUERY"));
        }
        try {
            XPath xPath = this.fFactory.newXPath();
            xPath.setNamespaceContext(namespaceContext != null ? namespaceContext : this.getDefaultNamespaceContext());
            return (NodeList)xPath.evaluate(xPathQuery, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new DocumentParseException(ex);
        }
    }

    public NodeList getNodes(XPathQuery query) throws DocumentParseException {
        if (query == null) {
            throw new DocumentParseException(Messages.getString("CALMDocument.ERROR_NULL_XPATH_QUERY"));
        }
        return this.getNodes(query.getXPath(), query.getNamespaceContext());
    }

    protected static String concatURL(String first, String ... others) {
        StringBuilder buf = new StringBuilder(first);
        String[] stringArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            boolean slash1 = buf.charAt(buf.length() - 1) == '/';
            boolean slash2 = s.startsWith("/");
            if (!slash1 && !slash2) {
                buf.append('/');
            } else if (slash1 && slash2) {
                buf.setLength(buf.length() - 1);
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public static NamespaceContext createNamespaceContext(Map<String, String> namespacePrefixToURLs) throws IllegalArgumentException {
        return new CustomNamespaceContext(namespacePrefixToURLs);
    }

    public static void setAttribute(Element linkElem, Property property, String prefixSuggestion, String value) {
        CALMDocument.setAttribute(linkElem, property.getNamespaceURI(), property.getName(), prefixSuggestion, value);
    }

    public static void setAttribute(Element linkElem, String namespaceURI, String localName, String prefixSuggestion, String value) {
        if (linkElem != null && CALMDocument.isValidString(namespaceURI) && CALMDocument.isValidString(localName) && CALMDocument.isValidString(prefixSuggestion)) {
            String prefix = linkElem.lookupPrefix(namespaceURI);
            if (prefix == null) {
                prefix = prefixSuggestion;
            }
            linkElem.setAttributeNS(namespaceURI, String.valueOf(prefix) + ':' + localName, value);
        }
    }

    public Element addNewElement(Element root, String namespaceURI, String localName, String prefixSuggestion) {
        Element result = null;
        if (root != null && CALMDocument.isValidString(namespaceURI) && CALMDocument.isValidString(localName)) {
            String prefix = root.lookupPrefix(namespaceURI);
            if (!CALMDocument.isValidString(prefix)) {
                prefix = prefixSuggestion;
            }
            if (!CALMDocument.isValidString(prefix)) {
                prefix = this.getDefaultNamespaceContext().getPrefix(namespaceURI);
            }
            result = root.getOwnerDocument().createElementNS(namespaceURI, String.valueOf(prefix) + ':' + localName);
            root.appendChild(result);
        }
        return result;
    }

    private static boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    private void initializeDocument(InputSource source) throws DocumentParseException {
        try {
            DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.fDocument = db.parse(source);
            this.fFactory = XPathFactory.newInstance();
        }
        catch (SAXException e) {
            throw new DocumentParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new DocumentParseException(e);
        }
        catch (IOException e) {
            throw new DocumentParseException(e);
        }
    }

    public static class DocumentParseException
    extends TeamRepositoryException {
        private static final long serialVersionUID = 1L;

        public DocumentParseException(Exception wrapped) {
            super((Throwable)wrapped);
        }

        public DocumentParseException(String message) {
            super(message);
        }
    }
}

