/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.IRepositoryRemoteService;
import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.model.ServerDescription;
import com.ibm.team.repository.common.transport.HostUtil;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.IAbortableHttpRequest;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.repository.transport.client.OAuthUtil;
import com.ibm.team.repository.transport.client.ReleasingAndAbortingInputStream;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.RequestResponsePair;
import com.ibm.team.repository.transport.client.TransportUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;

public abstract class RestClientConnectionBase {
    protected final RemoteTeamServer _remoteTeamServer;
    protected final String _repoUri;
    protected final URI _requestUri;
    protected final IOAuthHandler _oauthHandler;
    protected final String _proxyUriRoot;
    protected final HashMap<String, String> _headers = new HashMap();
    protected boolean _hasBeenUsed = false;
    private URI _publicUri;
    private ITeamRawRestServiceClient.IRawRestClientConnection.Response _response = null;
    private static final String UserAgent = RestClientConnectionBase.class.getName();
    private static final String REQUESTED_WITH_HEADER = "X-Requested-With";
    private static final String PROXY_CONTEXT_SEGMENT = "proxy";
    private static final String SLASH = "/";
    private static final Log logger = LogFactory.getLog(RestClientConnectionBase.class);

    protected RestClientConnectionBase(RemoteTeamServer server, URI uri, IOAuthHandler handler) throws URISyntaxException {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("relUri must not be null");
        }
        this._repoUri = RestClientConnectionBase.getRepoUri(server);
        this._requestUri = uri.isAbsolute() ? uri : new URI(String.valueOf(RestClientConnectionBase.getRepoUri(server)) + RestClientConnectionBase.trimLeadingSlash(uri.toString()));
        this._remoteTeamServer = server;
        this._oauthHandler = handler;
        this._proxyUriRoot = RestClientConnectionBase.buildProxyUri(server);
    }

    public void addRequestHeader(String name, String value) {
        if (this._hasBeenUsed) {
            throw new IllegalStateException("Cannot add request headers to a connection has been previously run");
        }
        if (name == null || name.length() == 0) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this._headers.put(name, value);
    }

    public void release() {
        if (this._response == null) {
            return;
        }
        InputStream responseStream = this._response.getResponseStream();
        if (responseStream != null) {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Unexpected IO error on connection release: %s", e.getMessage()));
            }
        }
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doGet() throws TeamServiceException, TeamRepositoryException {
        return this.doMethod((HttpRequestBase)new HttpGet());
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doHead() throws TeamServiceException, TeamRepositoryException {
        return this.doMethod((HttpRequestBase)new HttpHead());
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doPost(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
        BufferedHttpEntity requestEntity;
        HttpPost postMethod = new HttpPost();
        try {
            requestEntity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity(content, contentLength, ContentType.create((String)contentType)));
        }
        catch (IOException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        postMethod.setEntity((HttpEntity)requestEntity);
        return this.doMethod((HttpRequestBase)postMethod);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doPut(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
        BufferedHttpEntity requestEntity;
        HttpPut putMethod = new HttpPut();
        try {
            requestEntity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity(content, contentLength, ContentType.create((String)contentType)));
        }
        catch (IOException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        putMethod.setEntity((HttpEntity)requestEntity);
        return this.doMethod((HttpRequestBase)putMethod);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doDelete() throws TeamServiceException, TeamRepositoryException {
        return this.doMethod((HttpRequestBase)new HttpDelete());
    }

    protected ITeamRawRestServiceClient.IRawRestClientConnection.Response doMethod(HttpRequestBase request) throws TeamServiceException, TeamRepositoryException {
        TeamRepositoryException caughtException;
        int status;
        RequestResponsePair method;
        block10: {
            if (this._hasBeenUsed) {
                throw new IllegalStateException("do* called multiple times on the same connection");
            }
            this._hasBeenUsed = true;
            method = new RequestResponsePair(request);
            this.prepareMethod(method);
            status = -1;
            caughtException = null;
            try {
                this.executeMethod(method);
            }
            catch (TeamRepositoryException e) {
                caughtException = e;
                if (method.getResponse() == null) break block10;
                status = method.getResponse().getStatusLine().getStatusCode();
            }
        }
        CloseableHttpResponse response = method.getResponse();
        if (response == null && caughtException != null) {
            throw caughtException;
        }
        if (response == null) {
            throw new TeamRepositoryException("Response is unexpectedly null - should never happen");
        }
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>(headers.length);
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            headersMap.put(header.getName(), header.getValue());
            ++n2;
        }
        ReleasingAndAbortingInputStream responseStream = null;
        try {
            if (response.getEntity() != null) {
                responseStream = new ReleasingAndAbortingInputStream(response.getEntity());
            }
        }
        catch (IOException e) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        String statusText = response.getStatusLine().getReasonPhrase();
        status = response.getStatusLine().getStatusCode();
        this._response = new ITeamRawRestServiceClient.IRawRestClientConnection.Response(responseStream, headersMap, status, statusText);
        if (caughtException != null) {
            throw caughtException;
        }
        return this._response;
    }

    protected void prepareMethod(RequestResponsePair method) throws TeamServiceException {
        HttpRequestBase request = method.getRequest();
        try {
            URI uri = this.bindProxyUri();
            String formatString = "%s";
            if (uri.getQuery() != null) {
                formatString = String.valueOf(formatString) + "?%s";
            }
            if (uri.getFragment() != null) {
                formatString = String.valueOf(formatString) + "#%s";
            }
            try {
                uri = new URI(String.format(formatString, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment()));
            }
            catch (URISyntaxException e) {
                logger.warn((Object)String.format("URISyntaxException parsing URI: %s", e.getMessage()));
            }
            request.setURI(uri);
            if (RestClientConnectionBase.startsWithPath(uri, URI.create(this._proxyUriRoot))) {
                request.addHeader("X-jazz-downstream-auth-client-level", null);
            }
        }
        catch (IllegalStateException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        for (String key : this._headers.keySet()) {
            String value = this._headers.get(key);
            request.addHeader(key, value);
        }
        request.setHeader("User-Agent", UserAgent);
        request.setHeader("http.useragent", UserAgent);
        request.setHeader(REQUESTED_WITH_HEADER, UserAgent);
        if (request.getFirstHeader("Accept") == null) {
            request.setHeader("Accept", HttpUtil.MediaType.XML.toString());
        }
        if (request.getFirstHeader("Accept-Charset") == null) {
            request.setHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        }
        if (request.getFirstHeader("Accept-Language") == null) {
            TransportUtils.setAcceptLanguageHeader((HttpRequest)request);
        }
        String userid = this._remoteTeamServer.getUserid();
        TransportUtils.addUseridHeader(userid, (HttpRequest)request);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response getResponse() {
        return this._response;
    }

    protected void executeMethod(RequestResponsePair method) throws TeamServiceException, TeamRepositoryException {
        int status = 500;
        AuthenticationException authEx = null;
        final HttpRequestBase cancellableMethod = method.getRequest();
        TeamServiceCallContextImpl.setUpCall((IAbortableHttpRequest)new IAbortableHttpRequest(){

            public String getURI() {
                return cancellableMethod.getURI().toString();
            }

            public void abort() {
                cancellableMethod.abort();
            }
        });
        try {
            try {
                status = this._remoteTeamServer.executeMethod(null, method, false, true);
            }
            catch (AuthenticationException e) {
                status = 401;
                try {
                    status = OAuthUtil.handleOAuthChallenge(status, this._remoteTeamServer, method, this._oauthHandler);
                    if (status == 401) {
                        authEx = e;
                    }
                }
                catch (Exception ex) {
                    int statusCode = -1;
                    if (ex instanceof TeamServiceException) {
                        statusCode = ((TeamServiceException)((Object)ex)).getStatusCode();
                    }
                    throw new TeamServiceException(ex.getMessage(), (Throwable)ex, statusCode);
                }
            }
            catch (TeamServiceException exp) {
                throw exp;
            }
            catch (Exception ex) {
                throw new TeamServiceException(ex.getMessage(), (Throwable)ex);
            }
            if (status == 401 && authEx != null) {
                throw authEx;
            }
        }
        finally {
            TeamServiceCallContextImpl.tearDownCall();
        }
    }

    protected URI bindProxyUri() throws TeamRepositoryException {
        try {
            URI publicUri;
            boolean equivalentApps;
            String uri = this._requestUri.toString();
            URI repoUri = new URI(this._repoUri);
            boolean bl = equivalentApps = HostUtil.authorityEquiv((URI)repoUri, (URI)this._requestUri) && RestClientConnectionBase.startsWithPath(this._requestUri, repoUri);
            if (!equivalentApps && (publicUri = this.getPublicUri()) != null && HostUtil.authorityEquiv((URI)publicUri, (URI)this._requestUri) && RestClientConnectionBase.startsWithPath(this._requestUri, publicUri)) {
                equivalentApps = true;
            }
            if (!equivalentApps) {
                uri = String.format("%s?uri=%s", this._proxyUriRoot, LocationUtil.encode((String)uri));
                return new URI(uri);
            }
            return this._requestUri;
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static boolean startsWithPath(URI baseUri, URI compareUri) {
        String basePath;
        String comparePath = compareUri.getPath();
        if (comparePath == null) {
            comparePath = "";
        }
        if (!comparePath.endsWith(SLASH)) {
            comparePath = String.valueOf(comparePath) + SLASH;
        }
        if ((basePath = baseUri.getPath()) == null) {
            basePath = "";
        }
        if (!basePath.endsWith(SLASH)) {
            basePath = String.valueOf(basePath) + SLASH;
        }
        return basePath.startsWith(comparePath);
    }

    private static String buildProxyUri(RemoteTeamServer server) {
        String repoUri = server.getRepositoryURL();
        return String.valueOf(repoUri) + PROXY_CONTEXT_SEGMENT;
    }

    private static String getRepoUri(RemoteTeamServer server) {
        String repoUri = server.getRepositoryURL();
        return repoUri;
    }

    private static String trimLeadingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if (uri.startsWith(SLASH) || uri.startsWith(SLASH)) {
            if (uri.length() > 1) {
                return uri.substring(1);
            }
            uri = "";
        }
        return uri;
    }

    private URI getPublicUri() throws TeamRepositoryException {
        ServerDescription serverDescription;
        String uri;
        IRepositoryRemoteService repoService;
        if (this._publicUri == null && (repoService = (IRepositoryRemoteService)this._remoteTeamServer.getServiceImplementation(IRepositoryRemoteService.class)) != null && (uri = (serverDescription = repoService.describe()).getPublicUriRoot()) != null) {
            this._publicUri = URI.create(uri);
        }
        return this._publicUri;
    }
}

