/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTSymbolicLinkVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CTVersion
extends CTResource {
    final CCaseLib cc;
    private static Set<String> VERSION_MTYPES = new HashSet<String>(Arrays.asList("directory version", "symbolic link", "version", "derived object version"));
    private String _pathname = null;
    private String VersionName = null;
    private List<CTVersion> predecessorList = null;
    private String brtypeName = null;
    private String _activityName = null;
    private CTLocation _versionHistoryLocation = null;
    private String _activityUSel = null;
    private boolean _isObsolete;

    CTVersion(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    public static CTVersion valueOf(CTProvider p, CCaseObjInfo versInfo, SrvcFeedback feedback) throws WvcmException {
        CTLocation versLoc = CTVersion.getVersionLocation(versInfo);
        return CTVersion.valueOf(p, versLoc, versInfo, feedback);
    }

    private static CTLocation getVersionLocation(CCaseObjInfo versInfo) throws WvcmException {
        CTLocation result = CTVersion.lookupVersionLocation(versInfo);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTVersion_ERROR_COULD_NOT_GET_VERSION_LOC, (Object)versInfo.getUniversalSelector(), (Object)versInfo.getMtype()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static CTVersion valueOf(CTProvider p, CCaseObjInfo versInfo, CTView view, String pname, SrvcFeedback feedback) throws WvcmException {
        boolean isBaseCcView = view instanceof CTBaseCCView;
        String viewTag = view.getViewTag();
        return CTVersion.valueOf(p, versInfo, pname, isBaseCcView, viewTag, feedback);
    }

    public static CTVersion valueOf(CTProvider p, CCaseObjInfo versInfo, String pname, boolean isBaseCcView, String viewTag, SrvcFeedback feedback) throws WvcmException {
        CTLocation versLoc = CTVersion.lookupVersionLocation(p, isBaseCcView, viewTag, pname, versInfo, feedback);
        return CTVersion.valueOf(p, versLoc, versInfo, feedback);
    }

    private static CTVersion valueOf(CTProvider p, CTLocation versLoc, CCaseObjInfo versInfo, SrvcFeedback feedback) throws WvcmException {
        String mtype = versInfo.getMtype();
        if (!VERSION_MTYPES.contains(mtype)) {
            throw new IllegalArgumentException(String.format("unexpected version mtype: %s", mtype));
        }
        CTResource result = p.createAndCacheCTResource(versLoc, versInfo, feedback);
        if (result == null) {
            throw new IllegalArgumentException("lookup of version selector \"" + versInfo.getUniversalSelector() + "\" returned null");
        }
        if (!(result instanceof CTVersion) && !(result instanceof CTSymbolicLinkVersion)) {
            throw new IllegalStateException(" lookup of versionSelector returned an instance of class: " + ((Object)((Object)result)).getClass().getName() + " for location: " + versLoc.toString());
        }
        return (CTVersion)result;
    }

    public static CTVersion valueOf(CTProvider p, CCaseLib.VersionHistoryEntry e, String elemUSel, String elemPname, String viewTag, SrvcFeedback feedback) throws WvcmException {
        boolean isDirectory = e.mtype.startsWith("directory");
        String versionName = e.versionName;
        String pathName = new StringBuffer(elemPname).append(versionName).toString();
        CCaseVerInfo versInfo = new CCaseVerInfo(p.getCCaseLib(), e.universalSelector, isDirectory, pathName, e.mtype, e.creationDate, elemPname, e.comment, e.groupUser);
        CTVersion v = CTVersion.valueOf(p, versInfo, pathName, true, viewTag, feedback);
        if (elemUSel != null) {
            v.setElemUSel(elemUSel);
        }
        String brtypeName = Path.fromOSString((String)versionName).removeLastSegments(1).lastSegment();
        v.setBrtypeName(brtypeName);
        v.setActivityName(e.activityName);
        String portableVersionName = new Path(pathName).toPortableString().split("@@")[1];
        v.setVersionName(portableVersionName, feedback);
        return v;
    }

    private static CTLocation lookupVersionLocation(CCaseObjInfo versInfo) {
        String mtype = versInfo.getMtype();
        CTLocation versLoc = null;
        if (mtype.equals("symbolic link")) {
            versLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, versInfo.getUniversalSelector());
        } else {
            if (mtype.equals("view private object")) {
                return null;
            }
            versLoc = CTLocation.valueOf(CTLocation.Kind.VERSION, versInfo.getUniversalSelector());
        }
        return versLoc;
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public void doReadContent(OutputStream content, Resource accept, SrvcFeedback feedback) throws WvcmException {
        String pathName = this.getPathname(feedback);
        this.readContentInternalUsingPathname(pathName, content, feedback);
    }

    protected synchronized String getPathname(SrvcFeedback feedback) throws WvcmException {
        if (this._pathname == null) {
            this._pathname = this.getObjInfo(feedback).getPathName();
            if (this._pathname == null || this._pathname.length() == 0) {
                this._pathname = this.cc.getPathname(this.location().getDisplayName(), feedback);
            }
            if (this._pathname == null || this._pathname.length() == 0) {
                this._pathname = this.cc.getPathname(this.location().getDisplayName(), feedback);
            }
        }
        if (this._pathname == null || this._pathname.length() == 0) {
            throw new RuntimeException("pathname is null or nullstring for location: " + (Object)((Object)this.location()));
        }
        return this._pathname;
    }

    protected synchronized String getComment(SrvcFeedback feedback) throws WvcmException {
        String comment = null;
        CCaseVerInfo verInfo = null;
        CCaseObjInfo objInfo = this.getObjInfo(feedback);
        if (objInfo instanceof CCaseVerInfo) {
            verInfo = (CCaseVerInfo)objInfo;
        } else {
            String name = this.location().getDisplayName();
            verInfo = CCaseVerInfo.getVerInfos(this.cc, Collections.singletonList(name), feedback).get(name);
            this.setObjInfo(verInfo);
        }
        comment = verInfo.getComment();
        return comment;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            CTLocation myLoc = this.location();
            if (this.lookupBaseCcSubVobcomponentLoc(myLoc) != null) {
                return myLoc.string();
            }
            return super.getThisProperty(propertyName, configuration, feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getPathname(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(feedback);
        }
        if (propertyName.equals((Object)Version.COMMENT)) {
            return this.getComment(feedback);
        }
        if (propertyName.equals((Object)Version.ACTIVITY)) {
            return this.lookupActivity(feedback);
        }
        if (VERSION_HISTORY_PROPERTIES.contains(propertyName)) {
            return this.getVersionHistory(feedback).getThisProperty(propertyName, configuration, feedback);
        }
        if (propertyName.equals((Object)InteropUtilities.PN_SHA_256)) {
            return this.computeSha256Digest(feedback);
        }
        if (propertyName.equals((Object)Version.PREDECESSOR_LIST)) {
            return this.getPredecessorList(feedback);
        }
        if (propertyName.equals(CTProvider.PN_BRTYPE_DISPLAYNAME)) {
            return this.getBrtypeName(feedback);
        }
        if (propertyName.equals(CTProvider.PN_ACTIVITY_NAME)) {
            return this.getActivityName(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_NAME)) {
            return this.getVersionName(feedback);
        }
        if (propertyName.equals((Object)Resource.CREATOR_DISPLAY_NAME)) {
            return this.getOwner(feedback);
        }
        if (propertyName.equals((Object)InteropUtilities.PN_ATTRIBUTES)) {
            return this.getAttributes(feedback);
        }
        if (propertyName.equals((Object)InteropUtilities.PN_IS_OBSOLETE)) {
            return this.getIsObsolete(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public void setVersionName(String name, SrvcFeedback feedback) {
        this.VersionName = name;
    }

    public String getVersionName(SrvcFeedback feedback) throws WvcmException {
        if (this.VersionName == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTVersion_ERROR_VER_NAME_NOT_INITIALIZED, (Object)((Object)this.location())), WvcmException.ReasonCode.FORBIDDEN);
        }
        return this.VersionName;
    }

    public void setPredecessorList(List<CTVersion> preds, SrvcFeedback feedback) throws WvcmException {
        this.predecessorList = preds;
    }

    private List<CTVersion> getPredecessorList(SrvcFeedback feedback) throws WvcmException {
        if (this.predecessorList == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTVersion_ERROR_PRED_LIST_NOT_INITIALIZED, (Object)((Object)this.location())), WvcmException.ReasonCode.FORBIDDEN);
        }
        return this.predecessorList;
    }

    public void setBrtypeName(String name) {
        this.brtypeName = name;
    }

    public String getBrtypeName(SrvcFeedback feedback) throws WvcmException {
        if (this.brtypeName == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTVersion_ERROR_BRTYPE_NOT_INITIALIZED, (Object)((Object)this.location())), WvcmException.ReasonCode.FORBIDDEN);
        }
        return this.brtypeName;
    }

    public void setActivityName(String name) {
        this._activityName = name;
    }

    public String getActivityName(SrvcFeedback feedback) throws WvcmException {
        if (this._activityName == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTVersion_ERROR_ACTIVITY_NOT_INITIALIZED0, (Object)((Object)this.location())), WvcmException.ReasonCode.FORBIDDEN);
        }
        return this._activityName.isEmpty() ? null : this._activityName;
    }

    private Object computeSha256Digest(SrvcFeedback feedback) throws WvcmException {
        String pathName = this.getPathname(feedback);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            FileInputStream src = new FileInputStream(pathName);
            try {
                byte[] bytes = new byte[32768];
                int len = 0;
                while (len > -1) {
                    len = src.read(bytes);
                    if (len <= 0) continue;
                    md.update(bytes, 0, len);
                }
            }
            finally {
                src.close();
            }
            byte[] digestBytes = md.digest();
            int length = digestBytes.length;
            Byte[] resultBytes = new Byte[length];
            int i = 0;
            while (i < length) {
                resultBytes[i] = digestBytes[i];
                ++i;
            }
            return resultBytes;
        }
        catch (IOException exception) {
            throw new WvcmException(NLS.bind((String)Messages.CTResource_READ_FILE_FAILED_ERROR, (Object)pathName, (Object)pathName), null, WvcmException.ReasonCode.READ_FAILED, (Throwable)exception);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WvcmException("Could not get Message Digest for SHA 256", WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public synchronized CTElement getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CTLocation myLoc = this.location();
        CTLocation baseCcSubVobComponentLoc = this.lookupBaseCcSubVobcomponentLoc(myLoc);
        if (this._versionHistoryLocation == null) {
            String myLocString = myLoc.getDisplayName();
            String myVobSel = null;
            myVobSel = ObjSelUtils.isUniversalSelector(myLocString) ? ObjSelUtils.getObjSelVobSel(myLocString) : this.cc.getVobuuid(myLocString, feedback);
            String elemUsel = this.cc.getElementUsel(myLocString, myVobSel, feedback);
            if (elemUsel == null) {
                throw new IllegalStateException("Unexpected null value for element selector of version");
            }
            this._versionHistoryLocation = CTElement.createElemLocation(baseCcSubVobComponentLoc, elemUsel);
        }
        CTElement vh = (CTElement)provider.get((Location)this._versionHistoryLocation, feedback);
        if (baseCcSubVobComponentLoc != null) {
            vh = (CTElement)provider.createAndCacheCTResource(this._versionHistoryLocation, vh.getObjInfo(feedback), feedback);
        }
        return vh;
    }

    public void setActivityUSel(String uSel) {
        this._activityUSel = uSel;
    }

    public CTActivity lookupActivity(SrvcFeedback feedback) throws WvcmException {
        String activityId;
        CTActivity result = null;
        CTProvider p = this.provider();
        if (this._activityUSel == null) {
            String name = this.location().getDisplayName();
            activityId = this.cc.lookupVersionActivityName(name, feedback);
        } else {
            activityId = this._activityUSel;
        }
        result = CTActivity.valueOf(p, activityId, feedback);
        if (result != null && this._activityUSel == null) {
            this._activityUSel = result.getUniversalSelector(feedback);
        }
        return result;
    }

    protected CTLocation lookupBaseCcSubVobcomponentLoc(CTLocation myLoc) throws WvcmException {
        CTLocation baseCcSubVobComponentLoc = CTLocation.Kind.VERSION_IN_SVC.equals((Object)myLoc.getKind()) ? myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT) : null;
        return baseCcSubVobComponentLoc;
    }

    public void setElemUSel(String elemUSel) throws WvcmException {
        CTLocation myLoc = this.location();
        this._versionHistoryLocation = CTElement.createElemLocation(this.lookupBaseCcSubVobcomponentLoc(myLoc), elemUSel);
    }

    @Override
    public void clearPathname() {
        super.clearPathname();
        this._pathname = null;
    }

    public static CTResource lookupInSVC(CTLocation loc, CTProvider ctProvider, SrvcFeedback feedback) throws WvcmException {
        CTLocation symLinkVersLoc = loc.lookupContextLocation(CTLocation.Kind.SYMBOLIC_LINK_VERSION);
        CTLocation versionLoc = symLinkVersLoc != null ? symLinkVersLoc : loc.getContextLocation(CTLocation.Kind.VERSION);
        CTResource version = ctProvider.get((Location)versionLoc, feedback);
        CTVersion result = CTVersion.valueOf(ctProvider, loc, version.getObjInfo(feedback), feedback);
        return result;
    }

    public static CTLocation getVersionLocation(CTProvider p, boolean isBaseCc, String viewTag, String pathname, CCaseVerInfo verInfo, SrvcFeedback feedback) throws WvcmException {
        CTLocation result = CTVersion.lookupVersionLocation(p, isBaseCc, viewTag, pathname, verInfo, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTVersion_ERROR_COULD_NOT_GET_VERSION_LOC, (Object)verInfo.getUniversalSelector(), (Object)verInfo.getMtype()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static CTLocation lookupVersionLocation(CTProvider p, boolean isBaseCc, String viewTag, String pathname, CCaseObjInfo objInfo, SrvcFeedback feedback) throws WvcmException {
        CTLocation result = CTVersion.lookupVersionLocation(objInfo);
        if (result != null) {
            String baseCcSubVobComponentPath;
            String string = baseCcSubVobComponentPath = isBaseCc ? CTVersion.lookupBaseCcSubVobComponent(p, viewTag, pathname, feedback) : null;
            if (baseCcSubVobComponentPath != null) {
                CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, baseCcSubVobComponentPath);
                result = CTVersion.createVersionInBaseCcSubVobComponentLocation(result, compLoc);
            }
        }
        return result;
    }

    private static CTLocation createVersionInBaseCcSubVobComponentLocation(CTLocation versionLocation, CTLocation compLoc) {
        CTLocation result = CTLocation.createJoinedLocation(CTLocation.Kind.VERSION_IN_SVC, versionLocation.getDisplayName(), versionLocation, compLoc);
        return result;
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (Resource.COMMENT.equals(propertyName)) {
            if (value instanceof String) {
                String comment = (String)value;
                this.cc.setComment(this.location().getDisplayName(), comment, feedback);
                this.flush(feedback);
            }
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    private Map<String, String> getAttributes(SrvcFeedback feedback) throws WvcmException {
        String pathname = this.getPathname(feedback);
        return this.cc.getRawAttributesForGpath(pathname, feedback);
    }

    public void setIsObsolete(Boolean isObsolete) {
        this._isObsolete = isObsolete;
    }

    public Boolean getIsObsolete(SrvcFeedback feedback) throws WvcmException {
        return this._isObsolete;
    }
}

