/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.eclipse.core.runtime.Platform;

public class AnalyzerDebugUtils {
    private static final String SHOW_INDEX_TOKENS_ID = "/debug/showIndexTokens";
    public static final boolean SHOW_INDEX_TOKENS = Boolean.toString(true).equals(AnalyzerDebugUtils.getDebugOption("com.ibm.team.fulltext.common/debug/showIndexTokens"));
    private static final String SHOW_QUERY_ID = "/debug/showQuery";
    public static final boolean SHOW_QUERY = Boolean.toString(true).equals(AnalyzerDebugUtils.getDebugOption("com.ibm.team.fulltext.common/debug/showQuery"));
    private static final String SHOW_RESULT_EXPLANATION_ID = "/debug/showResultExplanation";
    public static final boolean SHOW_RESULT_EXPLANATION = Boolean.toString(true).equals(AnalyzerDebugUtils.getDebugOption("com.ibm.team.fulltext.common/debug/showResultExplanation"));

    public static void printTokens(Analyzer analyzer, Reader text) {
        AnalyzerDebugUtils.printTokens(analyzer, text, "ignore");
    }

    public static void printTokens(Analyzer analyzer, Reader text, String field) {
        if (!SHOW_INDEX_TOKENS) {
            return;
        }
        System.out.println();
        System.out.println();
        System.out.println(field);
        try {
            TokenStream stream = analyzer.tokenStream(field, text);
            PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
            TypeAttribute typeAttribute = (TypeAttribute)stream.getAttribute(TypeAttribute.class);
            TermAttribute termAttribute = (TermAttribute)stream.getAttribute(TermAttribute.class);
            int position = 0;
            while (stream.incrementToken()) {
                System.out.println();
                System.out.print(String.valueOf(position += positionIncrementAttribute.getPositionIncrement()) + ": ");
                System.out.print("[" + termAttribute.term() + ":" + offsetAttribute.startOffset() + " -> " + offsetAttribute.endOffset() + ": " + typeAttribute.type() + "]");
            }
        }
        catch (IOException iOException) {}
    }

    public static void printQuery(Query query) {
        if (!SHOW_QUERY) {
            return;
        }
        System.out.println(query.toString());
    }

    public static void print(BooleanQuery query) {
        StringBuilder builder = new StringBuilder();
        AnalyzerDebugUtils.print(query, builder, 0);
        System.out.println(builder.toString());
    }

    private static void print(BooleanQuery query, StringBuilder builder, int indent) {
        BooleanClause[] clauses;
        boolean needParens;
        boolean bl = needParens = (double)query.getBoost() != 1.0 || query.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            AnalyzerDebugUtils.appendIndent(builder, indent);
            builder.append("(\n");
            AnalyzerDebugUtils.appendIndent(builder, indent);
        }
        BooleanClause[] booleanClauseArray = clauses = query.getClauses();
        int n = clauses.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanClause clause = booleanClauseArray[n2];
            AnalyzerDebugUtils.appendIndent(builder, indent);
            if (clause.isProhibited()) {
                builder.append("[-]");
            } else if (clause.isRequired()) {
                builder.append("[+]");
            }
            Query subQuery = clause.getQuery();
            if (subQuery instanceof BooleanQuery) {
                builder.append("(\n");
                AnalyzerDebugUtils.print((BooleanQuery)subQuery, builder, indent + 1);
                builder.append("\n");
                AnalyzerDebugUtils.appendIndent(builder, indent);
                builder.append(")\n");
            } else {
                builder.append(subQuery.toString());
            }
            ++n2;
        }
        if (needParens) {
            builder.append("\n");
            AnalyzerDebugUtils.appendIndent(builder, indent);
            builder.append(")");
        }
    }

    private static void appendIndent(StringBuilder builder, int indent) {
        int i = 0;
        while (i < indent) {
            builder.append("   ");
            ++i;
        }
    }

    private static String getDebugOption(String option) {
        String property = option.replace('/', '.');
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        return Platform.getDebugOption((String)option);
    }
}

