/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.jdt.internal;

import com.ibm.team.fulltext.jdt.internal.IStackTraceDetector;
import com.ibm.team.fulltext.jdt.internal.StackTraceElement;
import com.ibm.team.fulltext.jdt.internal.StackTraceLineDetector;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class JavaStackTraceDetector
implements IStackTraceDetector {
    static final boolean DEBUG = false;
    private static final String JAVA_IDENTIFIER = "[\\w\\p{Sc}<>]+";
    private static final String JAVA_CLASS_NAME = "(([\\w\\p{Sc}<>]+\\.)*[\\w\\p{Sc}<>]+)";
    private static final Pattern STACK_TRACE_LINE_PATTERN = Pattern.compile("^\\s*at\\s+(([\\w\\p{Sc}<>]+\\.)*[\\w\\p{Sc}<>]+)\\.([\\w\\p{Sc}<>]+)\\([\\w\\p{Sc}<>]+\\.java:(\\S*)\\)");
    private static final Pattern NATIVE_STACK_TRACE_LINE_PATTERN = Pattern.compile("(([\\w\\p{Sc}<>]+\\.)*[\\w\\p{Sc}<>]+)\\.([\\w\\p{Sc}<>]+)\\(Native Method\\)");
    private static final Pattern LOCK_STACK_TRACE_LINE_PATTERN = Pattern.compile("- (locked|waiting on) (<|&lt;)0x[0-9a-f]*(>|&gt;) \\(a (([\\w\\p{Sc}<>]+\\.)*[\\w\\p{Sc}<>]+)\\)");
    private static final Pattern UNKOWN_SOURCE_STACK_TRACE_LINE_PATTERN = Pattern.compile("(([\\w\\p{Sc}<>]+\\.)*[\\w\\p{Sc}<>]+)\\.([\\w\\p{Sc}<>]+)\\(Unknown Source\\)");
    private static final Pattern DEBUG_STACK_TRACE_LINE_PATTERN = Pattern.compile("([\\w\\p{Sc}<>]+)(?:\\([\\w\\p{Sc}<>]+\\))??\\.([\\w\\p{Sc}<>]+)\\([^\\)]*\\) line: \\d+");
    private static final Pattern EXTENDED_STACK_TRACE_LINE_PATTERN = Pattern.compile("^\\s*at\\s+(([\\w\\p{Sc}<>]+\\.)*[\\w\\p{Sc}<>]+)\\.([\\w\\p{Sc}<>]+)\\([\\w\\p{Sc}<>]+\\.java\\([^\\)]*?\\)\\)");
    private static JavaStackTraceDetector fgDefault;
    private final StackTraceLineDetector[] fLineDetectors = new StackTraceLineDetector[]{new StackTraceLineDetector(STACK_TRACE_LINE_PATTERN, '.', 1, 3), new StackTraceLineDetector(NATIVE_STACK_TRACE_LINE_PATTERN, '.', 1, 3), new StackTraceLineDetector(LOCK_STACK_TRACE_LINE_PATTERN, '.', 4), new StackTraceLineDetector(UNKOWN_SOURCE_STACK_TRACE_LINE_PATTERN, '.', 1, 3), new StackTraceLineDetector(DEBUG_STACK_TRACE_LINE_PATTERN, '.', 1, 2), new StackTraceLineDetector(EXTENDED_STACK_TRACE_LINE_PATTERN, '.', 1, 3)};

    public static JavaStackTraceDetector getDefault() {
        if (fgDefault == null) {
            fgDefault = new JavaStackTraceDetector();
        }
        return fgDefault;
    }

    private JavaStackTraceDetector() {
    }

    @Override
    public Collection<StackTraceElement> getMatches(String line) {
        LinkedList<StackTraceElement> matches = new LinkedList<StackTraceElement>();
        int i = 0;
        while (i < this.fLineDetectors.length) {
            Collection<StackTraceElement> match = this.fLineDetectors[i].getMatches(line);
            if (!match.isEmpty()) {
                matches.addAll(match);
                break;
            }
            ++i;
        }
        return matches;
    }
}

