/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public interface ITeamRawRestServiceClient {
    public IRawRestClientConnection getConnection(URI var1) throws URISyntaxException;

    public static interface IRawRestClientConnection {
        public void addRequestHeader(String var1, String var2);

        public Response doGet() throws TeamServiceException, TeamRepositoryException;

        public Response doPost(InputStream var1, long var2, String var4) throws TeamServiceException, TeamRepositoryException;

        public Response doPut(InputStream var1, long var2, String var4) throws TeamServiceException, TeamRepositoryException;

        public Response doDelete() throws TeamServiceException, TeamRepositoryException;

        public Response doHead() throws TeamServiceException, TeamRepositoryException;

        public Response getResponse();

        public void release();

        public String getServiceUri();

        public static class Response {
            private final InputStream _responseStream;
            private final Map<String, String> _headers;
            private final int _statusCode;
            private String _statusText;

            public Response(InputStream responseStream, Map<String, String> headers, int statusCode, String statusText) {
                this._responseStream = responseStream;
                this._headers = headers;
                this._statusCode = statusCode;
                this._statusText = statusText;
            }

            public void close() {
                if (this._responseStream != null) {
                    try {
                        this._responseStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }

            public InputStream getResponseStream() {
                return this._responseStream;
            }

            public String getResponseHeader(String header) {
                return this._headers.get(header);
            }

            public Map<String, String> getAllResponseHeaders() {
                return this._headers;
            }

            public int getStatusCode() {
                return this._statusCode;
            }

            public String getStatusText() {
                return this._statusText;
            }

            public static enum StatusCode {
                OK,
                CREATED,
                NOT_FOUND,
                NOT_MODIFIED,
                ERROR;

            }
        }
    }
}

