/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.http.HttpRequest;

public class TransportUtils {
    public static void addUseridHeader(String userId, HttpRequest method) {
        if (userId == null) {
            return;
        }
        try {
            userId = URLEncoder.encode(userId, HttpUtil.CharsetEncoding.UTF8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        method.addHeader("X-com-ibm-team-userid", userId);
    }

    public static void addUseridHeader(String userId, HttpMethod method) {
        if (userId == null) {
            return;
        }
        try {
            userId = URLEncoder.encode(userId, HttpUtil.CharsetEncoding.UTF8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        method.addRequestHeader("X-com-ibm-team-userid", userId);
    }

    public static void setAcceptLanguageHeader(HttpRequest method) {
        String variant;
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer(locale.getLanguage());
        String country = locale.getCountry();
        if (country.length() > 0) {
            buffer.append('-').append(country);
        }
        if ((variant = locale.getVariant()).length() > 0) {
            buffer.append('-').append(variant);
        }
        String headerVal = buffer.toString();
        method.setHeader("Accept-Language", headerVal);
    }
}

