/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.services.event;

import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventService;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JMSQueueEventService
extends EventService
implements MessageListener,
ExceptionListener {
    private static final Logger log = Logger.getLogger(JMSQueueEventService.class);
    private Connection connection;
    private Session sessionOut;
    private Destination destinationOut;
    private MessageProducer msgProducerOut;
    private Session sessionIn;
    private Destination destinationIn;
    private MessageConsumer consumer;

    public JMSQueueEventService(String brokerURL, String consumerName, String queueName) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_USER, ActiveMQConnection.DEFAULT_PASSWORD, brokerURL);
        this.connection = connectionFactory.createConnection();
        this.connection.setClientID(consumerName);
        this.connection.setExceptionListener((ExceptionListener)this);
        this.sessionOut = this.connection.createSession(false, 1);
        this.destinationOut = this.sessionOut.createQueue(queueName);
        this.msgProducerOut = this.sessionOut.createProducer(this.destinationOut);
        this.msgProducerOut.setDeliveryMode(2);
        this.sessionIn = this.connection.createSession(false, 2);
        this.destinationIn = this.sessionIn.createQueue(queueName);
        this.consumer = this.sessionIn.createConsumer(this.destinationIn);
        this.consumer.setMessageListener((MessageListener)this);
    }

    public synchronized void start() throws Exception {
        this.connection.start();
        super.start();
    }

    public synchronized void shutdown() {
        try {
            this.msgProducerOut.close();
            this.sessionIn.close();
            this.sessionOut.close();
            this.connection.close();
        }
        catch (JMSException e) {
            log.error((Object)"JMSEventService failed to close connection to Broker.", (Throwable)e);
        }
        super.shutdown();
    }

    public void onException(JMSException e) {
        log.info((Object)"Exception occured.  Shutting down EventService.", (Throwable)e);
        try {
            this.shutdown();
        }
        catch (Exception err) {
            log.error((Object)"Failed to cleanly close EventService connections.", (Throwable)err);
        }
    }

    public void onMessage(Message msg) {
        Event event = null;
        if (msg instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)msg;
            try {
                String jsonString = textMsg.getText();
                JSONObject jsonObject = new JSONObject(jsonString);
                event = new Event(jsonObject);
            }
            catch (JMSException e) {
                throw new RuntimeException("Could not get Event from TextMessage.");
            }
            catch (JSONException e) {
                throw new RuntimeException("Re-creating Event from JSON string");
            }
        } else {
            throw new RuntimeException("Received unknown Message type (" + msg.getClass().getCanonicalName() + ") " + "in EventService.onMessage().");
        }
        log.debug((Object)("Received Event: " + event));
        super.run(event);
        try {
            msg.acknowledge();
        }
        catch (JMSException e) {
            log.error((Object)"Error acknowledging an event message", (Throwable)e);
        }
    }

    public void sendEvent(Event event) {
        if (this.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending Event: " + event));
            }
            try {
                TextMessage message = this.sessionOut.createTextMessage(event.getProperties().toString());
                this.msgProducerOut.send((Message)message);
            }
            catch (JMSException e) {
                log.error((Object)("Error sending sending Event(" + event + "): "), (Throwable)e);
            }
        } else {
            log.error((Object)"Tried to send event before EventService has started.");
            throw new RuntimeException("Tried to send event before EventService has started.");
        }
    }
}

