/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AbstractAttributesByTypeAndStateAdvisor;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.AttributesAdvisorHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.Collection;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReadOnlyAttributesByTypeAndStateAdvisor
extends AbstractAttributesByTypeAndStateAdvisor {
    public static final String ADVISOR_ID = "com.ibm.team.workitem.advisor.readOnlyAttributesByTypeAndState";
    private static final String ADVISOR_INFO_ID = "readOnlyAttributesByTypeAndState";

    @Override
    protected void processAttributes(ISaveParameter saveParameter, IWorkItem newWorkItem, Collection<String> attributeIds, IWorkItemCommon workItemCommon, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem oldWorkItem;
        IAuditable oldAuditable = saveParameter.getOldState();
        if (!(oldAuditable instanceof IWorkItem)) {
            IWorkItemType workItemType = workItemCommon.findWorkItemType(newWorkItem.getProjectArea(), newWorkItem.getWorkItemType(), monitor);
            oldWorkItem = ((WorkItemCommon)workItemCommon).createWorkItem(workItemType, monitor);
        } else {
            oldWorkItem = (IWorkItem)oldAuditable;
        }
        for (String attributeId : attributeIds) {
            IAttribute attribute = workItemCommon.findAttribute(newWorkItem.getProjectArea(), attributeId, monitor);
            if (attribute == null || !oldWorkItem.hasAttribute(attribute) || !newWorkItem.hasAttribute(attribute)) continue;
            this.processAttribute(saveParameter, workItemCommon.getAuditableCommon(), newWorkItem, oldWorkItem, attribute, collector, monitor);
        }
    }

    private void processAttribute(ISaveParameter saveParameter, IAuditableCommon auditableCommon, IWorkItem newWorkItem, IWorkItem oldWorkItem, IAttribute attribute, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object newValue;
        Object oldValue;
        if (IWorkItem.COMMENTS_PROPERTY.equals(attribute.getIdentifier())) {
            oldValue = oldWorkItem.getComments().getContents().length;
            newValue = newWorkItem.getComments().getContents().length;
        } else {
            oldValue = attribute.getValue(auditableCommon, oldWorkItem, monitor);
            newValue = attribute.getValue(auditableCommon, newWorkItem, monitor);
        }
        if (!AttributesAdvisorHelper.equals(newValue, oldValue)) {
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute), this.getDescription(newWorkItem, attribute, userTimeZone), ADVISOR_ID);
            info.setProblemObject((Object)newWorkItem.getItemHandle());
            info.setData(AttributesAdvisorHelper.createData(newWorkItem, attribute, ADVISOR_INFO_ID));
            collector.addInfo((IReportInfo)info);
        }
    }

    private String getSummary(IAttribute attribute) {
        return NLS.bind((String)Messages.getString("ReadOnlyAttributesByTypeAndStateAdvisor.ATTRIBUTE_MODIFIED_SUMMARY"), (Object)attribute.getDisplayName(), (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("ReadOnlyAttributesByTypeAndStateAdvisor.ATTRIBUTE_MODIFIED_DESCRIPTION"), (Object)attribute.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone)});
    }
}

