/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class IterationSelectionAlgorithm {
    private final int fMaxSize;
    private final IAuditableCommon fAuditableCommon;

    public IterationSelectionAlgorithm(IAuditableCommon auditableCommon) {
        this(Integer.MAX_VALUE, auditableCommon);
    }

    public IterationSelectionAlgorithm(int maxSize, IAuditableCommon auditableCommon) {
        this.fMaxSize = maxSize;
        this.fAuditableCommon = auditableCommon;
    }

    public List<IIteration> getIterations(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IIteration> result = new ArrayList<IIteration>();
        Date now = new Date();
        Map<IDevelopmentLine, List<IIteration>> iterationsMap = this.getIterationsByDevelopmentLine(item, monitor);
        while (result.size() < this.fMaxSize && this.hasIterations(iterationsMap)) {
            if (result.size() < this.fMaxSize) {
                this.addNextIterationWithEnddateAfterNow(result, iterationsMap, now);
            }
            if (result.size() >= this.fMaxSize) continue;
            this.addNextIterationWithNoEnddate(result, iterationsMap);
        }
        return result;
    }

    private void addNextIterationWithNoEnddate(List<IIteration> result, Map<IDevelopmentLine, List<IIteration>> iterationsByDevLine) {
        block0: for (List<IIteration> itersInDevLine : iterationsByDevLine.values()) {
            if (result.size() >= this.fMaxSize) continue;
            Collections.sort(itersInDevLine, new IdInverseComparator());
            Iterator<IIteration> it = itersInDevLine.iterator();
            while (it.hasNext()) {
                IIteration cur = it.next();
                if (cur.getEndDate() != null || result.contains(cur)) continue;
                result.add(cur);
                it.remove();
                continue block0;
            }
        }
    }

    private void addNextIterationWithEnddateAfterNow(List<IIteration> result, Map<IDevelopmentLine, List<IIteration>> iterationsByDevLine, Date now) {
        block0: for (List<IIteration> itersInDevLine : iterationsByDevLine.values()) {
            if (result.size() >= this.fMaxSize) continue;
            Collections.sort(itersInDevLine, new EnddateComparator(false));
            Iterator<IIteration> it = itersInDevLine.iterator();
            while (it.hasNext()) {
                IIteration cur = it.next();
                if (cur.getEndDate() == null || !cur.getEndDate().after(now) || result.contains(cur)) continue;
                result.add(cur);
                it.remove();
                continue block0;
            }
        }
    }

    private boolean hasIterations(Map<IDevelopmentLine, List<IIteration>> iterationsMap) {
        for (List<IIteration> cur : iterationsMap.values()) {
            if (cur.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private Map<IDevelopmentLine, List<IIteration>> getIterationsByDevelopmentLine(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        Date now = new Date();
        LinkedHashMap<IDevelopmentLine, List<IIteration>> result = new LinkedHashMap<IDevelopmentLine, List<IIteration>>();
        for (IDevelopmentLine curDevLine : this.getDevelopmentLinesFilteredByCategory(item, monitor)) {
            List<IIteration> allIterations = IterationsHelper.findIterations(this.fAuditableCommon, (IDevelopmentLineHandle)curDevLine, ItemProfile.ITERATION_DEFAULT, false, monitor);
            ArrayList<IIteration> curIterations = new ArrayList<IIteration>();
            for (IIteration cur : allIterations) {
                if (cur.getEndDate() != null && cur.getEndDate().before(now)) continue;
                curIterations.add(cur);
            }
            result.put(curDevLine, curIterations);
        }
        return result;
    }

    private List<IDevelopmentLine> getDevelopmentLinesFilteredByCategory(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategoryHandle categoryHandle;
        ArrayList<IDevelopmentLine> result = new ArrayList<IDevelopmentLine>();
        IDevelopmentLine defaultDevLine = this.fAuditableCommon.findDefaultDevelopmentLine(item.getProjectArea(), monitor);
        if (defaultDevLine != null) {
            result.add(defaultDevLine);
        }
        if ((categoryHandle = item.getCategory()) != null) {
            ICategory category = this.fAuditableCommon.resolveAuditable(categoryHandle, ICategory.DEFAULT_PROFILE, monitor);
            for (ITeamAreaHandle curTeam : category.getAssociatedTeamAreas()) {
                IDevelopmentLine curDevLine = this.fAuditableCommon.getDevelopmentLine(curTeam, monitor);
                if (curDevLine == null || curDevLine.sameItemId((IItemHandle)defaultDevLine)) continue;
                result.add(curDevLine);
            }
        }
        return result;
    }

    public static final class EnddateComparator
    implements Comparator<IIteration> {
        private final boolean fInverse;

        public EnddateComparator(boolean inverse) {
            this.fInverse = inverse;
        }

        @Override
        public int compare(IIteration iter1, IIteration iter2) {
            return this.fInverse ? this.compare0(iter2, iter1) : this.compare0(iter1, iter2);
        }

        private int compare0(IIteration iter1, IIteration iter2) {
            if (iter1 == null) {
                return iter2 == null ? 0 : 1;
            }
            if (iter2 == null) {
                return -1;
            }
            Date enddate1 = iter1.getEndDate();
            Date enddate2 = iter2.getEndDate();
            if (enddate1 == null) {
                return enddate2 == null ? 0 : 1;
            }
            if (enddate2 == null) {
                return -1;
            }
            return enddate1.compareTo(enddate2);
        }
    }

    public static final class IdInverseComparator
    implements Comparator<IIteration> {
        private final Collator fCollator = Collator.getInstance();

        @Override
        public int compare(IIteration iter1, IIteration iter2) {
            if (iter1 == null) {
                return iter2 == null ? 0 : -1;
            }
            if (iter2 == null) {
                return 1;
            }
            String id1 = iter1.getId();
            String id2 = iter2.getId();
            if (id1 == null) {
                return id2 == null ? 0 : -1;
            }
            if (id2 == null) {
                return 1;
            }
            return this.fCollator.compare(id2, id1);
        }
    }
}

