/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringInputArg;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PartOfIntervalOperation
extends AttributeOperation {
    private final boolean fInvert;

    public PartOfIntervalOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean result = this.internalEvaluate(left, right, context, monitor);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (left instanceof IIterationHandle && right instanceof IIterationHandle) {
            IIterationHandle leftHandle = (IIterationHandle)left;
            IIterationHandle rightHandle = (IIterationHandle)right;
            while (leftHandle != null) {
                if (leftHandle.sameItemId((IItemHandle)rightHandle)) {
                    return true;
                }
                IIteration iteration = leftHandle instanceof IIteration ? (IIteration)leftHandle : context.getAuditableCommon().resolveAuditable((IAuditableHandle)leftHandle, ItemProfile.ITERATION_DEFAULT, monitor);
                leftHandle = iteration.getParent();
            }
        }
        return false;
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (context.getValue() == null) {
            return (this.fInvert ? NOT_EQUALS : EQUALS).getPredicate(context, monitor);
        }
        IIterationHandle parent = (IIterationHandle)context.getValue();
        List<IIteration> iterations = IterationsHelper.findAllIterations(context.getAuditableCommon(), new IIterationHandle[]{parent}, ItemProfile.ITERATION_DEFAULT, true, monitor);
        ArrayList<IItemHandleInputArg> arguments = new ArrayList<IItemHandleInputArg>(iterations.size());
        if (!iterations.isEmpty()) {
            for (IIteration iteration : iterations) {
                arguments.add(context.getQuery().newItemHandleArg());
                context.addParameter(iteration.getItemHandle());
            }
        } else {
            arguments.add(context.getQuery().newItemHandleArg());
            context.addParameter(parent);
        }
        IItemHandleInputArg[] inputArg = arguments.toArray(new IItemHandleInputArg[arguments.size()]);
        IPredicate predicate = null;
        if (context.getAttribute().isStateExtension()) {
            IStringInputArg key = context.createStateExtensionKey();
            IDynamicQueryModel stateExtensionQueryModel = context.getStateExtensionQueryModel();
            predicate = stateExtensionQueryModel._inValues((IString)key, (IFilterElement[])inputArg);
            if (this.fInvert) {
                predicate = predicate._not()._or(stateExtensionQueryModel._isNullValue((IString)key));
            }
        } else {
            predicate = ((ISingleItemQueryModel)context.getReference())._in(inputArg);
            if (this.fInvert) {
                predicate = predicate._not()._or(context.getReference()._isNull());
            }
        }
        return predicate;
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }
}

