/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.scripting;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DateUtils;
import com.ibm.team.workitem.api.common.WorkItem;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributevaluelabelprovider.IAttributeValueLabelProvider;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WorkItemAPIType
implements WorkItem {
    private final IWorkItem fSubject;
    private final Map<String, String> fMapAttributeToLabel;
    private final IWorkItemCommon fWorkItemCommon;
    private IWorkflowInfo fWorkFlowInfo;

    public WorkItemAPIType(IWorkItem workItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fSubject = workItem;
        this.fWorkItemCommon = workItemCommon;
        this.fMapAttributeToLabel = new HashMap<String, String>();
        this.fWorkFlowInfo = null;
    }

    public Object getValue(String attributeId) {
        Object value = null;
        com.ibm.team.workitem.common.internal.model.WorkItem workItem = (com.ibm.team.workitem.common.internal.model.WorkItem)this.fSubject;
        EObject eObject = (EObject)workItem.getAdapter(EObject.class);
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(attributeId);
        value = feature == null ? this.get(attributeId, workItem.getStringExtensions(), workItem.getMediumStringExtensions(), workItem.getLargeStringExtensions(), workItem.getIntExtensions(), workItem.getLongExtensions(), workItem.getBooleanExtensions(), workItem.getTimestampExtensions(), workItem.getBigDecimalExtensions(), workItem.getItemExtensions()) : eObject.eGet(feature);
        if (value instanceof IItemHandle) {
            value = ((IItemHandle)value).getItemId().getUuidValue();
        } else if (value instanceof Timestamp) {
            value = DateUtils.formatTimeRFC3339((Date)((Timestamp)value));
        } else if (value instanceof BigDecimal) {
            value = value.toString();
        } else if (!(value instanceof String || value instanceof Number || value instanceof Boolean)) {
            value = null;
        }
        return value;
    }

    public String getLabel(String attributeId) {
        String label = this.fMapAttributeToLabel.get(attributeId);
        if (label == null) {
            try {
                IAttribute attribute = this.fWorkItemCommon.findAttribute(this.fSubject.getProjectArea(), attributeId, null);
                if (this.fSubject.isAttributeSet(attribute)) {
                    Object value = this.fSubject.getValue(attribute);
                    if (this.fWorkFlowInfo == null) {
                        this.fWorkFlowInfo = this.fWorkItemCommon.findWorkflowInfo(this.fSubject, null);
                    }
                    IAttributeValueLabelProvider labelProvider = this.fWorkItemCommon.createLabelProvider(attribute, this.fWorkFlowInfo);
                    label = labelProvider.getText(value, null);
                }
            }
            catch (TeamRepositoryException e) {
                label = "";
                WorkItemCommonPlugin.log("Problems evaluating label of attribute " + attributeId, (Exception)((Object)e));
            }
            this.fMapAttributeToLabel.put(attributeId, label);
        }
        return label;
    }

    public boolean isAttributeSet(String attributeId) {
        com.ibm.team.workitem.common.internal.model.WorkItem workItem = (com.ibm.team.workitem.common.internal.model.WorkItem)this.fSubject;
        if (AttributeIdentifiers.ATTRIBUTE_LIST.contains(attributeId)) {
            return workItem.isPropertySet(attributeId);
        }
        for (String property : IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES) {
            if (workItem.isPropertySet(property)) continue;
            return false;
        }
        return this.containsKey(attributeId, workItem.getStringExtensions(), workItem.getMediumStringExtensions(), workItem.getLargeStringExtensions(), workItem.getIntExtensions(), workItem.getLongExtensions(), workItem.getBooleanExtensions(), workItem.getTimestampExtensions());
    }

    private Object get(String attributeId, Map<?, ?> ... extensions) {
        Map<?, ?>[] mapArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> map = mapArray[n2];
            if (map.containsKey(attributeId)) {
                return map.get(attributeId);
            }
            ++n2;
        }
        return null;
    }

    private boolean containsKey(String attributeId, Map<?, ?> ... extensions) {
        Map<?, ?>[] mapArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> map = mapArray[n2];
            if (map.containsKey(attributeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

