/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;

public final class LocalizationContext {
    private static final String DATE_FORMAT_OVERRIDE_PROPERTY = "com.ibm.team.workitem.longDateFormat";
    private final IAuditableCommon fAuditableCommon;
    private final boolean fUseUserLocales;
    private final List<ULocale> fLocales;

    public static LocalizationContext getDefault() {
        return new LocalizationContext(null, false, Collections.singletonList(ULocale.getDefault()));
    }

    public static LocalizationContext createUserContext(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return new LocalizationContext(auditableCommon, true, Collections.<ULocale>emptyList());
    }

    public static LocalizationContext createProjectAreaContext(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ULocale locale = LocalizationContext.findProjectAreaLocale(auditableCommon, projectArea, monitor);
        if (locale != null) {
            return new LocalizationContext(auditableCommon, false, Collections.singletonList(locale));
        }
        return LocalizationContext.getDefault();
    }

    public static LocalizationContext createProjectAreaContext(IAuditableCommon auditableCommon, IProjectArea projectArea) {
        ULocale locale = null;
        String id = ((ProjectArea)projectArea).getLocale();
        if (id != null && id.trim().length() > 0) {
            locale = new ULocale(id);
        }
        if (locale != null) {
            return new LocalizationContext(auditableCommon, false, Collections.singletonList(locale));
        }
        return LocalizationContext.getDefault();
    }

    public static LocalizationContext createCustomContext(List<ULocale> locales) {
        return new LocalizationContext(null, false, locales);
    }

    public static LocalizationContext createCustomContext(Locale locale) {
        return new LocalizationContext(null, false, Collections.singletonList(ULocale.forLocale((Locale)locale)));
    }

    public static LocalizationContext createCustomContext(Enumeration<Locale> locales) {
        ArrayList<ULocale> list = new ArrayList<ULocale>();
        while (locales.hasMoreElements()) {
            list.add(ULocale.forLocale((Locale)locales.nextElement()));
        }
        return new LocalizationContext(null, false, list);
    }

    public static DateFormat createDateTimeFormat(LocalizationContext context, int dateStyle, int timeStyle) {
        if (context != null && context.fLocales != null && !context.fLocales.isEmpty()) {
            ULocale locale = context.fLocales.get(0);
            if (dateStyle != -1 && timeStyle != -1) {
                return DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (ULocale)locale);
            }
            if (timeStyle != -1) {
                if (LocalizationContext.useLongDateFormat(timeStyle, locale)) {
                    return DateFormat.getTimeInstance((int)1, (ULocale)locale);
                }
                return DateFormat.getTimeInstance((int)timeStyle, (ULocale)locale);
            }
            return DateFormat.getDateInstance((int)dateStyle, (ULocale)locale);
        }
        if (dateStyle != -1 && timeStyle != -1) {
            return DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle);
        }
        if (dateStyle != -1) {
            return DateFormat.getDateInstance((int)dateStyle);
        }
        return DateFormat.getTimeInstance((int)timeStyle);
    }

    public static NumberFormat createDecimalFormat(LocalizationContext context) {
        NumberFormat format = null;
        if (context != null && context.fLocales != null && !context.fLocales.isEmpty()) {
            ULocale locale = context.fLocales.get(0);
            format = DecimalFormat.getInstance(locale.toLocale());
        } else {
            format = DecimalFormat.getInstance();
        }
        format.setMaximumFractionDigits(Integer.MAX_VALUE);
        format.setMaximumIntegerDigits(Integer.MAX_VALUE);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).setParseBigDecimal(true);
        }
        return format;
    }

    private static boolean useLongDateFormat(int timeStyle, ULocale locale) {
        if (timeStyle != 0) {
            return false;
        }
        if ("hr".equals(locale.getLanguage()) && "HR".equals(locale.getCountry())) {
            return true;
        }
        return System.getProperty(DATE_FORMAT_OVERRIDE_PROPERTY) != null;
    }

    private static ULocale findProjectAreaLocale(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea item = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        String id = ((ProjectArea)item).getLocale();
        if (id != null && id.trim().length() > 0) {
            return new ULocale(id);
        }
        return null;
    }

    private LocalizationContext(IAuditableCommon auditableCommon, boolean useUserLocales, List<ULocale> locales) {
        this.fAuditableCommon = auditableCommon;
        this.fUseUserLocales = useUserLocales;
        this.fLocales = locales;
    }

    public String getString(Class<?> messages, String bundleName, String key) {
        if (this.fUseUserLocales) {
            IAuditableCommon auditableCommon = this.fAuditableCommon.getPeer(IAuditableCommon.class);
            for (ULocale locale : ((AuditableCommon)auditableCommon).getUserLocales()) {
                try {
                    return this.getString(messages, bundleName, key, locale);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            try {
                return this.getString(messages, bundleName, key, ULocale.getDefault());
            }
            catch (MissingResourceException missingResourceException) {}
        }
        for (ULocale locale : this.fLocales) {
            try {
                return this.getString(messages, bundleName, key, locale);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        try {
            return this.getString(messages, bundleName, key, new ULocale("", "", ""));
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    private String getString(Class<?> messages, String bundleName, String key, ULocale locale) {
        ClassLoader classLoader = messages.getClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale.toLocale(), classLoader);
        if (!"".equals(locale.getLanguage()) && !resourceBundle.getLocale().getLanguage().equals(locale.getLanguage())) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) && "".equals(resourceBundle.getLocale().getLanguage())) {
                return resourceBundle.getString(key);
            }
            throw new MissingResourceException(null, messages.getName(), key);
        }
        return resourceBundle.getString(key);
    }

    public Collator getCollator() {
        if (this.fLocales != null && !this.fLocales.isEmpty()) {
            ULocale locale = this.fLocales.get(0);
            return Collator.getInstance((ULocale)locale);
        }
        return Collator.getInstance();
    }
}

