/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class ChineseTokenizerWorkaroundFilter
extends TokenFilter {
    private OffsetAttribute offsetAttribute;
    private CharTermAttribute charTermAttribute;

    public ChineseTokenizerWorkaroundFilter(TokenStream input) {
        super(input);
        this.offsetAttribute = (OffsetAttribute)input.getAttribute(OffsetAttribute.class);
        this.charTermAttribute = (CharTermAttribute)input.getAttribute(CharTermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.offsetAttribute.endOffset() - this.offsetAttribute.startOffset() != 1) {
            return true;
        }
        char c = this.charTermAttribute.charAt(0);
        if (c > '\ud800') {
            if (!this.input.incrementToken()) {
                return false;
            }
            int length = this.charTermAttribute.length();
            char[] buffer = this.charTermAttribute.buffer();
            char[] newBuffer = new char[length + 1];
            newBuffer[0] = c;
            System.arraycopy(buffer, 0, newBuffer, 1, length);
            this.charTermAttribute.setEmpty().copyBuffer(newBuffer, 0, length + 1);
            this.offsetAttribute.setOffset(this.offsetAttribute.startOffset() - 1, this.offsetAttribute.endOffset());
        }
        return true;
    }
}

