/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

public final class SplitLinesTokenizer
extends Tokenizer {
    private static final int IO_BUFFER_SIZE = 1024;
    private final StringBuilder fBuffer = new StringBuilder();
    private final char[] fIoBuffer = new char[1024];
    private int fBufferIndex;
    private int fDataLen;
    private ArtifactAttribute attribute = ArtifactAttributeImpl.addAttributeToStream((TokenStream)this);

    public SplitLinesTokenizer(Reader in) {
        super(in);
    }

    public boolean incrementToken() throws IOException {
        this.fBuffer.setLength(0);
        while (true) {
            char c;
            if (this.fBufferIndex >= this.fDataLen) {
                this.fDataLen = this.input.read(this.fIoBuffer);
                this.fBufferIndex = 0;
            }
            if (this.fDataLen == -1) {
                if (this.fBuffer.length() > 0) break;
                return false;
            }
            if (this.isTokenChar(c = this.fIoBuffer[this.fBufferIndex++])) {
                this.fBuffer.append(c);
                continue;
            }
            if (this.fBuffer.length() > 0) break;
        }
        this.attribute.setTermBuffer(this.fBuffer.toString());
        this.attribute.setOffset(0, this.fBuffer.length());
        this.attribute.setType("word");
        return true;
    }

    private boolean isTokenChar(char c) {
        return c != '\n' && c != '\r';
    }
}

