/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.internal.client.IProcessInternalClientService;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AuditableClientProcess
implements IAuditableCommonProcess {
    private IAuditableClient fAuditableClient;
    private IClientProcess fClientProcess;
    private IProcessInternalClientService fProcessInternalClientService;

    public AuditableClientProcess(IAuditableClient auditableClient, IClientProcess clientProcess, IProcessInternalClientService processInternalClientService) {
        this.fAuditableClient = auditableClient;
        this.fClientProcess = clientProcess;
        this.fProcessInternalClientService = processInternalClientService;
    }

    public List getDevelopmentLines(IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ItemProfile profile = ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")});
        IProjectArea projectArea = (IProjectArea)this.fAuditableClient.resolveAuditable((IAuditableHandle)this.fClientProcess.getProjectArea(), profile, monitor);
        return this.fAuditableClient.resolveAuditablesPermissionAware(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
    }

    public IDevelopmentLine getDevelopmentLine(ITeamAreaHandle teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAuditableCommon().getDevelopmentLine(teamArea, monitor);
    }

    public IProcessConfigurationData findProcessConfiguration(String configurationDataPoint, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.fClientProcess.getProjectConfigurationData(configurationDataPoint, monitor);
    }

    public IAdvisorDeclaration findAdvisorDeclaration(IProcessAreaHandle processArea, IDevelopmentLine developmentLine, String advisableOperationId, String operationAdvisorId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findAdvisorDeclaration(processArea, advisableOperationId, operationAdvisorId, monitor);
    }

    public IAdvisorDeclaration findAdvisorDeclaration(IProcessAreaHandle processArea, String advisableOperationId, String operationAdvisorId, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IAdvisorDeclaration> declarations = this.findAdvisorDeclarations(processArea, advisableOperationId, operationAdvisorId, monitor);
        if (declarations.isEmpty()) {
            return null;
        }
        return declarations.get(0);
    }

    public List<IAdvisorDeclaration> findAdvisorDeclarations(IProcessAreaHandle processArea, String advisableOperationId, String operationAdvisorId, IProgressMonitor monitor) throws TeamRepositoryException {
        IAdvisorDeclaration[] advisorDeclarations;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IAdvisorDeclaration> declarations = new ArrayList<IAdvisorDeclaration>(2);
        IProcessArea area = (IProcessArea)this.fAuditableClient.resolveAuditable((IAuditableHandle)processArea, ItemProfile.createFullProfile((IItemType)processArea.getItemType()), monitor);
        IAdvisorDeclaration[] iAdvisorDeclarationArray = advisorDeclarations = this.fClientProcess.getAdvisorDeclarations(area, advisableOperationId, monitor);
        int n = advisorDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            IAdvisorDeclaration advisorDeclaration = iAdvisorDeclarationArray[n2];
            if (advisorDeclaration.getIdentifier().equals(operationAdvisorId)) {
                declarations.add(advisorDeclaration);
            }
            ++n2;
        }
        return declarations;
    }

    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.fClientProcess.adviseAndExecute(operation, monitor);
    }

    public IDevelopmentLine findDefaultDevelopmentLine(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAuditableCommon().findDefaultDevelopmentLine(this.getProjectArea(), monitor);
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fClientProcess.getProjectArea();
    }

    public IAuditableCommon getAuditableCommon() {
        return this.fAuditableClient;
    }

    public IProcessAttachment getProcessAttachment(String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        if (attachmentPath != null) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ItemProfile profile = ItemProfile.createFullProfile((IItemType)this.fClientProcess.getProjectArea().getItemType());
            IProjectArea projectArea = (IProjectArea)this.fAuditableClient.resolveAuditable((IAuditableHandle)this.fClientProcess.getProjectArea(), profile, monitor);
            return this.fClientProcess.getProcessAttachment((IProcessArea)projectArea, attachmentPath, monitor);
        }
        return null;
    }

    public IProcessAttachment[] getProcessAttachments(IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ItemProfile profile = ItemProfile.createFullProfile((IItemType)this.fClientProcess.getProjectArea().getItemType());
        IProjectArea projectArea = (IProjectArea)this.fAuditableClient.resolveAuditable((IAuditableHandle)this.fClientProcess.getProjectArea(), profile, monitor);
        return this.fClientProcess.getProcessAttachments((IProcessArea)projectArea, monitor);
    }

    public List<IRole> getRoles(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return Arrays.asList(this.fClientProcess.getRoles(processArea, monitor));
    }

    public List<IRole> getContributorRoles(IContributorHandle contributor, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return Arrays.asList(this.fClientProcess.getContributorRoles(contributor, processArea, monitor));
    }

    public IContributorHandle[] getContributorsWithRole(IContributorHandle[] contributors, IProcessArea processArea, String[] roleIds, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fProcessInternalClientService.getContributorsWithRole(contributors, (IProcessAreaHandle)processArea, roleIds, monitor);
    }

    public boolean[] getPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fClientProcess.getPermittedActions(processArea, operationId, actions, monitor);
    }

    public boolean[] getPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fClientProcess.getPermittedActions(projectOperationId, actions, monitor);
    }
}

