/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import java.io.Serializable;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class UUID
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1548313159849892768L;
    private static char[] LASTCHAR_DIGITS = "AQgw".toCharArray();
    private static final char[] BASE64_DIGITS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char UUID_STARTS_WITH = '_';
    private static final int UUID_CHAR_LENGTH = 23;
    private static final char MAX_UUID_CHAR = '\u0080';
    private static final int[] DIGIT_MAP = UUID.computeInverseMap(BASE64_DIGITS);
    private static final int[] LASTCHAR_DIGIT_MAP = UUID.computeInverseMap(LASTCHAR_DIGITS);
    private final long msb;
    private final long lsb;

    public static UUID generate() {
        return UUID.createFrom(EcoreUtil.generateUUID().toCharArray());
    }

    public static UUID valueOf(String uuidValue) {
        if (uuidValue == null) {
            throw new IllegalArgumentException("null UUID");
        }
        char[] trimmedValue = uuidValue.trim().toCharArray();
        if (!UUID.validateUUID(trimmedValue)) {
            boolean shouldLogInvalidUUID = Boolean.valueOf(System.getProperty("com.ibm.team.repository.common.UUID.dumpInvalidUUIDsToStderr", "false"));
            if (shouldLogInvalidUUID) {
                System.err.println("com.ibm.team.repository.common.UUID.valueOf(String) invalidUUID: " + uuidValue);
            }
            throw new IllegalArgumentException(String.format("invalid UUID", new Object[0]));
        }
        return UUID.createFrom(trimmedValue);
    }

    private static UUID createFrom(char[] trimmedValue) {
        long nextBits;
        char next;
        long msb = 0L;
        int idx = 1;
        while (idx < 11) {
            next = trimmedValue[idx];
            nextBits = DIGIT_MAP[next];
            msb <<= 6;
            msb |= nextBits;
            ++idx;
        }
        next = trimmedValue[11];
        nextBits = DIGIT_MAP[next];
        msb <<= 4;
        msb |= nextBits >> 2;
        long lsb = nextBits & 3L;
        int idx2 = 12;
        while (idx2 < 22) {
            next = trimmedValue[idx2];
            nextBits = DIGIT_MAP[next];
            lsb <<= 6;
            lsb |= nextBits;
            ++idx2;
        }
        next = trimmedValue[22];
        nextBits = LASTCHAR_DIGIT_MAP[next];
        lsb <<= 2;
        return new UUID(msb, lsb |= nextBits);
    }

    public int hashCode() {
        return (int)(this.msb ^ this.lsb ^ this.msb >> 32 ^ this.lsb >> 32);
    }

    public String getUuidValue() {
        char[] result = new char[23];
        result[0] = 95;
        long localLsb = this.lsb;
        result[22] = LASTCHAR_DIGITS[(int)(localLsb & 3L)];
        localLsb >>>= 2;
        int i = 21;
        while (i >= 12) {
            result[i] = BASE64_DIGITS[(int)(localLsb & 0x3FL)];
            localLsb >>>= 6;
            --i;
        }
        long localMsb = this.msb;
        result[11] = BASE64_DIGITS[(int)(localLsb | (localMsb & 0xFL) << 2)];
        localMsb >>>= 4;
        int i2 = 10;
        while (i2 != 0) {
            result[i2] = BASE64_DIGITS[(int)(localMsb & 0x3FL)];
            localMsb >>>= 6;
            --i2;
        }
        return new String(result);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID uuid = (UUID)obj;
        return this.msb == uuid.msb && this.lsb == uuid.lsb;
    }

    public int compareTo(Object o) {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            int result = this.unsignedCompare(this.msb, uuid.msb);
            if (result == 0) {
                return this.unsignedCompare(this.lsb, uuid.lsb);
            }
            return result;
        }
        return 1;
    }

    private int unsignedCompare(long l1, long l2) {
        if (l1 == l2) {
            return 0;
        }
        long msb1 = l1 >>> 32;
        long msb2 = l2 >>> 32;
        if (msb1 == msb2) {
            long lsb1 = l1 & 0xFFFFFFFFFFFFFFFFL;
            long lsb2 = l2 & 0xFFFFFFFFFFFFFFFFL;
            return lsb1 < lsb2 ? -1 : 1;
        }
        return msb1 < msb2 ? -1 : 1;
    }

    public String toString() {
        return String.format("[UUID %s]", this.getUuidValue());
    }

    private static boolean validateUUID(char[] possibleUUID) {
        int len = possibleUUID.length;
        if (len != 23) {
            return false;
        }
        char[] uuidChars = possibleUUID;
        char c = uuidChars[0];
        if (c != '_') {
            return false;
        }
        int i = 0;
        while (i < len) {
            c = uuidChars[i];
            if (c > '\u0080' || DIGIT_MAP[c] == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private UUID(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    private static int[] computeInverseMap(char[] digits) {
        int[] digitMap = new int[129];
        int i = 0;
        while (i < digitMap.length) {
            digitMap[i] = -1;
            ++i;
        }
        i = 0;
        while (i < digits.length) {
            char c = digits[i];
            if (c > '\u0080') {
                throw new IllegalStateException();
            }
            digitMap[c] = i++;
        }
        return digitMap;
    }
}

