/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.IsNull;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.internal.querypath.PathIterator;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractQueryModelField
implements IQueryPath,
IField {
    private String name;
    private IQueryPath parent;

    @Override
    public IQueryPath parent() {
        return this.parent;
    }

    public void parent(IQueryPath aModel) {
        this.parent = aModel;
    }

    @Override
    public String pathStep() {
        return this.name();
    }

    public String name() {
        return this.name;
    }

    public void name(String aName) {
        this.name = aName;
    }

    @Override
    public IPredicate _isNull() {
        IsNull isNull = QueryastFactory.eINSTANCE.createIsNull();
        isNull.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this));
        return isNull;
    }

    @Override
    public IQueryModel getRoot() {
        PathIterator it = this.iterator();
        IQueryPath each = null;
        while (it.hasNext()) {
            each = it.next();
        }
        return (IQueryModel)((Object)each);
    }

    public List getPath() {
        ArrayList<String> aList = new ArrayList<String>();
        PathIterator it = this.iterator();
        while (it.hasNext()) {
            IQueryPath each = it.next();
            if (each.pathStep() == null) continue;
            aList.add(each.pathStep());
        }
        Collections.reverse(aList);
        return aList;
    }

    @Override
    public String toPathString() {
        StringBuffer b = new StringBuffer();
        List path = this.getPath();
        Iterator it = path.iterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append('.');
        }
        return b.toString();
    }

    public boolean isSameAs(IQueryPath p) {
        IQueryModel r1 = this.getRoot();
        IQueryModel r2 = p.getRoot();
        if (!r1.getClass().equals(r2.getClass())) {
            return false;
        }
        String s1 = this.toPathString();
        String s2 = p.toPathString();
        return s1.equals(s2);
    }

    @Override
    public PathIterator iterator() {
        return new PathIterator(this);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isSingleValueRef() {
        return false;
    }

    @Override
    public boolean isManyValuedRef() {
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getSimpleName()).append('(').append(this.name()).append(')');
        return b.toString();
    }

    protected void checkInPredicateNullValue(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("_in predicate value array contains a null");
        }
    }

    protected void checkInPredicateValueArray(Object[] valueArray) {
        if (valueArray == null) {
            throw new IllegalArgumentException("_in predicate value array is null");
        }
        if (valueArray.length == 0) {
            throw new IllegalArgumentException("_in predicate value array is empty");
        }
    }

    protected void checkInPredicateValueArray(int[] valueArray) {
        if (valueArray == null) {
            throw new IllegalArgumentException("_in predicate value array is null");
        }
        if (valueArray.length == 0) {
            throw new IllegalArgumentException("_in predicate value array is empty");
        }
    }

    public abstract ElementType getFieldType();

    @Override
    public boolean isRedactable() {
        return false;
    }

    @Override
    public Literal redactionLiteral() {
        return null;
    }
}

