/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.StandaloneFileLocator;
import com.ibm.team.repository.common.internal.util.StandaloneUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.IRegistryProvider;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;

public class StandaloneExtensionRegistry
implements IRegistryProvider {
    private static final Log logger = LogFactory.getLog(StandaloneFileLocator.class);
    private Object masterRegistryKey = new Object();
    private Map<String, ResourceBundleClassLoader> pluginIdToBundlePropertiesLoader;
    private IExtensionRegistry registry;

    protected StandaloneExtensionRegistry() {
        Enumeration<URL> extensionFiles;
        RegistryStrategy strategy = new RegistryStrategy(null, null){

            public String translate(String key, ResourceBundle resources) {
                return ResourceTranslator.getResourceString(null, (String)key, (ResourceBundle)resources);
            }
        };
        this.registry = RegistryFactory.createRegistry((RegistryStrategy)strategy, (Object)this.masterRegistryKey, null);
        this.pluginIdToBundlePropertiesLoader = new HashMap<String, ResourceBundleClassLoader>(64);
        try {
            extensionFiles = StandaloneExtensionRegistry.class.getClassLoader().getResources("plugin.xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (extensionFiles.hasMoreElements()) {
            URL pluginXml = extensionFiles.nextElement();
            this.processPlugin(this.registry, pluginXml, i);
            ++i;
        }
    }

    private void processPlugin(IExtensionRegistry reg, URL pluginXml, int bundleId) {
        InputStream pluginXmlStream = null;
        ResourceBundle resourceBundle = null;
        try {
            try {
                String bundleLocalization;
                pluginXmlStream = pluginXml.openStream();
                String bundleName = StandaloneUtil.getBundleNameForPluginXml(pluginXml);
                String id = Integer.toString(bundleId);
                if (bundleName == null) {
                    bundleName = id;
                }
                if ((bundleLocalization = this.getBundleLocalization(pluginXml)) != null) {
                    try {
                        ResourceBundleClassLoader cl = new ResourceBundleClassLoader(StandaloneExtensionRegistry.class.getClassLoader(), bundleName, pluginXml, bundleLocalization);
                        resourceBundle = cl.getResourceBundle(Locale.getDefault());
                        this.pluginIdToBundlePropertiesLoader.put(bundleName, cl);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
                try {
                    reg.addContribution(pluginXmlStream, (IContributor)new RegistryContributor(id, bundleName, null, null), false, null, resourceBundle, this.masterRegistryKey);
                }
                catch (MissingResourceException ex) {
                    String message = "Exception parsing manifest for plugin \"{0}\" due to a missing key in properties file \"{1}\"";
                    message = MessageFormat.format(message, bundleName, bundleLocalization);
                    throw new IllegalStateException(message, ex);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                try {
                    if (pluginXmlStream != null) {
                        pluginXmlStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.error((Object)e1);
                }
            }
        }
        finally {
            try {
                if (pluginXmlStream != null) {
                    pluginXmlStream.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)e1);
            }
        }
    }

    private String getBundleLocalization(URL pluginXml) {
        Attributes main;
        InputStream in;
        block16: {
            block17: {
                URL manifestURL = this.computeRelativeResource(pluginXml, "META-INF/MANIFEST.MF");
                in = null;
                try {
                    in = manifestURL.openStream();
                }
                catch (IOException iOException) {
                    logger.warn((Object)("Could not open META-INF/MANIFEST.MF for bundle: " + pluginXml));
                    return null;
                }
                try {
                    Manifest mf;
                    try {
                        mf = new Manifest(in);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Error parsing manifest: " + manifestURL, e);
                    }
                    main = mf.getMainAttributes();
                    if (main != null) break block16;
                    if (in == null) break block17;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        String bundleLocalization = main.getValue("Bundle-Localization");
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (bundleLocalization == null) {
            bundleLocalization = "OSGI-INF/l10n/bundle";
        }
        return bundleLocalization;
    }

    private URL computeRelativeResource(URL url, String relativePath) {
        try {
            return new URL(url, relativePath);
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public ResourceBundle getResourceBundle(String pluginId, Locale locale) {
        ResourceBundleClassLoader cl = this.pluginIdToBundlePropertiesLoader.get(pluginId);
        if (cl != null) {
            return cl.getResourceBundle(locale);
        }
        return null;
    }

    private class ResourceBundleClassLoader
    extends ClassLoader {
        URL pluginXML;
        String qualifiedLocalization;
        String bundleName;

        public ResourceBundleClassLoader(ClassLoader parentLoader, String bundleName, URL pluginXml, String localization) {
            super(parentLoader);
            this.pluginXML = pluginXml;
            this.bundleName = bundleName.replace('.', '/');
            this.qualifiedLocalization = String.valueOf(bundleName) + localization;
        }

        @Override
        protected URL findResource(String resName) {
            if (!resName.startsWith(this.bundleName)) {
                throw new IllegalArgumentException("Expected the properties resource to start with the bundle name: " + resName);
            }
            String cleansedName = resName.substring(this.bundleName.length());
            return StandaloneExtensionRegistry.this.computeRelativeResource(this.pluginXML, cleansedName);
        }

        ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(this.qualifiedLocalization, locale, this);
        }
    }
}

