/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.utils.HashCode;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class HashComputingOutputStream
extends FilterOutputStream {
    private Checksum hashCode;
    long written = 0L;

    public HashComputingOutputStream(OutputStream out) {
        this(HashCode.newChecksum(), out);
    }

    public HashComputingOutputStream(Checksum start, OutputStream out) {
        super(out);
        if (start == null) {
            start = HashCode.newChecksum();
        }
        this.hashCode = start;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.hashCode.update(b);
        ++this.written;
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.out.write(b, offset, len);
        this.hashCode.update(b, offset, len);
        this.written += (long)len;
    }

    public Checksum getChecksum() {
        return this.hashCode;
    }

    public HashCode getHash() {
        return new HashCode(this.hashCode.getValue());
    }

    public long getWritten() {
        return this.written;
    }
}

