/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.WorkspaceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.DeliveryRequiresHistoryReorderingException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

public class JzRepoWorkspace
extends JzRepoResource {
    private static Map<JzLocation, List<JzRepoChangeSet>> RepoWorkspacesLocations2CurrentActivities = new HashMap<JzLocation, List<JzRepoChangeSet>>();
    private JzRepoBaseline justCreatedSnapshot = null;

    public static int FB_BASE(int begin, int end, int count, int size) {
        return begin + (end - begin) * count / size;
    }

    public JzRepoWorkspace(JzProvider provider, JzLocation loc) {
        super(provider, (Location)loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return WorkspaceImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            return this.computeBcfList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            return this.lookupCRH(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            return this;
        }
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            return false;
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return null;
        }
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.getChildMap(feedback);
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            return this.getChildList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY_LIST)) {
            return this.getCurrentActivityList(feedback);
        }
        if (propertyName.equals((Object)Workspace.STREAM)) {
            return this.getWorkspaceStream(feedback);
        }
        if (propertyName.equals((Object)Workspace.TARGET)) {
            return this.getTarget(feedback);
        }
        if (propertyName.equals((Object)Workspace.SOURCE_LIST)) {
            return this.getSourceList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONFIGURATION)) {
            return JzRepoWorkspace.createWorkspaceConfiguration(this.provider(), (IWorkspaceHandle)this.getResolvedWorkspace(feedback));
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private void setSourceList(List<JzRepoResource> newSources, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback);
        IFlowTable flowTable = wsConn.getFlowTable().getWorkingCopy();
        IFlowEntry currentFlowEntry = flowTable.getCurrentAcceptFlow();
        IFlowNodeHandle currentHandle = currentFlowEntry == null ? null : currentFlowEntry.getFlowNode();
        ArrayList currentSources = new ArrayList(flowTable.acceptSources());
        for (IFlowEntry flowEntry : currentSources) {
            IFlowNodeHandle flowHandle = flowEntry.getFlowNode();
            if (currentHandle == null || ItemUtil.equivItemRef((IItemHandle)flowHandle, (IItemHandle)currentHandle)) continue;
            flowTable.removeAcceptFlow(flowHandle);
        }
        List<IWorkspaceHandle> sourceHandles = this.resolveSources(newSources, feedback);
        this.addFlowSources(wsConn, flowTable, sourceHandles, feedback);
    }

    private List<JzRepoResource> getSourceList(SrvcFeedback feedback) throws WvcmException {
        List<IWorkspaceHandle> sources = this.getSources(feedback);
        ArrayList<JzRepoResource> result = new ArrayList<JzRepoResource>(sources.size());
        for (IWorkspaceHandle source : sources) {
            result.add(this.createJRR(source, feedback));
        }
        return result;
    }

    private List<IWorkspaceHandle> getSources(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection conn = this.getConnection(feedback);
        return JzRepoWorkspace.getSources((IFlowNodeConnection)conn, this.getTargetHandle(feedback), feedback);
    }

    public static List<IWorkspaceHandle> getSources(IFlowNodeConnection conn, IWorkspaceHandle deliverFlowHandle, SrvcFeedback feedback) throws WvcmException {
        IFlowTable flowTable = conn.getFlowTable();
        ArrayList flowEntries = new ArrayList(flowTable.acceptSources());
        flowEntries.addAll(flowTable.deliverTargets());
        ArrayList<IWorkspaceHandle> flowHandles = new ArrayList<IWorkspaceHandle>(flowEntries.size());
        for (IFlowEntry flowEntry : flowEntries) {
            flowHandles.add((IWorkspaceHandle)flowEntry.getFlowNode());
        }
        ArrayList<IWorkspaceHandle> sources = deliverFlowHandle == null ? flowHandles : (List)ItemUtil.removeAll(flowHandles, Collections.singletonList(deliverFlowHandle));
        return sources;
    }

    private JzRepoResource getTarget(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceHandle targetHandle = this.getTargetHandle(feedback.nest(50));
        JzRepoResource result = targetHandle == null ? null : this.createJRR(targetHandle, feedback);
        return result;
    }

    private IWorkspaceHandle getTargetHandle(SrvcFeedback feedback) throws WvcmException {
        IFlowEntry currentDeliverFlow = this.getConnection(feedback).getFlowTable().getCurrentDeliverFlow();
        IWorkspaceHandle targetHandle = currentDeliverFlow == null ? null : (IWorkspaceHandle)currentDeliverFlow.getFlowNode();
        return targetHandle;
    }

    private JzRepoResource createJRR(IWorkspaceHandle targetHandle, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        try {
            IWorkspaceManager workspaceManager = this.getWorkspaceManager();
            JzRepoResource result = workspaceManager.getWorkspaceConnection(targetHandle, JzProvider.getMonitor(feedback, 100)).isStream() ? JzRepoStream.create(provider, (IItemHandle)targetHandle) : JzRepoWorkspace.create(provider, targetHandle);
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private List<JzRepoChangeSet> getCurrentActivityList(SrvcFeedback feedback) throws WvcmException {
        ArrayList<JzRepoChangeSet> result = new ArrayList<JzRepoChangeSet>();
        JzProvider provider = this.provider();
        IWorkspaceConnection wsConn = this.getConnection(feedback);
        List<IComponentHandle> knownComponents = JzRepoWorkspace.getComponentHandles(provider, (IFlowNodeConnection)this.getConnection(feedback));
        for (IComponentHandle componentHandle : knownComponents) {
            List sets = wsConn.activeChangeSets(componentHandle);
            for (IChangeSetHandle changeSetHandle : sets) {
                String displayName = JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)changeSetHandle);
                JzLocation csLoc = JzLocation.createChangeSetLocation(displayName);
                result.add((JzRepoChangeSet)provider.get((Location)csLoc, feedback));
            }
        }
        List<JzRepoChangeSet> currentActivities = RepoWorkspacesLocations2CurrentActivities.get((Object)this.location());
        if (currentActivities != null) {
            result.addAll(currentActivities);
        }
        return result;
    }

    private JzRepoStream getWorkspaceStream(SrvcFeedback feedback) throws WvcmException {
        JzRepoStream result = null;
        JzLocation wsLoc = JzLocation.createWorkspaceStreamLoc(this.location());
        result = (JzRepoStream)this.provider().get((Location)wsLoc, feedback);
        return result;
    }

    public IWorkspaceConnection getRefreshedConnection(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection result = this.getConnection(feedback.nest(50));
        JzRepoWorkspace.refresh(this.provider(), result, feedback);
        return result;
    }

    public IWorkspaceConnection getConnection(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)this.getItemHandle(feedback);
        IWorkspaceConnection wsConn = JzRepoWorkspace.lookupConnection(this.provider(), workspaceHandle, true, feedback);
        if (wsConn == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERROR_GET_CONN_FAILED_WITH_UUID, (Object)workspaceHandle.getItemId(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return wsConn;
    }

    public static JzRepoWorkspace doCreateGeneratedWorkspace(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue commentValue = updates != null ? updates.get(Resource.COMMENT) : null;
        String comment = JzProvider.EMPTY_STRING;
        if (commentValue != null) {
            comment = (String)commentValue.get_value();
            updated.add(Resource.COMMENT);
        }
        Location targetLoc = null;
        if (updates != null) {
            PropValue targetValue = updates.get(Workspace.TARGET);
            if (targetValue != null) {
                targetLoc = (Location)targetValue.get_value();
                updated.add(Workspace.TARGET);
            } else {
                targetValue = updates.get(Workspace.ISOLATED_TARGET);
                if (targetValue != null) {
                    targetLoc = (Location)targetValue.get_value();
                    updated.add(Workspace.ISOLATED_TARGET);
                }
            }
        }
        JzRepoStream targetStream = targetLoc == null ? null : JzRepoStream.lookup(provider, JzLocation.create(targetLoc), feedback);
        IWorkspaceHandle targetHandle = targetStream == null ? null : (IWorkspaceHandle)targetStream.getItemHandle(feedback);
        PropValue ownerUserIdValue = updates != null ? updates.get(InteropCore.PN_RESERVE_FOR_INTEROP) : null;
        IContributor owner = null;
        if (ownerUserIdValue != null) {
            owner = JzRepoWorkspace.getSyncUser(provider, feedback);
            updated.add(InteropCore.PN_RESERVE_FOR_INTEROP);
        }
        JzRepoWorkspace result = JzRepoWorkspace.doCreateGeneratedWorkspace(provider, locationHint, updates, updated, comment, targetHandle, owner, feedback);
        return result;
    }

    private void setWorkspaceOwner(IContributorHandle owner, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback);
        try {
            wsConn.setOwner((IAuditableHandle)owner, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private static IContributor getSyncUser(JzProvider provider, SrvcFeedback feedback) throws WvcmException {
        String ownerUserIdString = provider.getSyncUserId();
        IContributor result = provider.getContributor(ownerUserIdString, feedback);
        return result;
    }

    public IWorkspace getResolvedWorkspace(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback);
        return wsConn.getResolvedWorkspace();
    }

    public static JzRepoWorkspace doCreateGeneratedWorkspace(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, String comment, IWorkspaceHandle sourceHandle, IContributor requestedOwner, SrvcFeedback feedback) throws WvcmException {
        String randomizer = JzProvider.timeFormatter.format(new Date());
        String basename = locationHint.lastSegment();
        boolean workspaceWithBasenameExists = JzRepoWorkspace.findAllStreamsOrWorkspacesByName(provider, basename, false, JzProvider.getMonitor(feedback, 50)).size() > 0;
        String workspaceName = workspaceWithBasenameExists ? String.valueOf(basename) + JzProvider.UNDERSCORE + randomizer : basename;
        ITeamRepository repo = provider.getRepo();
        IContributor owner = repo.loggedInContributor();
        try {
            PropValue additionalSourceStreamsValue;
            IWorkspaceConnection sourceConection = sourceHandle == null ? null : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(sourceHandle, JzProvider.getMonitor(feedback, 10));
            IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)owner, workspaceName, comment, sourceConection, sourceConection, JzProvider.getMonitor(feedback, 90));
            if (requestedOwner != null) {
                owner = requestedOwner;
            }
            wsConn.setOwnerAndVisibility((IAuditableHandle)owner, (IReadScope)IReadScope.FACTORY.createPublicScope(), JzProvider.getMonitor(feedback, 100));
            IWorkspace resolvedWorkspace = wsConn.getResolvedWorkspace();
            JzRepoWorkspace result = JzRepoWorkspace.create(provider, (IWorkspaceHandle)resolvedWorkspace);
            provider.logCreation("Workspace", JzLocation.createWorkspaceLoc(JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)resolvedWorkspace)), workspaceName, "owned by: " + owner.getUserId());
            PropValue propValue = additionalSourceStreamsValue = updates != null ? updates.get(Workspace.SOURCE_LIST) : null;
            if (additionalSourceStreamsValue != null) {
                List additionalSourceStreamLocs = (List)additionalSourceStreamsValue.get_value();
                ArrayList<JzRepoResource> streams = new ArrayList<JzRepoResource>(additionalSourceStreamLocs.size());
                for (JzLocation streamLoc : additionalSourceStreamLocs) {
                    streams.add(JzRepoStream.lookup(provider, streamLoc, feedback));
                }
                List<IWorkspaceHandle> sourceHandles = result.resolveSources(streams, feedback);
                result.addFlowSources(sourceHandles, feedback);
                updated.add(Workspace.SOURCE_LIST);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private List<IWorkspaceHandle> resolveSources(List<JzRepoResource> sources, SrvcFeedback feedback) throws WvcmException {
        ArrayList<IWorkspaceHandle> results = new ArrayList<IWorkspaceHandle>(sources.size());
        for (JzRepoResource sourceStream : sources) {
            results.add((IWorkspaceHandle)sourceStream.getItemHandle(feedback));
        }
        return results;
    }

    public static JzRepoConfiguration createWorkspaceConfiguration(JzProvider provider, IWorkspaceHandle workspaceHandle) {
        String displayName = JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)workspaceHandle);
        JzLocation myLoc = JzLocation.createWorkspaceConfigurationLoc(displayName);
        JzRepoConfiguration result = new JzRepoConfiguration(provider, (Location)myLoc);
        return result;
    }

    public static JzRepoWorkspace create(JzProvider provider, IWorkspaceHandle workspaceHandle) {
        String displayName = JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)workspaceHandle);
        JzLocation myLoc = JzLocation.createWorkspaceLoc(displayName);
        JzRepoWorkspace result = new JzRepoWorkspace(provider, myLoc);
        return result;
    }

    private void addFlowSources(List<IWorkspaceHandle> sources, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback);
        IFlowTable flowTable = wsConn.getFlowTable().getWorkingCopy();
        this.addFlowSources(wsConn, flowTable, sources, feedback);
    }

    private void addFlowSources(IWorkspaceConnection wsConn, IFlowTable flowTable, List<IWorkspaceHandle> sources, SrvcFeedback feedback) throws WvcmException {
        for (IWorkspaceHandle source : sources) {
            flowTable.addAcceptFlow((IFlowNodeHandle)source, null, "", (Collection)Collections.EMPTY_LIST, "");
        }
        try {
            wsConn.setFlowTable(flowTable, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public Map<String, SrvcResource> getChildMap(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        JzLocation myLoc = this.location();
        try {
            List knownComponents = this.getConnection(feedback).getComponents();
            HashMap<String, SrvcResource> results = new HashMap<String, SrvcResource>(knownComponents.size());
            for (IComponentHandle componentHandle : knownComponents) {
                JzRepoComponent jzRepoComponent = JzRepoComponent.create(componentHandle, provider);
                IComponent comp = jzRepoComponent.getComponentItem(feedback);
                String compName = comp.getName();
                JzLocation bcfLoc = JzLocation.createBCFLoc(myLoc, jzRepoComponent.location());
                JzRepoBaselineControlledFolder bcf = new JzRepoBaselineControlledFolder(provider, (Location)bcfLoc);
                results.put(compName, bcf);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public List<SrvcResource> getChildList(SrvcFeedback feedback) throws WvcmException {
        Map<String, SrvcResource> childMap = this.getChildMap(feedback);
        ArrayList<SrvcResource> list = new ArrayList<SrvcResource>(childMap.size());
        list.addAll(childMap.values());
        return list;
    }

    protected static IWorkspaceConnection lookupConnection(JzProvider provider, IWorkspaceHandle connectableHandle, boolean throwIfNotFound, SrvcFeedback feedback) throws WvcmException {
        try {
            IWorkspaceConnection conn = SCMPlatform.getWorkspaceManager((ITeamRepository)provider.getRepo()).getWorkspaceConnection(connectableHandle, JzProvider.getMonitor(feedback, 100));
            return conn;
        }
        catch (ItemNotFoundException e) {
            if (throwIfNotFound) {
                throw JzProvider.wrapException(e);
            }
            return null;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public static JzRepoWorkspace lookupByPathname(JzProvider provider, String name) {
        JzRepoWorkspace result = null;
        UUID uuid = UUID.valueOf((String)name);
        IWorkspaceHandle myItemHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(uuid, null);
        if (myItemHandle != null) {
            result = JzRepoWorkspace.create(provider, myItemHandle);
            result.setItemHandle((IItemHandle)myItemHandle);
        }
        return result;
    }

    public static JzRepoWorkspace lookup(JzProvider provider, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn;
        JzRepoWorkspace result = null;
        IItemHandle myItemHandle = JzRepoWorkspace.lookupItemHandle(provider, loc);
        if (myItemHandle != null && (wsConn = JzRepoWorkspace.lookupConnection(provider, (IWorkspaceHandle)myItemHandle, false, feedback)) != null) {
            result = new JzRepoWorkspace(provider, loc);
            result.setItemHandle(myItemHandle);
        }
        return result;
    }

    private JzRepoComponent lookupComponentByNameInLocation(JzLocation compLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = null;
        String compName = JzRepoComponent.lookupComponentNameStringLoc(compLoc);
        if (compName == null) {
            return null;
        }
        try {
            JzProvider provider = this.provider();
            IItemManager itemManager = provider.getRepo().itemManager();
            for (IComponentHandle cH : JzRepoWorkspace.getComponentHandles(provider, (IFlowNodeConnection)this.getConnection(feedback))) {
                IComponent c = (IComponent)itemManager.fetchCompleteItem((IItemHandle)cH, 0, JzProvider.getMonitor(feedback, 100));
                if (!c.getName().equals(compName)) continue;
                if (result != null) {
                    throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERROR_AMBIG_COMP_NAME_WITH_NAME, (Object)compName, (Object[])new Object[0]), WvcmException.ReasonCode.FORBIDDEN);
                }
                result = JzRepoComponent.create(cH, provider);
            }
        }
        catch (ItemNotFoundException e) {
            this.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupComponentByName", (Exception)((Object)e), null);
            result = null;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            this.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupComponentByName", (Exception)((Object)e), null);
            result = null;
        }
        return result;
    }

    private JzRepoBaselineControlledFolder lookupCRH(SrvcFeedback feedback) throws WvcmException {
        List<IComponentHandle> knownComponents = JzRepoWorkspace.getComponentHandles(this.provider(), (IFlowNodeConnection)this.getConnection(feedback));
        JzRepoBaselineControlledFolder result = knownComponents.size() < 1 ? null : this.computeBcf(knownComponents.get(0));
        return result;
    }

    private static List<IComponentHandle> getComponentHandles(JzProvider provider, IFlowNodeConnection conn) throws WvcmException {
        try {
            List knownComponents = conn.getComponents();
            return knownComponents;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public JzRepoBaselineControlledFolder computeBcf(IComponentHandle compH) throws WvcmException {
        JzLocation bcfLoc = this.computeBcfLoc(compH);
        JzRepoBaselineControlledFolder result = new JzRepoBaselineControlledFolder(this.provider(), (Location)bcfLoc);
        return result;
    }

    public JzRepoConfiguration computeConfig(JzRepoComponent comp, SrvcFeedback feedback) throws WvcmException {
        return this.computeConfig(comp.location(), feedback);
    }

    private JzRepoConfiguration computeConfig(JzLocation compLoc, SrvcFeedback feedback) throws WvcmException {
        JzLocation configLoc = JzLocation.createConfigurationLoc(this.location(), compLoc);
        return JzRepoConfiguration.lookup(this.provider(), configLoc, feedback);
    }

    public JzRepoConfiguration computeConfig(IComponentHandle compHandle, SrvcFeedback feedback) throws WvcmException {
        return this.computeConfig(JzRepoComponent.createComponentLocation(compHandle), feedback);
    }

    public JzLocation computeBcfLoc(JzRepoComponent comp) {
        JzLocation bcfLoc = JzLocation.createBCFLoc(this.location(), comp.location());
        return bcfLoc;
    }

    public JzLocation computeBcfLoc(IComponentHandle compH) throws WvcmException {
        JzLocation compLoc = JzRepoComponent.createComponentLocation(compH);
        JzLocation bcfLoc = JzLocation.createBCFLoc(this.location(), compLoc);
        return bcfLoc;
    }

    public List<JzRepoBaselineControlledFolder> computeBcfList(SrvcFeedback feedback) throws WvcmException {
        try {
            IWorkspaceConnection wsConn = this.getConnection(feedback);
            List knownComponents = wsConn.getComponents();
            ArrayList<JzRepoBaselineControlledFolder> result = new ArrayList<JzRepoBaselineControlledFolder>(knownComponents.size());
            for (IComponentHandle c : knownComponents) {
                JzRepoBaselineControlledFolder bcf = this.computeBcf(c);
                result.add(bcf);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public <T extends SrvcResource> void doCheckin(List<T> resources, String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.provider().applyDeferredContentCommits(feedback);
    }

    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.provider().applyDeferredContentCommits(feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.SOURCE_LIST)) {
            this.setSourceList((List)value, feedback);
        } else if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY_LIST)) {
            List changeSetList = (List)value;
            if (changeSetList == null || changeSetList.size() > 0) {
                throw new IllegalArgumentException("Setting a workspace's activity to a value other than the empty list is NYI");
            }
            this.closeAllCurrentActivities(feedback);
            RepoWorkspacesLocations2CurrentActivities.remove((Object)this.location());
        } else if (propertyName.equals((Object)InteropCore.PN_RESERVE_FOR_INTEROP)) {
            IContributor owner = JzRepoWorkspace.getSyncUser(this.provider(), feedback);
            this.setWorkspaceOwner((IContributorHandle)owner, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public void closeAllCurrentActivities(SrvcFeedback feedback) throws WvcmException {
        List<IComponentHandle> componentHandles = JzRepoWorkspace.getComponentHandles(this.provider(), (IFlowNodeConnection)this.getConnection(feedback));
        for (IComponentHandle compHandle : componentHandles) {
            JzRepoConfiguration config = this.computeConfig(compHandle, feedback);
            config.closeCurrentActivity(feedback);
        }
    }

    public IBaselineHandle createBaselineIfNeeded(IComponent comp, String name, IBaselineHandle baselineHandle, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn;
        block3: {
            JzRepoConfiguration config = this.computeConfig((IComponentHandle)comp, feedback);
            config.closeCurrentActivity(feedback);
            try {
                IChangeHistorySyncReport changes;
                wsConn = this.getConnection(feedback);
                if (baselineHandle == null || (changes = wsConn.compareToBaseline(baselineHandle, JzProvider.getMonitor(feedback, 50))).outgoingChangeSets((IComponentHandle)comp).size() != 0) break block3;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        return wsConn.createBaseline((IComponentHandle)comp, name, null, JzProvider.getMonitor(feedback, 100)).getBaseline();
    }

    @Override
    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        String result = this.getConnection(feedback).getName();
        return result;
    }

    public JzLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        String uuidString = this.getConnection(feedback).getResolvedWorkspace().getItemId().getUuidValue();
        JzLocation result = JzLocation.root().child("workspace").child(uuidString);
        return result;
    }

    public void doVersionControl(List<Location> locations, SrvcFeedback feedback) throws WvcmException {
        this.provider().applyDeferredContentCommits(feedback);
    }

    public <T extends SrvcResource> void doMerge(List<T> sourceList, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource resource : sourceList) {
            if (resource instanceof JzRepoStream) {
                this.doMerge((JzRepoStream)resource, flags, feedback);
                continue;
            }
            throw new IllegalArgumentException(NLS.bind((String)"Unsupported source for Workspace.doMerge operation: ''{0}''", (Object)resource.getClass().getName(), (Object[])new Object[0]));
        }
    }

    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource resource : sourceList) {
            if (resource instanceof JzRepoStream) {
                this.doUpdate((JzRepoStream)resource, feedback);
                continue;
            }
            if (resource instanceof JzRepoBaseline) {
                JzRepoBaseline source = (JzRepoBaseline)resource;
                JzRepoWorkspace.doUpdate(this.provider(), this.location(), (IFlowNodeConnection)this.getConnection(feedback.nest(10)), source.getConnection(feedback.nest(20)), feedback);
                continue;
            }
            throw new IllegalArgumentException(NLS.bind((String)"Unsupported source for Workspace.doUpdate operation: ''{0}''", (Object)resource.getClass().getName(), (Object[])new Object[0]));
        }
    }

    private void doUpdate(JzRepoStream sourceStream, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        JzLocation myLoc = this.location();
        IWorkspaceConnection wsConn = this.getRefreshedConnection(feedback.nest(5));
        IWorkspaceConnection sourceConnection = sourceStream.getRefreshedConnection(feedback.nest(20));
        List sourceActivities = sourceConnection.activeChangeSets();
        int sourceCount = sourceActivities.size();
        if (sourceCount > 0 && feedback != null) {
            String name = wsConn.getName();
            feedback.notifyWarning(NLS.bind((String)Messages.JzRepoWorkspace_WARNING_CLOSING_ACTIVE_CS, (Object)sourceCount, (Object[])new Object[]{name}));
            sourceStream.getStreamWorkspace(feedback.nest(30)).closeAllCurrentActivities(feedback.nest(40));
        }
        this.logDebug("updating ws: " + myLoc.string() + " from stream: " + sourceStream.location().string());
        List targetActivities = wsConn.activeChangeSets();
        int targetCount = targetActivities.size();
        if (targetCount > 0) {
            String name = wsConn.getName();
            throw new IllegalStateException(String.format("Workspace: %s has %d active changes sets.  It should have 0.", name, targetCount));
        }
        JzRepoWorkspace.doUpdate(provider, myLoc, wsConn, sourceConnection, true, feedback);
    }

    public static void doUpdate(JzProvider provider, JzLocation targetLocationForException, IFlowNodeConnection targetConnection, IBaselineConnection sourceConnection, SrvcFeedback feedback) throws WvcmException {
        provider.logDebug("updating : " + targetConnection.getName() + " (" + targetLocationForException.string() + ") from : " + sourceConnection.getName());
        try {
            List targetComponents = targetConnection.getComponents();
            IComponentHandle sourceComponent = sourceConnection.getComponent();
            IFlowNodeConnection.IComponentOpFactory fty = targetConnection.componentOpFactory();
            IFlowNodeConnection.IComponentReplacementOp op = null;
            if (ItemUtil.itemInCollection((IItemHandle)sourceComponent, (Collection)targetComponents)) {
                op = fty.replaceComponent(sourceComponent, (IConnection)sourceConnection, false);
            } else {
                op = fty.addComponent(sourceComponent, (IConnection)sourceConnection, false);
                provider.logDebug("added component: " + sourceComponent.getItemId().toString() + " to: " + targetConnection.getName());
            }
            targetConnection.applyComponentOperationsWithoutBackupBaselines(Collections.singletonList(op), JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public static void doUpdate(JzProvider provider, JzLocation targetLocationForException, IWorkspaceConnection targetConnection, IWorkspaceConnection sourceConnection, boolean replaceComponents, SrvcFeedback feedback) throws WvcmException {
        if (ItemUtil.equivItemRef((IItemHandle)sourceConnection.getResolvedWorkspace(), (IItemHandle)targetConnection.getResolvedWorkspace())) {
            provider.logDebug("not updating : " + targetConnection.getName() + " (" + targetLocationForException.string() + ") since its source is the same: " + sourceConnection.getName());
            return;
        }
        provider.logDebug("updating : " + targetConnection.getName() + " (" + targetLocationForException.string() + ") from : " + sourceConnection.getName());
        try {
            List targetComponents = targetConnection.getComponents();
            List sourceComponents = sourceConnection.getComponents();
            IChangeHistorySyncReport changes = null;
            if (replaceComponents) {
                changes = sourceConnection.compareTo((IFlowNodeConnection)targetConnection, 0, Collections.EMPTY_LIST, JzProvider.getMonitor(feedback, 30));
            }
            IFlowNodeConnection.IComponentOpFactory fty = targetConnection.componentOpFactory();
            ArrayList<Object> opList = new ArrayList<Object>(sourceComponents.size());
            int monitorIndex = 0;
            for (IComponentHandle componentHandle : sourceComponents) {
                if (ItemUtil.itemInCollection((IItemHandle)componentHandle, (Collection)targetComponents)) {
                    if (!replaceComponents) continue;
                    boolean forceReplaceComponent = false;
                    if (changes.incomingChangeSets(componentHandle).isEmpty()) {
                        if (!changes.outgoingChangeSets(componentHandle).isEmpty()) {
                            try {
                                sourceConnection.deliver(targetConnection, changes, Collections.EMPTY_LIST, changes.outgoingChangeSets(componentHandle), JzProvider.getMonitor(feedback, 30 + ++monitorIndex * 20 / sourceComponents.size()));
                            }
                            catch (TeamRepositoryException teamRepositoryException) {
                                forceReplaceComponent = true;
                            }
                        }
                    } else {
                        forceReplaceComponent = true;
                    }
                    if (!forceReplaceComponent) continue;
                    opList.add(fty.replaceComponent(componentHandle, (IConnection)sourceConnection, false));
                    continue;
                }
                opList.add(fty.addComponent(componentHandle, (IConnection)sourceConnection, false));
                provider.logDebug("added component: " + componentHandle.getItemId().toString() + " to: " + targetConnection.getName());
            }
            if (opList.size() > 0) {
                targetConnection.applyComponentOperationsWithoutBackupBaselines(opList, JzProvider.getMonitor(feedback, 100));
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private void doMerge(JzRepoStream sourceStream, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        block11: {
            JzProvider p = this.provider();
            JzLocation targetLocation = this.location();
            JzLocation sourceStreamLoc = sourceStream.location();
            IWorkspaceConnection wsConn = this.getConnection(feedback.nest(10));
            IWorkspaceConnection sourceStreamConnection = sourceStream.getConnection(feedback.nest(20));
            if (ItemUtil.equivItemRef((IItemHandle)sourceStreamConnection.getResolvedWorkspace(), (IItemHandle)wsConn.getResolvedWorkspace())) {
                p.logDebug("not merging into : " + wsConn.getName() + " (" + targetLocation.string() + ") since its source is the same: " + sourceStreamConnection.getName());
                return;
            }
            this.logDebug("merging to ws: " + targetLocation.string() + " from stream: " + sourceStreamLoc.string());
            IItemManager itemManager = this.provider().getRepo().itemManager();
            try {
                IChangeHistorySyncReport changes = wsConn.compareTo((IFlowNodeConnection)sourceStreamConnection, 0, Collections.EMPTY_LIST, JzProvider.getMonitor(feedback, 30));
                List incomingChangeSets = changes.incomingChangeSets();
                if (!incomingChangeSets.isEmpty()) {
                    IUpdateReport acceptReport;
                    int actualConflictCount;
                    IUpdateReport preflightReport = wsConn.accept(1, sourceStreamConnection, changes, Collections.EMPTY_LIST, incomingChangeSets, JzProvider.getMonitor(feedback, 40));
                    int preflightConflictCount = preflightReport.conflicts().size();
                    if (preflightConflictCount > 0) {
                        List<Object> flagList = flags != null ? Arrays.asList(flags) : Collections.emptyList();
                        if (!p.allowModModMerge() || flagList.contains(Workspace.MergeFlag.NO_AUTO_MERGE) || flagList.contains(Workspace.MergeFlag.NO_CHECKOUT)) {
                            throw new WvcmException("unexpected conflicting changes found during \"preflight\". conflict count: " + Integer.toString(preflightConflictCount), WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
                        }
                    }
                    if ((actualConflictCount = (acceptReport = wsConn.accept(0, sourceStreamConnection, changes, Collections.EMPTY_LIST, incomingChangeSets, JzProvider.getMonitor(feedback, 50))).conflicts().size()) > 0 && !p.allowModModMerge()) {
                        wsConn.discardChangeSets(false, (Collection)incomingChangeSets, JzProvider.getMonitor(feedback, 60));
                        throw new WvcmException("unexpected conflicting changes count: " + Integer.toString(actualConflictCount), WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
                    }
                    for (IItemConflictReport c : acceptReport.conflicts()) {
                        IVersionableHandle ver = c.item();
                        this.closeAllCurrentActivities(feedback.nest(63));
                        IChangeSetHandle cH = (IChangeSetHandle)incomingChangeSets.get(0);
                        IChangeSet changeSet = (IChangeSet)itemManager.fetchCompleteItem((IItemHandle)cH, 0, JzProvider.getMonitor(feedback, 70));
                        wsConn.commit(wsConn.createChangeSet(changeSet.getComponent(), JzProvider.getMonitor(feedback, 75)), Arrays.asList(wsConn.configurationOpFactory().markAsMerged(ver, c.getSelectedContributorState(), c.getProposedContributorState())), JzProvider.getMonitor(feedback, 80));
                    }
                }
                JzRepoWorkspace.doUpdate(p, targetLocation, wsConn, sourceStreamConnection, false, feedback.nest(85));
                if (flags == null || !Arrays.asList(flags).contains(Workspace.MergeFlag.UPDATE_STREAM)) break block11;
                JzRepoWorkspace.doUpdate(p, sourceStreamLoc, sourceStreamConnection, wsConn, false, feedback.nest(90));
                try {
                    List outgoingChangeSets = changes.outgoingChangeSets();
                    if (!outgoingChangeSets.isEmpty()) {
                        wsConn.deliver(sourceStreamConnection, changes, Collections.EMPTY_LIST, outgoingChangeSets, JzProvider.getMonitor(feedback, 100));
                    }
                }
                catch (DeliveryRequiresHistoryReorderingException ex) {
                    wsConn.harmonizeHistory(sourceStreamConnection, ex.getComponent(), JzProvider.getMonitor(feedback, 100));
                }
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
    }

    public JzLocation doCreateComponent(JzLocation compLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        String compName = JzRepoComponent.lookupComponentNameStringLoc(compLoc);
        if (compName == null) {
            throw new IllegalArgumentException(NLS.bind((String)"could not find component name in location", (Object)compLoc.string(), (Object[])new Object[0]));
        }
        JzProvider provider = this.provider();
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        IContributor owner = provider.getRepo().loggedInContributor();
        try {
            IComponent component = workspaceManager.createComponent(compName, (IAuditableHandle)owner, JzProvider.getMonitor(feedback, 30));
            workspaceManager.setComponentOwnerAndVisibility((IComponentHandle)component, IScmService.NOOP_OWNER, (IReadScope)IReadScope.FACTORY.createPublicScope(), JzProvider.getMonitor(feedback, 50));
            IWorkspaceConnection conn = this.getConnection(feedback.nest(60));
            IFlowNodeConnection.IComponentAdditionOp op = conn.componentOpFactory().addComponent((IComponentHandle)component, false);
            conn.applyComponentOperations(Collections.singletonList(op), JzProvider.getMonitor(feedback, 80));
            JzRepoComponent comp = JzRepoComponent.create((IComponentHandle)component, provider);
            comp.doCreateResourceHelper(updates, updated, feedback.nest(90));
            JzLocation actualCompLoc = comp.location();
            provider.logCreation("Component", compLoc, actualCompLoc.string(), "rootFolder ItemId: " + component.getRootFolder().getItemId().toString());
            return actualCompLoc;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public JzRepoComponent lookupJzRepoComponent(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        JzLocation compLoc;
        JzProvider p = this.provider();
        JzRepoComponent result = (JzRepoComponent)p.lookup((Location)(compLoc = componentLocation.lookupContextLocation(JzLocation.Kind.Component)), feedback);
        if (result == null) {
            result = this.lookupComponentByNameInLocation(compLoc, feedback);
        }
        return result;
    }

    public JzRepoComponent getJzRepoComponent(JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = this.lookupJzRepoComponent(loc, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERROR_COMP_NOT_FOUND_WITH_LOCSTRING, (Object)loc.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IComponent lookupComponent(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        IComponent result = null;
        JzRepoComponent comp = this.lookupJzRepoComponent(componentLocation, feedback);
        if (comp != null) {
            result = comp.lookupComponentItem(feedback);
        }
        return result;
    }

    public IComponent getComponent(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        IComponent result = this.lookupComponent(componentLocation, feedback);
        if (result == null) {
            throw new WvcmException("getComponent failed", null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IComponentHandle lookupComponentHandle(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.lookupJzRepoComponent(componentLocation, feedback);
        IComponentHandle result = comp == null ? null : comp.getComponentItemHandle(feedback);
        return result;
    }

    public static JzRepoVersion locateByHistory(JzProvider provider, IWorkspaceConnection connection, JzRepoVersionHistory vh, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersion result = null;
        IComponentHandle compH = JzRepoComponent.getComponentItemHandle(provider, vh.location().getComponentLocation(), feedback);
        try {
            IConfiguration configuration = connection.configuration(compH);
            if (configuration != null) {
                result = vh.lookupVersion(configuration, feedback);
            }
        }
        catch (ItemNotFoundException e) {
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.locateByHistory", (Exception)((Object)e));
            result = null;
        }
        catch (ComponentNotInWorkspaceException e) {
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.locateByHistory", (Exception)((Object)e));
            result = null;
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.locateByHistory", (Exception)((Object)e), null);
            result = null;
        }
        return result;
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkspace.locateByHistory(this.provider(), this.getConnection(feedback), (JzRepoVersionHistory)genericVersionHistory, feedback);
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource genericFolderVersion, SrvcFeedback feedback) throws WvcmException {
        JzRepoFolderItem folderVersion = (JzRepoFolderItem)genericFolderVersion;
        IComponentHandle compH = JzRepoComponent.getComponentItemHandle(this.provider(), folderVersion.location().getComponentLocation(), feedback);
        try {
            IConfiguration configuration = this.getConnection(feedback).configuration(compH);
            Map<String, JzRepoResource> childMap = folderVersion.childMap(true, configuration, feedback);
            HashMap<String, SrvcResource> results = new HashMap<String, SrvcResource>(childMap);
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        return new ArrayList<SrvcResource>(this.getFolderVersionChildMap(folderVersion, feedback).values());
    }

    public void doUnbindAll(SrvcFeedback fb) throws WvcmException {
        JzRepoWorkspace.delete(this.provider().getRepo(), (IWorkspaceHandle)this.getItemHandle(fb.nest(50)), fb);
    }

    public static void delete(ITeamRepository repo, IWorkspaceHandle handle, SrvcFeedback fb) throws WvcmException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            workspaceManager.deleteWorkspace(handle, JzProvider.getMonitor(fb, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public IVersionableHandle lookupVersionableHandle(JzLocation componentLocation, URI versionHistoryUri, SrvcFeedback feedback) throws WvcmException {
        IVersionable result = null;
        IComponent comp = this.lookupComponent(componentLocation, feedback.nest(10));
        if (comp != null) {
            JzProvider provider = this.provider();
            IVersionableHandle versionableHandle = (IVersionableHandle)JzRepoWorkspace.lookupItemHandle(provider, versionHistoryUri);
            try {
                IWorkspaceConnection wsConn = this.getConnection(feedback.nest(20));
                result = wsConn.configuration((IComponentHandle)comp).fetchPartialItem(versionableHandle, null, JzProvider.getMonitor(feedback, 100));
            }
            catch (ItemNotFoundException e) {
                this.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupVersionableHandle", (Exception)((Object)e), null);
                result = null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
            catch (WvcmException e) {
                if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                    throw e;
                }
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupVersionableHandle", (Exception)((Object)e), null);
                result = null;
            }
        }
        return result;
    }

    public JzLocation getUriComponentLocation(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.lookupJzRepoComponent(componentLocation, feedback);
        if (comp != null) {
            return comp.location();
        }
        throw new WvcmException(NLS.bind((String)"component not found: {0}", (Object)((Object)componentLocation), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
    }

    public static IChangeSetHandle doCreateGeneratedChangeSet(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, locationHint.getWorkspaceLocation(), feedback);
        return ws.createGeneratedChangeSet(provider, locationHint, updates, updated, feedback);
    }

    private IChangeSetHandle createGeneratedChangeSet(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation compLoc = locationHint.getComponentLocation();
        JzRepoComponent comp = this.getJzRepoComponent(compLoc, feedback);
        JzRepoConfiguration config = this.computeConfig(comp, feedback);
        return config.createChangeSet(feedback);
    }

    public IComponentHandle lookupComponentHandleInWorkspace(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        IComponent cHByLocation = this.lookupComponent(componentLocation, null);
        boolean found = false;
        for (IComponentHandle cHInWs : JzRepoWorkspace.getComponentHandles(this.provider(), (IFlowNodeConnection)this.getConnection(feedback))) {
            if (!cHByLocation.sameItemId((IItemHandle)cHInWs) || !cHByLocation.sameStateId((IItemHandle)cHInWs)) continue;
            found = true;
            break;
        }
        return found ? cHByLocation : null;
    }

    public IConfiguration lookupConfiguration(JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        IComponentHandle componentHandle;
        IConfiguration config = null;
        JzProvider provider = this.provider();
        JzLocation compLoc = loc.lookupContextLocation(JzLocation.Kind.Component);
        if (compLoc != null && (componentHandle = this.lookupComponentHandle(compLoc, feedback)) != null) {
            try {
                config = this.getConnection(feedback).configuration(componentHandle);
            }
            catch (ItemNotFoundException e) {
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupConfiguration", (Exception)((Object)e));
                config = null;
            }
            catch (ComponentNotInWorkspaceException e) {
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupConfiguration", (Exception)((Object)e));
                config = null;
            }
            catch (WvcmException e) {
                if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                    throw e;
                }
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkspace.lookupConfiguration", (Exception)((Object)e), null);
                config = null;
            }
        }
        return config;
    }

    public IConfiguration ensureComponentInConfiguration(JzRepoComponent comp, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback.nest(10));
        IComponentHandle componentHandle = comp.getComponentItemHandle(feedback.nest(20));
        IConfiguration result = null;
        try {
            result = wsConn.configuration(componentHandle);
        }
        catch (ItemNotFoundException e1) {
            throw JzProvider.wrapException(e1);
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            try {
                wsConn.addComponent(componentHandle, false, JzProvider.getMonitor(feedback, 100));
                this.logDebug("added component to workspace: " + comp.location().string());
                result = wsConn.configuration(componentHandle);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        return result;
    }

    public void recordChangeSet(JzRepoChangeSet cs) {
        List<JzRepoChangeSet> currentList = null;
        currentList = RepoWorkspacesLocations2CurrentActivities.get((Object)this.location());
        if (currentList == null) {
            currentList = new ArrayList<JzRepoChangeSet>();
            RepoWorkspacesLocations2CurrentActivities.put(this.location(), currentList);
        }
        currentList.add(cs);
    }

    public void closeCurrentActivities(JzRepoComponent comp, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback.nest(10));
        JzRepoConfiguration config = this.computeConfig(comp, feedback.nest(20));
        List activeCSs = wsConn.activeChangeSets(comp.getComponentItemHandle(feedback.nest(50)));
        for (IChangeSetHandle changeSetHandle : activeCSs) {
            config.closeChangeSet(this, changeSetHandle, feedback);
        }
    }

    public void closeChangeSets(SrvcFeedback feedback, IChangeSetHandle ... changeSetHandles) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection(feedback.nest(10));
        try {
            wsConn.closeChangeSets(Arrays.asList(changeSetHandles), JzProvider.getMonitor(feedback, 10));
            IChangeSetHandle[] iChangeSetHandleArray = changeSetHandles;
            int n = changeSetHandles.length;
            int n2 = 0;
            while (n2 < n) {
                IChangeSetHandle handle = iChangeSetHandleArray[n2];
                this.recordChangeSet(JzRepoChangeSet.create(this.provider(), handle, feedback.nest(90)));
                ++n2;
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    protected static void refresh(JzProvider provider, IWorkspaceConnection conn, SrvcFeedback feedback) throws WvcmException {
        try {
            conn.refresh(JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            provider.logIgnoredExceptionAsAlwaysVisible("refresh workspace connection failed", (Exception)((Object)e));
        }
    }

    public void doWorkspaceConfigurationCheckin(ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue commentPVal;
        String comment;
        String displayName;
        PropValue displayNamePVal = updates.get(Configuration.DISPLAY_NAME);
        String string = displayName = displayNamePVal != null ? (String)displayNamePVal.get_value() : null;
        if (displayName != null && updated != null) {
            updated.add(Configuration.DISPLAY_NAME);
        }
        String string2 = comment = (commentPVal = updates.get(Resource.COMMENT)) != null ? (String)commentPVal.get_value() : null;
        if (comment != null && updated != null) {
            updated.add(Resource.COMMENT);
        }
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback);
        try {
            IBaselineSetHandle snapshotHandle = wsConn.createBaselineSet(Collections.emptyList(), displayName, comment, 1, JzProvider.getMonitor(feedback, 100));
            this.justCreatedSnapshot = JzRepoBaseline.createSnapshot(this.provider(), snapshotHandle);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public JzRepoBaseline lookupLatestSnapshot(SrvcFeedback feedback) throws WvcmException {
        if (this.justCreatedSnapshot != null) {
            return this.justCreatedSnapshot;
        }
        JzRepoBaseline result = null;
        JzProvider p = this.provider();
        IBaselineSetSearchCriteria crit = IBaselineSetSearchCriteria.FACTORY.newInstance().setOwnerWorkspaceOptional((IWorkspaceHandle)this.getResolvedWorkspace(feedback.nest(10)));
        try {
            List sets = SCMPlatform.getWorkspaceManager((ITeamRepository)p.getRepo()).findBaselineSets(crit, 2, JzProvider.getMonitor(feedback, 100));
            if (sets.size() > 0) {
                IBaselineSetHandle LatestSnapshot = (IBaselineSetHandle)sets.get(0);
                result = JzRepoBaseline.createSnapshot(p, LatestSnapshot);
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
        return result;
    }
}

