grammar Query;


@header {
/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2014, 2015. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
package com.ibm.team.scm.common.internal.query.parser.generated;
}


query
: expression EOF
;

expression
: clause                           # clauseExpr
| expression (AND | OR) expression # conjunctionExpr
| '(' expression ')'               # parenExpr
;

clause
: attribute_equals
| attribute_matches
| attribute_contains
| function
;

attribute_equals
: attribute_name (EQUALS | '=') equality_value
;

attribute_matches
: attribute_name MATCHES string_value
;

attribute_contains
: attribute_name CONTAINS string_value
;

arg_value
: equality_value
| uuid_value
| attribute_name
| integer_value
| alias_value
;

attribute_name
: IDENTIFIER
| STRING_LITERAL
;

equality_value
: string_value
;

uuid_value
: UUID
;

string_value
: STRING_LITERAL
;

function
: IDENTIFIER '(' arg_list? ')'
;

arg_list
: argument (',' argument)*
;

argument
: arg_value
;

integer_value
: INTEGER
;

alias_value
: ALIAS
;

STRING_LITERAL
: '"' ((~["\\\r\n]) | STRING_ESCAPE)* '"'
| '\'' ((~['\\\r\n]) | STRING_ESCAPE)* '\''
;

fragment
STRING_ESCAPE: '\\' [rn\\"'];

WHITESPACE: [ \r\n\t] -> skip;

EQUALS: [Ee][Qq][Uu][Aa][Ll][Ss];
MATCHES: [Mm][Aa][Tt][Cc][Hh][Ee][Ss];
CONTAINS: [Cc][Oo][Nn][Tt][Aa][Ii][Nn][Ss];

OR: [Oo][Rr];
AND: [Aa][Nn][Dd];
NOT: [Nn][Oo][Tt];

fragment
UUID_DIGIT: [-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz];
fragment
UUID_LAST_DIGIT: [AQgw];
UUID: '_' UUID_DIGIT
  UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT
  UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT
  UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT
  UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT UUID_DIGIT
  UUID_LAST_DIGIT;

IDENTIFIER: [a-zA-Z_][a-zA-Z0-9_]*;

INTEGER: [1-9][0-9]*;

ALIAS: '@'[1-9][0-9]*;
