/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.marshalling;

import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.internal.JSONSerializer;
import com.ibm.team.repository.common.serialize.internal.UriSerializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;

public class ExceptionHandlingJSONSerializer
extends JSONSerializer {
    public static final String ERROR_STATUS_CHILDREN = "-children";
    public static final String ERROR_STATUS_EXCEPTION = "-exception";
    public static final String ERROR_STATUS_IS_MULTI = "-isMultiStatus";
    public static final String ERROR_STATUS_SEVERITY = "-severity";
    public static final String ERROR_STATUS_PLUGIN = "-plugin";
    public static final String ERROR_STATUS_MESSAGE = "-message";
    public static final String ERROR_STATUS_CODE = "-code";
    public static final String ERROR_STATUS_DATA = "-errorStatusData";

    public ExceptionHandlingJSONSerializer(boolean format) {
        super(HttpUtil.MediaType.JSON, "", format, (IURISerializer)new UriSerializer());
    }

    public void serializeException(Throwable exception, Integer errorCode, Writer writer) throws TeamRepositoryException, IOException {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        JSONObject obj = new JSONObject();
        this.formatErrorObj(obj, exception, errorCode);
        if (exception instanceof TeamRepositoryException && ((TeamRepositoryException)exception).getData() instanceof EObject) {
            EObject data = (EObject)((TeamRepositoryException)exception).getData();
            obj.put((Object)"errorData", (Object)this.reflectiveToJSONObject(data, data.getClass(), this.createSerializationContext(false)));
        }
        obj.serialize(writer, this.format());
    }

    private void formatErrorObj(JSONObject obj, Throwable ex, Integer errorCode) {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null");
        }
        if (ex == null) {
            throw new IllegalArgumentException("ex must not be null");
        }
        StackTraceElement[] stackTraceElems = ex.getStackTrace();
        JSONArray stackTrace = new JSONArray();
        JSONArray formattedStackTrace = new JSONArray();
        StackTraceElement[] stackTraceElementArray = stackTraceElems;
        int n = stackTraceElems.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            stackTrace.add((Object)elem.toString());
            JSONObject traceObj = new JSONObject();
            traceObj.put((Object)"errorTraceClassName", (Object)elem.getClassName());
            traceObj.put((Object)"errorTraceMethodName", (Object)elem.getMethodName());
            traceObj.put((Object)"errorTraceFileName", (Object)elem.getFileName());
            traceObj.put((Object)"errorTraceLineNumber", (Object)elem.getLineNumber());
            formattedStackTrace.add((Object)traceObj);
            ++n2;
        }
        obj.put((Object)"errorClass", (Object)ex.getClass().getCanonicalName());
        obj.put((Object)"errorCode", (Object)errorCode);
        obj.put((Object)"errorMessage", (Object)ex.getMessage());
        obj.put((Object)"errorTrace", (Object)stackTrace);
        obj.put((Object)"errorTraceMarshall", (Object)formattedStackTrace);
        Throwable source = ex.getCause();
        if (source != null) {
            JSONObject nestedObj = new JSONObject();
            obj.put((Object)"nestedError", (Object)nestedObj);
            this.formatErrorObj(nestedObj, source, null);
        }
        if (ex instanceof CoreException) {
            JSONObject statusData = new JSONObject();
            IStatus status = ((CoreException)ex).getStatus();
            this.formatStatusObj(statusData, status);
            if (statusData.size() > 0) {
                obj.put((Object)ERROR_STATUS_DATA, (Object)statusData);
            }
        }
        if (ex instanceof FileSystemStatusException) {
            JSONObject statusData = new JSONObject();
            IStatus status = ((FileSystemStatusException)ex).getStatus();
            this.formatStatusObj(statusData, status);
            if (statusData.size() > 0) {
                obj.put((Object)ERROR_STATUS_DATA, (Object)statusData);
            }
        }
        if (ex instanceof TeamRepositoryException) {
            TeamRepositoryException tre = (TeamRepositoryException)ex;
            JSONObject extraData = new JSONObject();
            Object ctx = this.createSerializationContext(true);
            if (ctx != null) {
                for (Map.Entry entry : tre.getSerializableData().entrySet()) {
                    if (!(entry.getValue() instanceof EObject)) continue;
                    EObject value = (EObject)entry.getValue();
                    Class<?> eClass = null;
                    if (value != null) {
                        eClass = value.getClass();
                    }
                    extraData.put(entry.getKey(), (Object)this.reflectiveToJSONObject(value, eClass, ctx));
                }
            }
            if (extraData.size() > 0) {
                obj.put((Object)"errorAllData", (Object)extraData);
            }
        }
    }

    private JSONObject reflectiveToJSONObject(EObject eObject, Class<?> expectedType, Object ctx) {
        Exception fail;
        try {
            Method toCall = JSONSerializer.class.getDeclaredMethod("toJSONObject", EObject.class, Class.class, ctx.getClass());
            toCall.setAccessible(true);
            return (JSONObject)toCall.invoke((Object)this, eObject, expectedType, ctx);
        }
        catch (SecurityException e) {
            fail = e;
        }
        catch (IllegalArgumentException e) {
            fail = e;
        }
        catch (NoSuchMethodException e) {
            fail = e;
        }
        catch (IllegalAccessException e) {
            fail = e;
        }
        catch (InvocationTargetException e) {
            fail = e;
        }
        LoggingHelper.error((String)"com.ibm.team.filesystem.client.daemon", (String)"Reflection failure", (Throwable)fail);
        return new JSONObject();
    }

    private Object createSerializationContext(boolean include_etype) {
        Object ctxInstance = null;
        Exception fail = null;
        try {
            Class<?> ctxClass = JSONSerializer.class.getClassLoader().loadClass("com.ibm.team.repository.common.serialize.internal.JSONSerializer$SerializationContext");
            Constructor<?> cons = ctxClass.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            ctxInstance = cons.newInstance(new Object[0]);
            Field typeFeld = ctxClass.getDeclaredField("include_etype");
            typeFeld.setAccessible(true);
            typeFeld.setBoolean(ctxInstance, include_etype);
        }
        catch (SecurityException e) {
            fail = e;
        }
        catch (IllegalArgumentException e) {
            fail = e;
        }
        catch (ClassNotFoundException e) {
            fail = e;
        }
        catch (IllegalAccessException e) {
            fail = e;
        }
        catch (InstantiationException e) {
            fail = e;
        }
        catch (NoSuchFieldException e) {
            fail = e;
        }
        catch (NoSuchMethodException e) {
            fail = e;
        }
        catch (InvocationTargetException e) {
            fail = e;
        }
        if (fail != null) {
            LoggingHelper.error((String)"com.ibm.team.filesystem.client.daemon", (String)"Reflection failure", (Throwable)fail);
            return ctxInstance;
        }
        return ctxInstance;
    }

    private void formatStatusObj(JSONObject statusData, IStatus status) {
        statusData.put((Object)ERROR_STATUS_CODE, (Object)status.getCode());
        statusData.put((Object)ERROR_STATUS_MESSAGE, (Object)status.getMessage());
        statusData.put((Object)ERROR_STATUS_PLUGIN, (Object)status.getPlugin());
        statusData.put((Object)ERROR_STATUS_SEVERITY, (Object)status.getSeverity());
        statusData.put((Object)ERROR_STATUS_IS_MULTI, (Object)status.isMultiStatus());
        Throwable ex = status.getException();
        if (ex != null) {
            JSONObject innerExceptionData = new JSONObject();
            this.formatErrorObj(innerExceptionData, ex, null);
            statusData.put((Object)ERROR_STATUS_EXCEPTION, (Object)innerExceptionData);
        }
        if (status.getChildren().length > 0) {
            JSONArray children = new JSONArray();
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                JSONObject inner = new JSONObject();
                this.formatStatusObj(inner, child);
                children.add((Object)inner);
                ++n2;
            }
            statusData.put((Object)ERROR_STATUS_CHILDREN, (Object)children);
        }
    }
}

