/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class FileChange {
    private FileState initialState;
    private FileState finalState;
    private SiloedItemId itemId;

    public FileChange(FileState initialState, FileState finalState, SiloedItemId<IVersionable> itemId) {
        this.initialState = initialState;
        this.finalState = finalState;
        this.itemId = itemId;
    }

    public FileState getNonDeleted(boolean before) {
        if (before) {
            return this.initialState.isDeleted() ? this.finalState : this.initialState;
        }
        return this.finalState.isDeleted() ? this.initialState : this.finalState;
    }

    public FileState getInitial() {
        return this.initialState;
    }

    public FileState getFinal() {
        return this.finalState;
    }

    public ItemId<IVersionable> getItemId() {
        return this.itemId.getItemId();
    }

    public SiloedItemId<IVersionable> getSiloedItemId() {
        return this.itemId;
    }

    public FileChange reverse() {
        return new FileChange(this.finalState, this.initialState, (SiloedItemId<IVersionable>)this.itemId);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.finalState == null ? 0 : this.finalState.hashCode());
        result = 31 * result + (this.initialState == null ? 0 : this.initialState.hashCode());
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileChange other = (FileChange)obj;
        if (this.finalState == null ? other.finalState != null : !this.finalState.equals(other.finalState)) {
            return false;
        }
        if (this.initialState == null ? other.initialState != null : !this.initialState.equals(other.initialState)) {
            return false;
        }
        return !(this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId));
    }

    public boolean isModify() {
        return !this.initialState.isDeleted() && !this.finalState.isDeleted();
    }

    public boolean isFolder() {
        return this.getNonDeleted(true).isFolder();
    }

    public static List<FileChange> filterNops(Collection<FileChange> changes) {
        ArrayList<FileChange> result = new ArrayList<FileChange>();
        for (FileChange next : changes) {
            if (next.getInitial().equals(next.getFinal())) continue;
            result.add(next);
        }
        return result;
    }

    public boolean hasPropertyChange() {
        FileState initialState = this.getInitial();
        if (initialState.isDeleted()) {
            return false;
        }
        FileState finalState = this.getFinal();
        if (finalState.isDeleted()) {
            return false;
        }
        Map<String, String> initialProperties = initialState.getProperties();
        Map<String, String> finalProperties = finalState.getProperties();
        if (initialProperties.size() != finalProperties.size()) {
            return true;
        }
        for (String name : initialProperties.keySet()) {
            String otherValue = finalProperties.get(name);
            if (otherValue == null) {
                return true;
            }
            if (otherValue.equals(initialProperties.get(name))) continue;
            return true;
        }
        if (initialState.isExectuable() != finalState.isExectuable()) {
            return true;
        }
        if (initialState.getLineDelimiter() != finalState.getLineDelimiter()) {
            return true;
        }
        return !initialState.getContentType().equals(finalState.getContentType());
    }
}

