/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.impl;

import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FileItemHandle;
import com.ibm.team.filesystem.common.internal.FilesystemPackage;
import com.ibm.team.filesystem.common.internal.IFileItemProperties;
import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.VersionedContent;
import com.ibm.team.scm.common.internal.impl.VersionableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class FileItemImpl
extends VersionableImpl
implements FileItem {
    protected int ALL_FLAGS = 0;
    protected IFileContent content;
    protected static final int CONTENT_ESETFLAG = 4096;
    protected static final boolean EXECUTABLE_EDEFAULT = false;
    protected static final int EXECUTABLE_EFLAG = 8192;
    protected static final int EXECUTABLE_ESETFLAG = 16384;
    private static final String id = "com.ibm.team.filesystem.common";
    private static final int EOFFSET_CORRECTION = FilesystemPackage.Literals.FILE_ITEM.getFeatureID((EStructuralFeature)FilesystemPackage.Literals.FILE_ITEM__CONTENT) - 19;

    protected FileItemImpl() {
    }

    protected EClass eStaticClass() {
        return FilesystemPackage.Literals.FILE_ITEM;
    }

    @Override
    public IFileContent getContent() {
        return this.content;
    }

    public NotificationChain basicSetContent(IFileContent newContent, NotificationChain msgs) {
        IFileContent oldContent = this.content;
        this.content = newContent;
        boolean oldContentESet = (this.ALL_FLAGS & 0x1000) != 0;
        this.ALL_FLAGS |= 0x1000;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 19 + EOFFSET_CORRECTION, (Object)oldContent, (Object)newContent, !oldContentESet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setContent(IFileContent newContent) {
        if (newContent != this.content) {
            NotificationChain msgs = null;
            if (this.content != null) {
                msgs = ((InternalEObject)this.content).eInverseRemove((InternalEObject)this, -20 - EOFFSET_CORRECTION, null, msgs);
            }
            if (newContent != null) {
                msgs = ((InternalEObject)newContent).eInverseAdd((InternalEObject)this, -20 - EOFFSET_CORRECTION, null, msgs);
            }
            if ((msgs = this.basicSetContent(newContent, msgs)) != null) {
                msgs.dispatch();
            }
        } else {
            boolean oldContentESet = (this.ALL_FLAGS & 0x1000) != 0;
            this.ALL_FLAGS |= 0x1000;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19 + EOFFSET_CORRECTION, (Object)newContent, (Object)newContent, !oldContentESet));
            }
        }
    }

    public NotificationChain basicUnsetContent(NotificationChain msgs) {
        IFileContent oldContent = this.content;
        this.content = null;
        boolean oldContentESet = (this.ALL_FLAGS & 0x1000) != 0;
        this.ALL_FLAGS &= 0xFFFFEFFF;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 2, 19 + EOFFSET_CORRECTION, (Object)oldContent, null, oldContentESet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void unsetContent() {
        if (this.content != null) {
            NotificationChain msgs = null;
            msgs = ((InternalEObject)this.content).eInverseRemove((InternalEObject)this, -20 - EOFFSET_CORRECTION, null, msgs);
            if ((msgs = this.basicUnsetContent(msgs)) != null) {
                msgs.dispatch();
            }
        } else {
            boolean oldContentESet = (this.ALL_FLAGS & 0x1000) != 0;
            this.ALL_FLAGS &= 0xFFFFEFFF;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 19 + EOFFSET_CORRECTION, null, null, oldContentESet));
            }
        }
    }

    @Override
    public boolean isSetContent() {
        return (this.ALL_FLAGS & 0x1000) != 0;
    }

    @Override
    public boolean isExecutable() {
        return (this.ALL_FLAGS & 0x2000) != 0;
    }

    @Override
    public void setExecutable(boolean newExecutable) {
        boolean oldExecutable;
        boolean bl = oldExecutable = (this.ALL_FLAGS & 0x2000) != 0;
        this.ALL_FLAGS = newExecutable ? (this.ALL_FLAGS |= 0x2000) : (this.ALL_FLAGS &= 0xFFFFDFFF);
        boolean oldExecutableESet = (this.ALL_FLAGS & 0x4000) != 0;
        this.ALL_FLAGS |= 0x4000;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20 + EOFFSET_CORRECTION, oldExecutable, newExecutable, !oldExecutableESet));
        }
    }

    @Override
    public void unsetExecutable() {
        boolean oldExecutable = (this.ALL_FLAGS & 0x2000) != 0;
        boolean oldExecutableESet = (this.ALL_FLAGS & 0x4000) != 0;
        this.ALL_FLAGS &= 0xFFFFDFFF;
        this.ALL_FLAGS &= 0xFFFFBFFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 20 + EOFFSET_CORRECTION, oldExecutable, false, oldExecutableESet));
        }
    }

    @Override
    public boolean isSetExecutable() {
        return (this.ALL_FLAGS & 0x4000) != 0;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                return this.basicUnsetContent(msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                return this.getContent();
            }
            case 20: {
                return this.isExecutable() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                this.setContent((IFileContent)newValue);
                return;
            }
            case 20: {
                this.setExecutable((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                this.unsetContent();
                return;
            }
            case 20: {
                this.unsetExecutable();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                return this.isSetContent();
            }
            case 20: {
                return this.isSetExecutable();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == IFileItemHandle.class) {
            return -1;
        }
        if (baseClass == FileItemHandle.class) {
            return -1;
        }
        if (baseClass == IFileItem.class) {
            return -1;
        }
        if (baseClass == FileItem.class) {
            switch (baseFeatureID - EOFFSET_CORRECTION) {
                case 19: {
                    return 19 + EOFFSET_CORRECTION;
                }
                case 20: {
                    return 20 + EOFFSET_CORRECTION;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (executable: ");
        if ((this.ALL_FLAGS & 0x4000) != 0) {
            result.append((this.ALL_FLAGS & 0x2000) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public Date getFileTimestamp() {
        String timeStampString = (String)this.getProperties().get("fileTimestamp");
        long timeStamp = 0L;
        if (timeStampString != null && timeStampString.length() > 0) {
            timeStamp = Long.valueOf(timeStampString);
        }
        return new Date(timeStamp);
    }

    @Override
    public void setFileTimestamp(Date date) {
        this.getProperties().put("fileTimestamp", Long.toString(date.getTime()));
    }

    protected void initWorkingCopy(Item workingCopy) {
        super.initWorkingCopy(workingCopy);
        FileItem copy = (FileItem)workingCopy;
        VersionedContent vc = (VersionedContent)copy.getContent();
        vc.setOriginalContainingState((IVersionableHandle)this.getStateHandle());
    }

    @Override
    public String getContentType() {
        return (String)this.getProperties().get("contentType");
    }

    @Override
    public void setContentType(String contentType) {
        if (contentType == null || contentType.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.getString("FileItemImpl_0"));
        }
        this.getProperties().put("contentType", contentType);
    }

    @Override
    public IStatus validate() {
        IFileContent fileContent;
        IStatus contentStatus;
        ArrayList<Object> errors = new ArrayList<Object>();
        IStatus status = super.validate();
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = iStatusArray[n2];
                    errors.add(child);
                    ++n2;
                }
            } else {
                errors.add(status);
            }
        }
        Map properties = this.getProperties();
        int requiredCount = 0;
        for (String property : properties.keySet()) {
            if (!IFileItemProperties.requiredProperties.contains(property)) {
                if (!property.startsWith("scm") && !property.startsWith("rtc")) continue;
                errors.add(new Status(4, id, NLS.bind((String)Messages.getString("FileItemImpl_2"), (Object)this.getName(), (Object[])new Object[]{property})));
                continue;
            }
            ++requiredCount;
        }
        if (requiredCount != IFileItemProperties.requiredProperties.size()) {
            for (String requiredProperty : IFileItemProperties.requiredProperties) {
                if (properties.containsKey(requiredProperty)) continue;
                errors.add(new Status(4, id, NLS.bind((String)Messages.getString("FileItemImpl_1"), (Object)this.getName(), (Object[])new Object[]{requiredProperty})));
            }
        }
        if (!(contentStatus = (fileContent = this.getContent()).validate()).isOK()) {
            if (contentStatus.isMultiStatus()) {
                errors.add(new MultiStatus(id, 4, contentStatus.getChildren(), NLS.bind((String)Messages.getString("FileItemImpl_3"), (Object)this.getName(), (Object[])new Object[0]), null));
            } else {
                errors.add(new Status(4, id, NLS.bind((String)Messages.getString("FileItemImpl_4"), (Object)this.getName(), (Object[])new Object[]{contentStatus.getMessage()})));
            }
        }
        String mediaType = this.getContentType();
        String characterEncoding = fileContent.getCharacterEncoding();
        if (this.isTextType(mediaType) && (characterEncoding == null || characterEncoding.trim().equals(""))) {
            errors.add(new Status(4, id, NLS.bind((String)Messages.getString("FileItemImpl_5"), (Object)this.getName(), (Object[])new Object[0])));
        }
        if (errors.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (errors.size() == 1) {
            return (IStatus)errors.get(0);
        }
        return new MultiStatus(id, 4, errors.toArray(new IStatus[errors.size()]), NLS.bind((String)Messages.getString("FileItemImpl_6"), (Object)this.getName(), (Object[])new Object[0]), null);
    }

    private boolean isTextType(String mediaType) {
        return mediaType != null && mediaType.trim().toLowerCase().startsWith("text");
    }

    public Map<String, String> getUserProperties() {
        Map filteredProperties = super.getUserProperties();
        if (filteredProperties.isEmpty()) {
            return filteredProperties;
        }
        HashMap userProperties = new HashMap(filteredProperties);
        userProperties.remove("contentType");
        userProperties.remove("fileTimestamp");
        return Collections.unmodifiableMap(userProperties);
    }

    public String removeUserProperty(String propertyName) {
        if (propertyName.equals("contentType") || propertyName.equals("fileTimestamp")) {
            throw new IllegalArgumentException();
        }
        return super.removeUserProperty(propertyName);
    }

    public String setUserProperty(String propertyName, String value) {
        if ("contentType".equals(propertyName) || "fileTimestamp".equals(propertyName)) {
            throw new IllegalArgumentException();
        }
        return super.setUserProperty(propertyName, value);
    }
}

