/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.internal.login.KeyStoreKeyManager;
import com.ibm.team.repository.client.internal.login.KeyStoreKeyManagerProvider;
import com.ibm.team.repository.client.login.IAliasChooser;
import com.ibm.team.repository.client.login.KeyStoreLoginInfo;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;

public class SmartCardLoginInfo
extends KeyStoreLoginInfo {
    private static final String ALIAS = "userId";
    private String alias;

    static {
        Security.addProvider(new KeyStoreKeyManagerProvider());
    }

    public SmartCardLoginInfo() {
        KeyStoreKeyManager.setClientAliasChooser(null);
    }

    public SmartCardLoginInfo(final String alias) {
        this.alias = alias;
        KeyStoreKeyManager.setClientAliasChooser(new IAliasChooser(){

            @Override
            public String chooseAlias(List<String> aliases) {
                return alias;
            }
        });
    }

    public SmartCardLoginInfo(IAliasChooser aliasChooser) {
        KeyStoreKeyManager.setClientAliasChooser(aliasChooser);
    }

    @Override
    protected KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance("KeyStoreKeyManager");
    }

    @Override
    protected KeyStore createKeyStore() throws KeyStoreException {
        return this.getKeyStore("Windows-MY");
    }

    @Override
    public Properties getLoginProperties() {
        Properties properties = super.getLoginProperties();
        if (this.alias != null) {
            properties.setProperty(ALIAS, this.alias);
        }
        return properties;
    }

    @Override
    public void setLoginProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        this.alias = properties.getProperty(ALIAS);
    }
}

