/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.login.KeyStoreLoginInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Properties;

public class SSLCertificateLoginInfo
extends KeyStoreLoginInfo {
    private static final String CERTIFICATE_LOCATION = "certificateLocation";
    protected String certificateLocation;

    public SSLCertificateLoginInfo() {
    }

    public SSLCertificateLoginInfo(String certificateLocation, String password) {
        super(password);
        this.setCertificateLocation(certificateLocation);
    }

    public String getCertificateLocation() {
        return this.certificateLocation;
    }

    @Override
    protected KeyStore createKeyStore() throws KeyStoreException {
        return this.getKeyStore("PKCS12");
    }

    @Override
    public Properties getLoginProperties() {
        Properties properties = super.getLoginProperties();
        properties.setProperty(CERTIFICATE_LOCATION, this.certificateLocation);
        return properties;
    }

    @Override
    public Properties getSecuredLoginProperties() throws SavedPasswordNotObtainedException {
        Properties properties = new Properties();
        String key = this.getCertificateLocation();
        String password = this.getPassword();
        String value = password != null ? password : "";
        properties.setProperty(key, value);
        return properties;
    }

    @Override
    protected InputStream openKeyStoreInputStream() throws IOException {
        String location = this.getCertificateLocation();
        return new FileInputStream(location);
    }

    public void setCertificateLocation(String certificateLocation) {
        this.certificateLocation = certificateLocation;
    }

    @Override
    public void setLoginProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String value = properties.getProperty(CERTIFICATE_LOCATION, null);
        this.setCertificateLocation(value);
    }

    @Override
    public void setSecuredLoginProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String key = this.getCertificateLocation();
        String password = properties.getProperty(key);
        this.setPassword(password);
    }
}

