/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class ThreadPool {
    private static final String EMPTY_STRING = "";
    PoolJob[] jobs;
    LinkedList<Task> tasks = new LinkedList();
    MultiStatus errorStatus = new MultiStatus("com.ibm.team.repository.client", 0, "", null);
    private boolean allowFailures;
    private final Object unfinishedJobsLock = new Object();
    private int unfinishedJobs = 0;
    private final IJobChangeListener jobListener = new JobChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            try {
                PoolJob job = (PoolJob)event.getJob();
                ThreadPool.this.taskComplete(job, job.nextTask, job.lastStatus);
            }
            catch (Throwable throwable) {
                Object object = ThreadPool.this.unfinishedJobsLock;
                synchronized (object) {
                    ThreadPool threadPool = ThreadPool.this;
                    threadPool.unfinishedJobs = threadPool.unfinishedJobs - 1;
                    ThreadPool.this.unfinishedJobsLock.notifyAll();
                }
                throw throwable;
            }
            Object object = ThreadPool.this.unfinishedJobsLock;
            synchronized (object) {
                ThreadPool threadPool = ThreadPool.this;
                threadPool.unfinishedJobs = threadPool.unfinishedJobs - 1;
                ThreadPool.this.unfinishedJobsLock.notifyAll();
            }
            super.done(event);
        }
    };

    public ThreadPool(int threadCount, boolean allowFailures) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("threadCount must be positive");
        }
        this.allowFailures = allowFailures;
        this.jobs = new PoolJob[threadCount];
    }

    protected void taskComplete(PoolJob job, Task task, IStatus status) {
        if (status != null && !status.isOK()) {
            this.recordStatusFailure(status);
        }
        this.reschedule(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordStatusFailure(IStatus status) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            assert (!status.isOK());
            if (!this.allowFailures || status.matches(8)) {
                int i = 0;
                while (i < this.jobs.length) {
                    if (this.jobs[i] != null) {
                        this.jobs[i].cancel();
                    }
                    ++i;
                }
                this.tasks.clear();
            }
            this.setCancellation(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancellation(IStatus status) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (status.matches(8)) {
                if (!this.errorStatus.isOK()) {
                    this.tasks.notifyAll();
                    return;
                }
            } else if (this.errorStatus.matches(8)) {
                this.errorStatus = new MultiStatus("com.ibm.team.repository.client", 0, EMPTY_STRING, null);
            }
            this.errorStatus.add(status);
            if (!status.isOK()) {
                this.tasks.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task) throws CoreException {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            this.handleCancelled();
            int i = 0;
            while (i < this.jobs.length) {
                if (this.jobs[i] == null) {
                    this.jobs[i] = new PoolJob(i, this);
                    this.jobs[i].addJobChangeListener(this.jobListener);
                }
                if (this.jobs[i].getState() != 4 && this.jobs[i].nextTask == null) {
                    this.jobs[i].nextTask = task;
                    this.jobs[i].lastStatus = null;
                    this.jobs[i].schedule();
                    return;
                }
                ++i;
            }
            this.tasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reschedule(PoolJob job) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (this.tasks.isEmpty()) {
                job.nextTask = null;
                return;
            }
            job.nextTask = this.tasks.removeFirst();
            job.lastStatus = null;
            job.schedule();
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this.tasks;
        synchronized (object) {
            while (!this.tasks.isEmpty()) {
                this.tasks.wait();
            }
        }
        Job.getJobManager().join((Object)this, null);
        object = this.unfinishedJobsLock;
        synchronized (object) {
            while (this.unfinishedJobs > 0) {
                this.unfinishedJobsLock.wait();
            }
        }
    }

    private void handleCancelled() throws CoreException {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (this.errorStatus.isOK() || this.allowFailures && !this.errorStatus.matches(8)) {
                return;
            }
            if (this.isCanceled()) {
                throw new OperationCanceledException();
            }
            IStatus[] children = this.errorStatus.getChildren();
            if (children.length == 1) {
                throw new CoreException(children[0]);
            }
            throw new CoreException((IStatus)new MultiStatus("com.ibm.team.repository.client", 0, children, NLS.bind((String)Messages.getServerString("ThreadPool.ErrorMessage"), (Object)children.length, (Object[])new Object[0]), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            block4: {
                if (!this.errorStatus.isOK()) break block4;
                return false;
            }
            return this.errorStatus.matches(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus[] getErrorStatus() {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            return this.errorStatus.getChildren();
        }
    }

    protected static class PoolJob
    extends Job {
        ThreadPool owner;
        protected Task nextTask;
        protected IStatus lastStatus;

        public PoolJob(int i, ThreadPool pool) {
            super(Messages.getServerString("_NoId.ThreadPool.DownloadJob"));
            this.setSystem(true);
            this.owner = pool;
        }

        public boolean belongsTo(Object o) {
            return o == this.owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = this.owner.unfinishedJobsLock;
            synchronized (object) {
                ThreadPool threadPool = this.owner;
                threadPool.unfinishedJobs = threadPool.unfinishedJobs + 1;
            }
            if (this.nextTask == null) {
                throw new IllegalStateException("A PoolJob should never be scheduled without a task");
            }
            try {
                this.lastStatus = this.nextTask.run(monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.lastStatus = Status.CANCEL_STATUS;
            }
            catch (CoreException e) {
                this.lastStatus = new MultiStatus("com.ibm.team.repository.client", 0, new IStatus[]{e.getStatus()}, Messages.getServerString("ThreadPool.ThreadPoolException"), (Throwable)e);
            }
            catch (Exception t) {
                this.lastStatus = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("ThreadPool.ThreadPoolException"), (Throwable)t);
            }
            return Status.OK_STATUS;
        }

        public String toString() {
            String status = null;
            switch (super.getState()) {
                case 0: {
                    status = Messages.getServerString("_NoId.ThreadPool.None");
                    break;
                }
                case 4: {
                    status = Messages.getServerString("_NoId.ThreadPool.Running");
                    break;
                }
                case 1: {
                    status = Messages.getServerString("_NoId.ThreadPool.Sleeping");
                    break;
                }
                case 2: {
                    status = Messages.getServerString("_NoId.ThreadPool.Waiting");
                    break;
                }
                default: {
                    status = Messages.getServerString("_NoId.ThreadPool.Unexpected");
                }
            }
            return NLS.bind((String)"ThreadPool.PoolJob[name=\"{0}\",{1}]", (Object)this.getName(), (Object[])new Object[]{status});
        }
    }

    public static interface Task {
        public IStatus run(IProgressMonitor var1) throws CoreException;
    }
}

