/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.internal;

import com.ibm.team.interop.client.rest.IRestExternalRepositoryConnection;
import com.ibm.team.interop.client.rest.internal.InteropItem;
import com.ibm.team.interop.client.rest.internal.InteropProjectAreaHandle;
import com.ibm.team.interop.client.rest.json.JSONObject;
import com.ibm.team.interop.common.dto.IInteropProjectAreaDTO;

public class RestExternalRepositoryConnection
extends InteropItem
implements IRestExternalRepositoryConnection {
    static final String EXTERNAL_REPOSITORY_CONNECTION_ITEM_TYPE = "com.ibm.team.interop.ExternalRepositoryConnection";
    static final String QUALIFIED_CLASS_NAME = "com.ibm.team.interop:ExternalRepositoryConnection";
    private static final String NAME_PROPERTY = "name";
    private static final String CONNECTIONINFO_PROPERTY = "connectionInfo";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String PROJECT_AREA_PROPERTY = "projectArea";
    private static final String EMPTY = new String();
    private static final long serialVersionUID = 4884725931385003237L;

    public RestExternalRepositoryConnection() {
        this.setItemTypeName(EXTERNAL_REPOSITORY_CONNECTION_ITEM_TYPE);
        this.setQualifiedClassName(QUALIFIED_CLASS_NAME);
    }

    public RestExternalRepositoryConnection(JSONObject other) {
        super(other);
    }

    @Override
    public String getConnectionInfo() {
        return (String)this.get(CONNECTIONINFO_PROPERTY);
    }

    @Override
    public void setConnectionInfo(String info) {
        if (info == null) {
            info = EMPTY;
        }
        this.put(CONNECTIONINFO_PROPERTY, info);
    }

    @Override
    public String getName() {
        return (String)this.get(NAME_PROPERTY);
    }

    @Override
    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name argument must not be null or empty");
        }
        this.put(NAME_PROPERTY, name);
    }

    @Override
    public void setPassword(String password) {
        if (password == null) {
            password = EMPTY;
        }
        this.put(PASSWORD_PROPERTY, password);
    }

    @Override
    public String getUserId() {
        return (String)this.get(USERNAME_PROPERTY);
    }

    @Override
    public void setUserId(String userId) {
        if (userId == null) {
            userId = EMPTY;
        }
        this.put(USERNAME_PROPERTY, userId);
    }

    @Override
    public void setProjectArea(IInteropProjectAreaDTO projectArea) {
        if (projectArea == null) {
            throw new IllegalArgumentException("The projectArea argument must not be null");
        }
        InteropProjectAreaHandle handle = new InteropProjectAreaHandle(projectArea.getItemId());
        this.put(PROJECT_AREA_PROPERTY, handle);
    }

    JSONObject getProjectAreaHandle() {
        return (JSONObject)this.get(PROJECT_AREA_PROPERTY);
    }
}

