/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.interop.InteropStreamSegment;
import com.ibm.rational.wvcm.interop.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class InteropUtilities {
    public static final String CONCAT_PATH = "{0}/{1}";
    public static final String TRUNC_PATH = ".../{0}";
    public static final String CONCAT_NAME = "{0}_{1}";
    public static final String CONCAT_NAME_PREFIX = "{0}: {1}";
    public static final String CONCAT_LIST = "{0} {1}";
    public static final String CONCAT_MSG = "{0}\n{1}";
    public static final String TRUE_STRING = Boolean.TRUE.toString();
    public static final String FALSE_STRING = Boolean.FALSE.toString();
    public static final String EMPTY_STRING = "";
    public static final String DOT = ".";
    public static final String DOTDOT = "..";
    public static final String INTEROP_NAMESPACE = "com.ibm.team.interop";
    public static final PropertyNameList.PropertyName<String> PN_LINE_SEPARATOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "PN_LINE_SEPARATOR_CONVERSION");
    public static final PropertyNameList.PropertyName<String> PN_TASK_ID = new PropertyNameList.PropertyName("com.ibm.team.interop", "TASK_ID");
    public static final PropertyNameList.PropertyName<Boolean> PN_SYMLINK_TARGET_IS_DIR = new PropertyNameList.PropertyName("com.ibm.team.interop", "SYMLINK_TARGET_IS_DIR");
    public static final PropertyRequestItem.PropertyRequest PR_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.DISPLAY_NAME});
    public static final PropertyNameList.PropertyName<Byte[]> PN_SHA_256 = new PropertyNameList.PropertyName("com.ibm.team.interop", "SHA-256");
    public static final PropertyNameList.PropertyName<Map<String, String>> PN_ATTRIBUTES = new PropertyNameList.PropertyName("com.ibm.team.interop", "ATTRIBUTES");
    public static final String IA_FORCE_EXCEPTION = "com.ibm.team.interop.FORCE_EXCEPTION";
    public static int MAX_FORCE_EXCEPTION = 28;
    private static final PropertyRequestItem.PropertyRequest PR_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION});
    public static final String IA_IGNORE_TASK_CREATION_FAILURE = "com.ibm.team.interop.IGNORE_TASK_CREATION_FAILURE";
    public static final String IA_DISABLE_HASHING_FOR_CONTENT_COMPARE = "com.ibm.team.interop.DISABLE_HASHING_FOR_CONTENT_COMPARE";
    public static final PropertyRequestItem.PropertyRequest PR_SHA_256 = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_SHA_256});
    private static int debugLevel = 3;
    private static final PropertyRequestItem.PropertyRequest PR_CHILDMAP_CONFIG = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.CHILD_MAP, ControllableFolder.ROOT_FOLDER_OF.nest(new PropertyRequestItem[]{Configuration.IS_CHECKED_OUT, Configuration.CHECKED_IN.nest(new PropertyRequestItem[]{Baseline.VERSION_NAME})})});
    public static final PropertyRequestItem.PropertyRequest PR_SUB_CONFIGS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Configuration.SUB_CONFIGURATION_LIST});
    public static final PropertyRequestItem.PropertyRequest PR_CI_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{Resource.DISPLAY_NAME})});
    public static final PropertyRequestItem.PropertyRequest PR_VH_CI_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.VERSION_HISTORY, PR_CI_DN});
    public static PropertyRequestItem.PropertyRequest PR_WS_CONFIGS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.CONFIGURATION.nest(new PropertyRequestItem[]{PR_SUB_CONFIGS}), Workspace.BASELINE_CONTROLLED_FOLDER_LIST.nest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION})});
    public static PropertyRequestItem.PropertyRequest PR_DN_BL_SUBS_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_DN, Baseline.SUCCESSOR_LIST, Baseline.SUB_BASELINE_LIST.nest(new PropertyRequestItem[]{PR_DN, new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.VERSION_HISTORY.nest(new PropertyRequestItem[]{PR_DN})})})});

    public static boolean shouldForceException(Provider p, int i) {
        String faultRequestedVal = (String)p.initArgs().get(IA_FORCE_EXCEPTION);
        if (faultRequestedVal == null || faultRequestedVal.length() == 0) {
            return false;
        }
        int faultRequested = Integer.parseInt(faultRequestedVal);
        return i == faultRequested;
    }

    public static void forceWvcmException(Provider p, int i) throws WvcmException {
        if (InteropUtilities.shouldForceException(p, i)) {
            throw new WvcmException("Aborted", WvcmException.ReasonCode.ABORTED);
        }
    }

    public static void forceAbortWvcmException(Provider p, int i, Feedback f) {
        if (InteropUtilities.shouldForceException(p, i)) {
            f.abortRequested(true);
        }
    }

    public static int LP(int percentDone, int index, int size, int begin, int end) {
        return begin + ((end - begin) * index + (end - begin) * percentDone / 100) / size;
    }

    public static String currentDate() {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date().getTime());
    }

    public static <T extends Resource> T createNewProxy(T r) throws WvcmException {
        Class<?> type = r.getClass();
        return (T)r.provider().buildProxy(type, r.location());
    }

    public static List<List<?>> chunkify(List<?> resources, int chunkSize) {
        if (chunkSize < 0) {
            throw new IllegalArgumentException("chunkSize must be non-negative");
        }
        ArrayList result = new ArrayList();
        int size = resources.size();
        if (chunkSize == 0) {
            chunkSize = size;
        }
        int from = 0;
        while (from < size) {
            int to = from + chunkSize;
            if (to > size) {
                to = size;
            }
            List<?> chunk = resources.subList(from, to);
            result.add(chunk);
            from += chunkSize;
        }
        return result;
    }

    public static <T extends Resource> ResourceList<T> makeList(T r) throws WvcmException {
        ResourceList resourceList = r.provider().resourceList(new Resource[]{r});
        return resourceList;
    }

    public static ResourceList<?> makeResourceList(Provider p, Collection<?> chunk) {
        ResourceList result = p.resourceList(new Resource[0]);
        Collection<?> chunk1 = chunk;
        result.addAll(chunk1);
        return result;
    }

    public static <T> T getProperty(Resource r, PropertyNameList.PropertyName<T> pName) throws WvcmException {
        Object value = r.lookupProperty(pName);
        if (value instanceof WvcmException) {
            WvcmException e = (WvcmException)((Object)value);
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE) || e.getReasonCode().equals((Object)WvcmException.ReasonCode.PROPERTY_NOT_SUPPORTED_BY_SERVER)) {
                return null;
            }
            throw e;
        }
        Object result = value;
        return (T)result;
    }

    public static <T> T tryGetProperty(Resource r, PropertyNameList.PropertyName<T> pName) throws WvcmException {
        Object value = r.lookupProperty(pName);
        if (value instanceof WvcmException) {
            return null;
        }
        Object result = value;
        return (T)result;
    }

    public static <T> T getOrReadProperty(Resource resource, PropertyNameList.PropertyName<T> requestedPropertyName, Feedback feedback) throws WvcmException {
        Object val = resource.lookupProperty(requestedPropertyName);
        if (val instanceof WvcmException) {
            return InteropUtilities.doReadProperty(resource, requestedPropertyName, feedback);
        }
        Object propVal = val;
        return (T)propVal;
    }

    public static <T> T doReadProperty(Resource resource, PropertyNameList.PropertyName<T> propName, Feedback feedback) throws WvcmException {
        PropertyRequestItem.PropertyRequest pr = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{propName});
        PropertyRequestItem.PropertyRequest f = feedback == null ? pr : feedback.nest(pr);
        resource = resource.doReadProperties((Feedback)f);
        return (T)resource.getProperty(propName);
    }

    public static <T extends Resource> List<T> doReadResourceProperties(List<T> listResources, Feedback f) throws WvcmException {
        if (listResources.isEmpty()) {
            return Collections.emptyList();
        }
        Provider p = ((Resource)listResources.iterator().next()).provider();
        ResourceList<?> rs = InteropUtilities.makeResourceList(p, listResources);
        int sourceCount = listResources.size();
        ArrayList<Resource> results = new ArrayList<Resource>(sourceCount);
        ResourceList.ResponseIterator it = rs.doReadProperties(f);
        while (it.hasNext()) {
            results.add((Resource)it.next());
        }
        return results;
    }

    public static ResourceList.ResponseIterator<ControllableResource> doReadProperties(List<?> listCRs, Provider p, Feedback f) throws WvcmException {
        ResourceList<?> crs = InteropUtilities.makeResourceList(p, listCRs);
        return crs.doReadProperties(f);
    }

    public static <T> void setIfNotNull(Resource target, Resource source, PropertyNameList.PropertyName<T> propertyName) throws WvcmException {
        Object obj = source.lookupProperty(propertyName);
        if (obj == null) {
            return;
        }
        if (obj instanceof WvcmException) {
            throw (WvcmException)((Object)obj);
        }
        Object value = obj;
        target.setProperty(propertyName, value);
    }

    public static String getFriendlyPathname(Resource resource, int maxLength, Feedback f) throws WvcmException {
        Location loc = resource.getPathnameLocation();
        int remainder = maxLength;
        String name = loc.lastSegment();
        while ((loc = loc.parent()) != null && loc.parent() != null && loc.parent().parent() != null) {
            if (maxLength > 0 && loc.lastSegment().length() > remainder + 5) {
                name = f.format(TRUNC_PATH, new Object[]{name});
                return name;
            }
            name = f.format(CONCAT_PATH, new Object[]{loc.lastSegment(), name});
        }
        return name;
    }

    public static String readFriendlyPathname(Resource resource, int maxLength, Feedback f) throws WvcmException {
        Resource r = resource;
        if (!(resource.lookupProperty(Resource.PATHNAME_LOCATION) instanceof String)) {
            r = resource.doReadProperties(f.nest(PR_PATH, 100));
        }
        return InteropUtilities.getFriendlyPathname(r, 0, f);
    }

    public static boolean isPathIn(ControllableResource cr, Set<String> paths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        return paths.contains(path);
    }

    public static boolean isChildOf(String childPath, String path) {
        return childPath.startsWith(path) && (childPath.length() == path.length() || childPath.charAt(path.length()) == '/');
    }

    public static boolean isPathAChildOf(ControllableResource childCR, Set<String> paths) throws WvcmException {
        String childPath = childCR.getPathnameLocation().string();
        for (String path : paths) {
            if (!InteropUtilities.isChildOf(childPath, path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathAParentOf(ControllableResource parentCR, Set<String> paths) throws WvcmException {
        String path = parentCR.getPathnameLocation().string();
        return InteropUtilities.isAParentOf(path, paths);
    }

    public static boolean isAParentOf(String parentPath, Set<String> paths) {
        for (String path : paths) {
            if (!InteropUtilities.isChildOf(path, parentPath)) continue;
            return true;
        }
        return false;
    }

    public static void rebindFixup(ControllableFolder parent, String bn, ControllableResource newChild, Set<String> rootPaths, Feedback f) throws WvcmException {
        parent.doRebindAll(bn, (Resource)newChild, null, f.nest(100));
        if (!InteropUtilities.isPathAParentOf(newChild, rootPaths)) {
            return;
        }
        String oldPath = newChild.getPathnameLocation().string();
        Location parentLoc = (Location)InteropUtilities.doReadProperty((Resource)parent, ControllableFolder.PATHNAME_LOCATION, f.nest());
        String newPath = parentLoc.child(bn).string();
        HashSet<String> removedPaths = new HashSet<String>();
        HashSet<String> addedPaths = new HashSet<String>();
        for (String rootPath : rootPaths) {
            if (!rootPath.startsWith(oldPath)) continue;
            removedPaths.add(rootPath);
            addedPaths.add(String.valueOf(newPath) + rootPath.substring(oldPath.length()));
        }
        rootPaths.removeAll(removedPaths);
        rootPaths.addAll(addedPaths);
    }

    public static String rebindToTmp(ControllableFolder sourceFolder, String bindingName, Collection<String> reservedNames, Set<String> rootPaths, Feedback f) throws WvcmException {
        int i = 0;
        while (true) {
            try {
                String newName;
                do {
                    if (InteropUtilities.shouldForceException(sourceFolder.provider(), 12)) {
                        i = 101;
                        throw new WvcmException("Abort", WvcmException.ReasonCode.ABORTED);
                    }
                    newName = f.format(CONCAT_NAME, new Object[]{bindingName, String.valueOf(++i)});
                } while (reservedNames != null && reservedNames.contains(newName));
                WorkspaceProvider p = sourceFolder.workspaceProvider();
                Location newChildLoc = sourceFolder.location().child(bindingName);
                ControllableResource newChild = p.controllableResource(newChildLoc);
                newChild = (ControllableResource)newChild.doReadProperties(f.nest(PR_PATH));
                InteropUtilities.rebindFixup(sourceFolder, newName, newChild, rootPaths, f.nest(100));
                return newName;
            }
            catch (WvcmException e) {
                if (i <= 100) continue;
                throw e;
            }
            break;
        }
    }

    public static Workspace createWorkspace(String name, boolean isIsolated, Stream stream, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Workspace ws = p.workspace(p.rootLocation().child(name));
        if (isIsolated) {
            ws.setIsolatedTarget(stream);
        } else {
            ws.setTarget(stream);
        }
        ws = ws.doCreateGeneratedResource(feedback);
        return ws;
    }

    public static Stream createStream(String name, WorkspaceProvider p, Stream target, Feedback feedback) throws WvcmException {
        Stream stream = p.stream(p.rootLocation().child(name));
        if (target != null) {
            stream.setTarget(target);
        }
        return (Stream)stream.doCreateGeneratedResource(feedback);
    }

    public static void updateStreamWithWorkspace(Stream stream, Workspace ws, Feedback f) throws WvcmException {
        Feedback fb = DetailedFeedback.fb((Feedback)f);
        stream.doUpdate(InteropUtilities.makeList(ws), fb.nest(100));
    }

    public static boolean getIgnoreTaskCreationFailure(Provider p) {
        return TRUE_STRING.equals(p.initArgs().get(IA_IGNORE_TASK_CREATION_FAILURE));
    }

    public static Task tryCreateTask(String taskName, Workspace tgtWs, Feedback f) throws WvcmException {
        WorkspaceProvider p = tgtWs.workspaceProvider();
        try {
            InteropUtilities.forceAbortWvcmException((Provider)p, 1, f);
            Task task = p.task(tgtWs.location().child(Messages.InteropStream_ID_SYNCHRONIZE_TASK));
            task.setDisplayName(taskName);
            task = task.doCreateGeneratedResource(f);
            return task;
        }
        catch (WvcmException e) {
            if (!InteropUtilities.getIgnoreTaskCreationFailure((Provider)p)) {
                throw e;
            }
            f.notifyWarning(f.format(Messages.InteropStream_WARNING_COULD_NOT_CREATE_TASK, new Object[]{taskName, e.getMessage()}));
            return null;
        }
    }

    public static void trySetActivityTaskList(Activity tgtAct, ResourceList<Task> tgtTasks, Workspace tgtWs, Feedback f) throws WvcmException {
        try {
            InteropUtilities.forceAbortWvcmException(tgtAct.provider(), 5, f);
            tgtAct.setTaskList(tgtTasks);
            tgtAct.setOriginWorkspace(tgtWs);
            tgtAct.doWriteProperties(f.nest(100));
        }
        catch (WvcmException wvcmException) {
            f.notifyWarning(f.format(Messages.InteropStream_WARNING_COULD_NOT_UPDATE_TASK_LIST, new Object[]{tgtAct.location()}));
        }
    }

    public static void trySetTaskComment(Task task, String comment, Feedback f) throws WvcmException {
        Provider tgtP = task.provider();
        try {
            InteropUtilities.forceAbortWvcmException(tgtP, 4, f);
            task.setComment(comment);
            task.doWriteProperties(f.nest(75));
        }
        catch (WvcmException e) {
            if (!InteropUtilities.getIgnoreTaskCreationFailure(tgtP)) {
                throw e;
            }
            f.notifyWarning(f.format(Messages.InteropStream_WARNING_COULD_NOT_UPDATE_COMMENT, new Object[]{task.location()}));
        }
    }

    public static Version doFindVersionInWorkspace(Workspace workspace, VersionHistory vh, Feedback f) throws WvcmException {
        Version vQuery = InteropUtilities.computeFindVersionInWorkspaceQuery(workspace, vh);
        return (Version)vQuery.doFind(f);
    }

    public static Version doFindOneVersionInWorkspace(Workspace workspace, VersionHistory vh, Feedback f) throws WvcmException {
        Version vQuery = InteropUtilities.computeFindVersionInWorkspaceQuery(workspace, vh);
        return (Version)vQuery.doFindOne(f);
    }

    public static Version computeFindVersionInWorkspaceQuery(Workspace workspace, VersionHistory vh) {
        WorkspaceProvider p = workspace.workspaceProvider();
        Version vQuery = p.version(p.rootLocation());
        VersionHistory vhQuery = p.versionHistory(p.rootLocation());
        vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
        Workspace wsQuery = p.workspace(p.rootLocation());
        wsQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
        ResourceList wsQueryList = p.resourceList((Resource[])new Workspace[0]);
        wsQueryList.add((Object)wsQuery);
        vQuery.setProperty(Version.VERSION_HISTORY, (Object)vhQuery);
        vQuery.setProperty(Version.IN_WORKSPACE_LIST, (Object)wsQueryList);
        return vQuery;
    }

    public static ControllableResource doFindCRInWorkspace(Workspace workspace, VersionHistory vh, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        ControllableResource crQuery = p.controllableResource(p.rootLocation());
        VersionHistory vhQuery = p.versionHistory(p.rootLocation());
        vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
        Workspace workspaceQuery = p.workspace(p.rootLocation());
        workspaceQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
        crQuery.setProperty(ControllableResource.VERSION_HISTORY, (Object)vhQuery);
        crQuery.setProperty(ControllableResource.WORKSPACE, (Object)workspaceQuery);
        return (ControllableResource)crQuery.doFind(feedback);
    }

    public static Map<VersionHistory, ControllableResource> doFindCRsInWorkspace(Workspace workspace, Collection<VersionHistory> tgtVhs, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        ResourceList queries = p.resourceList((Resource[])new ControllableResource[0]);
        for (VersionHistory vh : tgtVhs) {
            ControllableResource crQuery = p.controllableResource(p.rootLocation());
            VersionHistory vhQuery = p.versionHistory(p.rootLocation());
            vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
            Workspace workspaceQuery = p.workspace(p.rootLocation());
            workspaceQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
            crQuery.setProperty(ControllableResource.VERSION_HISTORY, (Object)vhQuery);
            crQuery.setProperty(ControllableResource.WORKSPACE, (Object)workspaceQuery);
            queries.add((Object)crQuery);
        }
        HashMap<VersionHistory, ControllableResource> results = new HashMap<VersionHistory, ControllableResource>(tgtVhs.size());
        ResourceList.ResponseIterator findings = queries.doFind(feedback);
        for (VersionHistory vh : tgtVhs) {
            Object result = findings.next();
            if (result instanceof WvcmException) {
                throw (WvcmException)((Object)result);
            }
            results.put(vh, (ControllableResource)result);
        }
        return results;
    }

    public static Component doFindComponent(WorkspaceProvider p, String componentName, Feedback f) throws WvcmException {
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.DISPLAY_NAME, (Object)componentName);
        return (Component)compQuery.doFind(f);
    }

    public static Configuration doFindConfigurationInWorkspace(Workspace workspace, Component comp, Feedback f) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        Configuration configQuery = p.configuration(p.rootLocation());
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)comp.location());
        Workspace workspaceQuery = p.workspace(p.rootLocation());
        workspaceQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)workspace.location());
        configQuery.setProperty(Configuration.VERSION_HISTORY, (Object)compQuery);
        configQuery.setProperty(Configuration.WORKSPACE, (Object)workspaceQuery);
        return (Configuration)configQuery.doFind(f);
    }

    public static List<Baseline> doFindAllBaselinesInStreamInComponent(Stream stream, Component comp, Feedback f) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Baseline baselinesQuery = p.baseline(p.rootLocation());
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)comp.location());
        baselinesQuery.setProperty(Baseline.VERSION_HISTORY, (Object)compQuery);
        Stream streamQuery = p.stream(p.rootLocation());
        streamQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)stream.location());
        baselinesQuery.setProperty(Baseline.ACTIVITY, (Object)streamQuery);
        ResourceList.ResponseIterator baselines = baselinesQuery.doFindAll(f);
        ArrayList<Baseline> result = new ArrayList<Baseline>();
        while (baselines.hasNext()) {
            result.add((Baseline)baselines.next());
        }
        return result;
    }

    public static List<Baseline> doFindAllCompositeBaselinesInStream(Stream stream, Feedback f) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Baseline baselinesQuery = p.baseline(p.rootLocation());
        Stream streamQuery = p.stream(p.rootLocation());
        streamQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)stream.location());
        baselinesQuery.setProperty(Baseline.ACTIVITY, (Object)streamQuery);
        ResourceList.ResponseIterator baselines = baselinesQuery.doFindAll(f);
        ArrayList<Baseline> results = new ArrayList<Baseline>();
        while (baselines.hasNext()) {
            results.add((Baseline)baselines.next());
        }
        return results;
    }

    public static Baseline doFindNamedBaselineInStream(String name, Stream stream, Feedback f) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Baseline baselinesQuery = p.baseline(p.rootLocation());
        baselinesQuery.setDisplayName(name);
        Stream streamQuery = p.stream(p.rootLocation());
        streamQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)stream.location());
        baselinesQuery.setProperty(Baseline.ACTIVITY, (Object)streamQuery);
        Resource response = baselinesQuery.doFind(f);
        Baseline result = response instanceof Baseline ? (Baseline)response : null;
        return result;
    }

    public static Baseline doFindNamedBaseline(WorkspaceProvider p, String name, Feedback f) throws WvcmException {
        List<Baseline> results = InteropUtilities.doFindNamedBaselines(p, name, f);
        return results != null && results.size() > 0 ? results.get(0) : null;
    }

    public static List<Baseline> doFindNamedBaselines(WorkspaceProvider p, String name, Feedback f) throws WvcmException {
        ArrayList<Baseline> results = new ArrayList<Baseline>();
        Baseline baselinesQuery = p.baseline(p.rootLocation());
        baselinesQuery.setDisplayName(name);
        ResourceList.ResponseIterator responses = baselinesQuery.doFindAll(f);
        while (responses.hasNext()) {
            Resource response = (Resource)responses.next();
            if (!(response instanceof Baseline)) continue;
            results.add((Baseline)response);
        }
        return results;
    }

    public static List<Baseline> doFindNamedBaselinesInComponent(WorkspaceProvider p, String name, Component comp, Feedback f) throws WvcmException {
        ArrayList<Baseline> results = new ArrayList<Baseline>();
        Baseline baselinesQuery = p.baseline(p.rootLocation());
        baselinesQuery.setDisplayName(name);
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)comp.location());
        baselinesQuery.setProperty(Baseline.VERSION_HISTORY, (Object)compQuery);
        ResourceList.ResponseIterator responses = baselinesQuery.doFindAll(f);
        while (responses.hasNext()) {
            Resource response = (Resource)responses.next();
            if (!(response instanceof Baseline)) continue;
            results.add((Baseline)response);
        }
        return results;
    }

    public static void closePipedInputStream(Provider p, PipedInputStream pins) throws WvcmException {
        try {
            if (InteropUtilities.shouldForceException(p, 10)) {
                throw new IOException("Abort");
            }
            pins.close();
        }
        catch (IOException e) {
            throw new WvcmException("Could not close pipe", WvcmException.ReasonCode.WRITE_FAILED, (Throwable)e);
        }
    }

    public static PipedOutputStream createPipedOutputStream(Provider p, PipedInputStream pins) throws WvcmException {
        PipedOutputStream pouts;
        try {
            if (InteropUtilities.shouldForceException(p, 9)) {
                throw new IOException("Abort");
            }
            pouts = new PipedOutputStream(pins);
        }
        catch (IOException e) {
            throw new WvcmException("Could not open pipe", WvcmException.ReasonCode.WRITE_FAILED, (Throwable)e);
        }
        return pouts;
    }

    private static boolean useHashAllowed(Resource resource1, Resource resource2) throws WvcmException {
        String value1 = (String)resource1.provider().initArgs().get(IA_DISABLE_HASHING_FOR_CONTENT_COMPARE);
        String value2 = (String)resource2.provider().initArgs().get(IA_DISABLE_HASHING_FOR_CONTENT_COMPARE);
        return !TRUE_STRING.equals(value1) && !TRUE_STRING.equals(value2);
    }

    public static boolean isContentEqual(Resource resource1, Resource resource2, Feedback f) throws WvcmException {
        if (InteropUtilities.useHashAllowed(resource1, resource2)) {
            resource1 = resource1.doReadProperties(f.nest(PR_SHA_256, 10));
            resource2 = resource2.doReadProperties(f.nest(PR_SHA_256, 20));
            Object[] hash1 = InteropUtilities.tryGetProperty(resource1, PN_SHA_256);
            Object[] hash2 = InteropUtilities.tryGetProperty(resource2, PN_SHA_256);
            if (hash1 != null && hash2 != null) {
                boolean result = Arrays.equals(hash1, hash2);
                if (result) {
                    f.notifyCompleted(Messages.InteropStream_MSG_DUPLICATE_CONTENT_HASH_MATCH);
                }
                return result;
            }
        }
        Feedback nowork = f.nest();
        Provider p = resource1.provider();
        PipedInputStream pins1 = new PipedInputStream();
        PipedOutputStream pouts1 = InteropUtilities.createPipedOutputStream(p, pins1);
        ChildException childEx1 = new ChildException();
        ContentReader reader1 = new ContentReader(resource1, pouts1, null, childEx1, nowork);
        PipedInputStream pins2 = new PipedInputStream();
        PipedOutputStream pouts2 = InteropUtilities.createPipedOutputStream(p, pins2);
        ChildException childEx2 = new ChildException();
        ContentReader reader2 = new ContentReader(resource2, pouts2, null, childEx2, nowork);
        boolean interrupted = false;
        try {
            int count1;
            do {
                int count2;
                if ((count1 = pins1.read()) == (count2 = pins2.read())) continue;
                interrupted = true;
                reader1.interrupt();
                reader2.interrupt();
                return false;
            } while (count1 >= 0);
            f.notifyCompleted(Messages.InteropStream_MSG_DUPLICATE_CONTENT);
            return true;
        }
        catch (IOException e) {
            throw new WvcmException(Messages.InteropStream_ERROR_CANNOT_COMPARE_CONTENT, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
        }
        finally {
            InteropUtilities.closePipedInputStream(p, pins1);
            InteropUtilities.closePipedInputStream(p, pins2);
            Throwable e = null;
            Resource r = null;
            if (childEx1.ex != null) {
                e = childEx1.ex;
                r = resource1;
            } else if (childEx2.ex != null) {
                e = childEx2.ex;
                r = resource2;
            }
            if (e != null && !interrupted) {
                if (e instanceof WvcmException) {
                    throw (WvcmException)e;
                }
                throw new WvcmException(Messages.InteropStream_ERROR_CONTENT_READER_DIED, r, WvcmException.ReasonCode.CONFLICT, e);
            }
        }
    }

    public static boolean isTextContentType(String contentType) {
        String type = contentType.trim().toLowerCase();
        return type.startsWith("text") || type.endsWith("html") || type.endsWith("xml");
    }

    public static void setBinaryContentProperties(ControllableResource cr) {
        cr.setProperty(Resource.CONTENT_TYPE, (Object)"application/unknown");
        cr.setContentCharacterSet(null);
        cr.setProperty(PN_LINE_SEPARATOR, (Object)LineSeparator.UNSPECIFIED.name());
    }

    public static String concatenateComments(Set<String> comments, Feedback f) {
        String result = EMPTY_STRING;
        if (comments == null) {
            return result;
        }
        for (String comment : comments) {
            if (comment == null || comment.length() <= 0) continue;
            if (result == EMPTY_STRING) {
                result = Messages.InteropStream_MSG_CHECKIN_COMMENTS;
            }
            result = f.format(CONCAT_MSG, new Object[]{result, comment});
        }
        return result;
    }

    public static void addComment(Resource resource, Set<String> comments) {
        Object commentVal;
        if (comments != null && (commentVal = resource.lookupProperty(Version.COMMENT)) instanceof String) {
            comments.add((String)commentVal);
        }
    }

    public static void printver(String title, Version v, int level) {
        if (level > debugLevel) {
            return;
        }
        try {
            System.out.print("\n" + title + ": " + v.location() + "\n");
            if (v instanceof FolderVersion) {
                FolderVersion fv = (FolderVersion)v;
                System.out.print("CHILD NAMES: ");
                Iterator children = fv.getChildMap().keySet().iterator();
                while (children.hasNext()) {
                    System.out.print(" " + (String)children.next());
                }
                System.out.print("\n");
            } else {
                ByteArrayOutputStream thisBAOS = new ByteArrayOutputStream();
                v.doReadContent((OutputStream)thisBAOS, null, null);
                System.out.print("CONTENT:" + thisBAOS.toString() + "\n");
            }
        }
        catch (WvcmException wvcmException) {
            System.out.print("printver failed\n");
        }
    }

    public static void printbl(String title, Baseline bl, int level) {
        if (level > debugLevel) {
            return;
        }
        try {
            System.out.print("\n" + title + ": " + InteropUtilities.doReadProperty((Resource)bl, Resource.PATHNAME_LOCATION, null) + "\n");
            WorkspaceProvider p = bl.workspaceProvider();
            Workspace ws = p.workspace(p.rootLocation().child("printbl"));
            ws = ws.doCreateGeneratedResource(null);
            ControllableFolder cf = p.controllableFolder(ws.location().child("COMP"));
            try {
                cf.doCreateBaselineControlledFolder(bl, null);
            }
            catch (WvcmException wvcmException) {
                ws.doUpdate(InteropUtilities.makeList(bl), null);
            }
            InteropUtilities.printcr_int((ControllableResource)ws, 1);
        }
        catch (WvcmException e) {
            e.printStackTrace();
        }
    }

    public static void printvh(String title, VersionHistory vh, int level) {
        if (level > debugLevel) {
            return;
        }
        System.out.print(String.valueOf(title) + ": " + vh.location() + "\n");
    }

    public static void printstream(String title, Stream stream, int level) {
        if (level > debugLevel) {
            return;
        }
        try {
            System.out.print("\n" + title + ": " + InteropUtilities.doReadProperty((Resource)stream, Resource.PATHNAME_LOCATION, null) + "\n");
            Workspace ws = InteropUtilities.createWorkspace("print", false, stream, null);
            ws.doMerge(InteropUtilities.makeList(stream), null, null);
            InteropUtilities.printcr_int((ControllableResource)ws, 1);
        }
        catch (WvcmException wvcmException) {
            System.out.print("printstream failed\n");
        }
    }

    public static void printcr(String title, ControllableResource cr, int level) {
        InteropUtilities.printCRs(title, level, cr);
    }

    public static void printCRs(String title, int level, ControllableResource ... crs) {
        InteropUtilities.printCRs(title, level, Arrays.asList(crs));
    }

    public static void printCRs(String title, int level, List<ControllableResource> crs) {
        if (level > debugLevel) {
            return;
        }
        try {
            System.out.print("\n" + title + ": ");
            for (ControllableResource cr : crs) {
                System.out.println(InteropUtilities.doReadProperty((Resource)cr, Resource.PATHNAME_LOCATION, null));
                InteropUtilities.printcr_int(cr, 1);
                System.out.println();
            }
        }
        catch (WvcmException e) {
            System.out.print("printcr failed\n");
            e.printStackTrace();
        }
    }

    public static void printcr_int(ControllableResource cr, int depth) {
        try {
            if (cr instanceof ControllableSymbolicLink) {
                String target = (String)InteropUtilities.doReadProperty((Resource)cr, ControllableSymbolicLink.LINK_TARGET, null);
                int i = 0;
                while (i < depth) {
                    System.out.print("   ");
                    ++i;
                }
                System.out.print("SYMBOLIC LINK:" + target.toString() + "\n");
            } else if (cr instanceof ControllableFolder) {
                ControllableFolder thisCF = (ControllableFolder)cr.doReadProperties((Feedback)PR_CHILDMAP_CONFIG);
                Configuration c = thisCF.getRootFolderOf();
                if (c != null) {
                    int i = 0;
                    while (i < depth - 1) {
                        System.out.print("   ");
                        ++i;
                    }
                    Object isCheckedOutValue = c.lookupProperty(Configuration.IS_CHECKED_OUT);
                    if (!(isCheckedOutValue instanceof WvcmException) && c.getIsCheckedOut()) {
                        System.out.print(" BL <checked-out>");
                    } else {
                        Version bl = c.getCheckedIn();
                        System.out.print(" BL:" + bl.getVersionName() + "\n");
                    }
                }
                Map thisChildMap = thisCF.getChildMap();
                for (String bn : thisChildMap.keySet()) {
                    int i = 0;
                    while (i < depth) {
                        System.out.print("   ");
                        ++i;
                    }
                    System.out.print(bn);
                    System.out.println();
                    ControllableResource thisChild = (ControllableResource)thisChildMap.get(bn);
                    InteropUtilities.printcr_int(thisChild, depth + 1);
                }
            } else {
                ByteArrayOutputStream thisBAOS = new ByteArrayOutputStream();
                cr.doReadContent((OutputStream)thisBAOS, null, null);
                int i = 0;
                while (i < depth) {
                    System.out.print("   ");
                    ++i;
                }
                System.out.print("CONTENT:" + thisBAOS.toString() + "\n");
            }
        }
        catch (WvcmException e) {
            System.out.print("printcr failed");
            e.printStackTrace();
        }
    }

    public static void printhistory(String title, ControllableResource cr, int level) {
        if (level > debugLevel) {
            return;
        }
        try {
            System.out.print("\n" + title + ": " + InteropUtilities.doReadProperty((Resource)cr, Resource.PATHNAME_LOCATION, null) + "\n");
            VersionHistory vh = (VersionHistory)InteropUtilities.doReadProperty((Resource)cr, ControllableResource.VERSION_HISTORY, null);
            Version root = (Version)InteropUtilities.doReadProperty((Resource)vh, VersionHistory.ROOT_VERSION, null);
            InteropUtilities.printhistory_int(root, 1);
        }
        catch (WvcmException e) {
            System.out.print("printhistory failed\n");
            e.printStackTrace();
        }
    }

    public static void printhistory_int(Version version, int depth) {
        try {
            int i = 0;
            while (i < depth) {
                System.out.print("   ");
                ++i;
            }
            System.out.println(version.location().string());
            List succs = (List)InteropUtilities.doReadProperty((Resource)version, Version.SUCCESSOR_LIST, null);
            for (Version s : succs) {
                InteropUtilities.printhistory_int(s, depth + 1);
            }
        }
        catch (WvcmException e) {
            System.out.print("print history failed");
            e.printStackTrace();
        }
    }

    public static Baseline makeBaseline(Configuration config, String name, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        config = (Configuration)config.doCheckout(null, f.nest(PR_SUB_CONFIGS, 30));
        config.setDisplayName(name);
        config = (Configuration)config.doCheckin(null, f.nest(PR_CI_DN, 60));
        Baseline result = (Baseline)config.getCheckedIn().doReadProperties(f);
        return result;
    }

    public static Baseline makeCompositeBaseline(Configuration config, ResourceList<Configuration> subConfigs, String name, Feedback fb) throws WvcmException {
        config.setSubConfigurationList(subConfigs);
        return InteropUtilities.makeBaseline(config, name, fb);
    }

    public static Baseline makeCompositeBaseline(Workspace ws, String name, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Configuration wsConfig = (ws = (Workspace)ws.doReadProperties(f.nest(PR_WS_CONFIGS, 10))).getConfiguration();
        if (wsConfig == null) {
            throw new IllegalStateException("workspace should have a configuration");
        }
        String wsRi = ws.getResourceIdentifier();
        ResourceList subConfigs = ws.provider().resourceList((Resource[])new Configuration[0]);
        ResourceList bcfs = ws.getBaselineControlledFolderList();
        for (ControllableFolder bcf : bcfs) {
            if (wsRi == bcf.getResourceIdentifier()) continue;
            subConfigs.add((Object)bcf.getConfiguration());
        }
        Baseline result = InteropUtilities.makeCompositeBaseline(wsConfig, (ResourceList<Configuration>)subConfigs, name, f);
        return result;
    }

    public static <T extends Version> T lookupNextVersionInList(T v, List<T> versions) throws WvcmException {
        if (v.lookupProperty(Version.SUCCESSOR_LIST) instanceof WvcmException) {
            int i = versions.indexOf(v) + 1;
            if (i == versions.size()) {
                return null;
            }
            return (T)((Version)versions.get(i));
        }
        for (Version nextBL : v.getSuccessorList()) {
            int i = versions.indexOf(nextBL);
            if (i < 0) continue;
            return (T)((Version)versions.get(i));
        }
        return null;
    }

    public static <T extends Version> List<T> orderVersions(List<T> versions) throws WvcmException {
        if (versions.isEmpty() || ((Version)versions.get(0)).lookupProperty(Baseline.SUCCESSOR_LIST) instanceof WvcmException) {
            return versions;
        }
        LinkedList<Version> orderedVersions = new LinkedList<Version>();
        ArrayList<T> sources = new ArrayList<T>(versions);
        block0: while (!sources.isEmpty()) {
            int i = 0;
            while (i < sources.size()) {
                Version bl = (Version)sources.get(i);
                Version next = InteropUtilities.lookupNextVersionInList(bl, versions);
                if (next == null) {
                    orderedVersions.addLast(bl);
                    sources.remove(i);
                    continue block0;
                }
                int loc = orderedVersions.indexOf(next);
                if (loc >= 0) {
                    orderedVersions.add(loc, bl);
                    sources.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        return orderedVersions;
    }

    public static InteropStream createInteropStream(Provider thatProvider, Provider thisProvider) {
        InteropStreamSegment sourceSeg = new InteropStreamSegment(thatProvider.getClass().getName(), thatProvider.initArgs(), thatProvider.callback());
        InteropStreamSegment destSeg = new InteropStreamSegment(thisProvider.getClass().getName(), thisProvider.initArgs(), thisProvider.callback());
        return new InteropStream(destSeg, sourceSeg);
    }

    public static String join(char sep, String ... strings) {
        int n = strings.length;
        if (n == 0) {
            return new String();
        }
        int i = 0;
        StringBuffer result = new StringBuffer(strings[i++]);
        while (i < n) {
            result.append(sep).append(strings[i++]);
        }
        return result.toString();
    }

    public static class ChildException {
        public volatile Throwable ex = null;
    }

    public static class ContentReader
    extends Thread {
        private PipedOutputStream _pouts;
        private Resource _resource;
        private Resource _accept;
        private Feedback _feedback;
        private ChildException _childException;

        public ContentReader(Resource resource, PipedOutputStream pouts, Resource accept, ChildException childException, Feedback f) {
            this._resource = resource;
            this._accept = accept;
            this._pouts = pouts;
            this._childException = childException;
            this._feedback = f;
            this.start();
        }

        @Override
        public void run() {
            try {
                try {
                    InteropUtilities.forceAbortWvcmException(this._resource.provider(), 7, this._feedback);
                    this._resource.doReadContent((OutputStream)this._pouts, this._accept, this._feedback);
                }
                catch (Exception e) {
                    this._childException.ex = e;
                    try {
                        InteropUtilities.shouldForceException(this._resource.provider(), 8);
                        this._pouts.close();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException("Could not close output stream", e2);
                    }
                }
            }
            finally {
                try {
                    InteropUtilities.shouldForceException(this._resource.provider(), 8);
                    this._pouts.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close output stream", e);
                }
            }
        }
    }

    public static enum LineSeparator {
        UNSPECIFIED,
        LF,
        CR,
        CRLF,
        PLATFORM;

    }
}

