/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.internal.ClientComponentInfo;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.dto.ComponentInfo;
import com.ibm.team.scm.common.internal.dto.ItemConflictReport;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientCurrentComponentInfo
extends ClientComponentInfo
implements ICurrentComponentInfo {
    private final long numBasesInHistory;
    private final ISyncTime configurationTime;
    private final ISyncTime changeHistoryTime;
    private final IComponentHandle component;
    private final ChangeHistoryHandle changeHistory;
    private final Map<UUID, ConflictInfo> conflicts;
    private final ISyncTime lockTime;
    private final long numPendingPorts;
    private ISyncTime pendingPortsTime;
    private ISyncTime currentPortTime;

    public ClientCurrentComponentInfo(ComponentInfo entry) {
        this(entry.getDeliveredBy(), entry.getDeliveryDate(), entry.getBasis(), entry.getIndex() + 1L, (ISyncTime)new SyncTime(entry.getConfigurationState()), (ISyncTime)new SyncTime(entry.getChangeHistoryState()), entry.getComponent(), entry.getChangehistory(), entry.getConflicts(), (ISyncTime)new SyncTime(entry.getLockState()), entry.getAcceptQueueSize(), entry.getPendingPortsListTime(), entry.getCurrentPortTime());
    }

    private ClientCurrentComponentInfo(IContributorHandle deliveredBy, Date deliveryDate, IBaselineHandle basis, long numBasesInHistory, ISyncTime configurationTime, ISyncTime changeHistoryTime, IComponentHandle component, ChangeHistoryHandle changeHistory, List<IItemConflictReport> conflicts, ISyncTime lockTime, long numPendingPorts, ISyncTime pendingPortsListTime, ISyncTime currentPortTime) {
        super(deliveredBy, deliveryDate, basis);
        this.numBasesInHistory = numBasesInHistory;
        this.configurationTime = configurationTime;
        this.changeHistoryTime = changeHistoryTime;
        this.lockTime = lockTime;
        this.component = component;
        this.changeHistory = changeHistory;
        this.numPendingPorts = numPendingPorts;
        this.pendingPortsTime = pendingPortsListTime;
        this.currentPortTime = currentPortTime;
        this.conflicts = new HashMap<UUID, ConflictInfo>((int)((double)conflicts.size() / 0.75));
        for (IItemConflictReport conflict : conflicts) {
            ConflictInfo info = new ConflictInfo((ItemConflictReport)conflict);
            this.conflicts.put(info.itemId, info);
        }
    }

    public long numBasisInHistory() {
        return this.numBasesInHistory;
    }

    public ISyncTime configurationTime() {
        return this.configurationTime;
    }

    public ISyncTime changeHistoryTime() {
        return this.changeHistoryTime;
    }

    public ChangeHistoryHandle getChangeHistory() {
        return this.changeHistory;
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public Map<UUID, ConflictInfo> getConflicts() {
        return this.conflicts;
    }

    public ISyncTime lockTime() {
        return this.lockTime;
    }

    public ISyncTime pendingPortsTime() {
        return this.pendingPortsTime;
    }

    public ISyncTime currentPortTime() {
        return this.currentPortTime;
    }

    public long numPendingPorts() {
        return this.numPendingPorts;
    }

    protected class ConflictInfo {
        private final UUID itemId;
        private final UUID selected;
        private final UUID proposed;
        private final UUID ancestor;
        private final UUID original;
        private final UUID previous;
        private final IItemType itemType;
        private final Set<String> details;

        public ConflictInfo(ItemConflictReport conflict) {
            this.itemId = conflict.item().getItemId();
            this.itemType = conflict.item().getItemType();
            this.selected = conflict.getSelectedContributorStateId();
            this.proposed = conflict.getProposedContributorStateId();
            this.ancestor = conflict.getCommonAncestorStateId();
            this.original = conflict.getOriginalSelectedContributorStateId();
            this.previous = conflict.getPreviousStateId();
            this.details = new HashSet<String>(conflict.getMergeDetails());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConflictInfo)) {
                return false;
            }
            ConflictInfo info = (ConflictInfo)o;
            if (!this.itemId.equals((Object)info.itemId)) {
                return false;
            }
            if (!this.itemType.equals(info.itemType)) {
                return false;
            }
            if (!this.stateEquals(this.selected, info.selected)) {
                return false;
            }
            if (!this.stateEquals(this.proposed, info.proposed)) {
                return false;
            }
            if (!this.stateEquals(this.ancestor, info.ancestor)) {
                return false;
            }
            if (!this.stateEquals(this.original, info.original)) {
                return false;
            }
            if (!this.stateEquals(this.previous, info.previous)) {
                return false;
            }
            return this.details.equals(info.details);
        }

        private boolean stateEquals(UUID mine, UUID theirs) {
            if (mine == null && theirs == null) {
                return true;
            }
            if (mine == null) {
                return false;
            }
            return mine.equals((Object)theirs);
        }

        public int hashCode() {
            return this.itemId.hashCode() + this.getHash(this.selected) + this.getHash(this.proposed) + this.getHash(this.ancestor) + this.getHash(this.original) + this.getHash(this.details);
        }

        private int getHash(Set<String> s) {
            if (s == null) {
                return 144;
            }
            int sum = 0;
            for (String ss : s) {
                if (ss == null) continue;
                sum += ss.hashCode();
            }
            return sum;
        }

        private int getHash(UUID id) {
            if (id == null) {
                return 6;
            }
            return id.hashCode();
        }

        public ItemConflictReport toItemConflictReport() {
            ItemConflictReport report = ScmDtoFactory.eINSTANCE.createItemConflictReport();
            report.setCommonAncestorStateId(this.ancestor);
            report.setComponent(ClientCurrentComponentInfo.this.component);
            report.setItem((IVersionableHandle)this.itemType.createItemHandle(this.itemId, null));
            report.setOriginalSelectedContributorStateId(this.original);
            report.setPreviousStateId(this.previous);
            report.setProposedContributorStateId(this.proposed);
            report.setSelectedContributorStateId(this.selected);
            report.getMergeDetails().addAll(this.details);
            return report;
        }
    }
}

