/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.ILinkDetectorContextProvider;
import com.ibm.team.foundation.common.LinkDetector;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TextLinkDetector {
    private URI fBaseURI;
    private LinkDetector.ILinkDetectorListener fListener;
    private ILinkDetectorContextProvider fContext = new ILinkDetectorContextProvider(){

        @Override
        public URI getBaseURI() {
            return TextLinkDetector.this.fBaseURI;
        }
    };

    public abstract DetectedTextLink createDetectedLink(Matcher var1);

    protected abstract Pattern getPattern();

    public void initialize() {
    }

    public void cleanup() {
    }

    public void setListener(LinkDetector.ILinkDetectorListener listener) {
        this.fListener = listener;
    }

    public void linkDetectorChanged() {
        if (this.fListener != null) {
            this.fListener.linkDetectorChanged();
        }
    }

    public void setBaseURI(URI baseURI) {
        this.fBaseURI = baseURI;
    }

    public URI getBaseURI() {
        return this.fContext.getBaseURI();
    }

    public void setContext(ILinkDetectorContextProvider context) {
        assert (context != null);
        this.fContext = context;
    }

    public ILinkDetectorContextProvider getContext() {
        return this.fContext;
    }
}

