/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.util;

import com.ibm.team.foundation.common.internal.util.FoundationLogUtil;
import com.ibm.team.foundation.common.internal.util.FoundationStatus;
import com.ibm.team.foundation.common.internal.util.Messages;
import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import com.ibm.team.repository.common.LogFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FoundationLog {
    private static Map<String, FoundationLog> fgLogs = new HashMap<String, FoundationLog>();
    private String fId;

    public static FoundationLog getLog(Class<?> clazz) {
        return FoundationLog.getLog(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FoundationLog getLog(String id) {
        Map<String, FoundationLog> map = fgLogs;
        synchronized (map) {
            FoundationLog log;
            if (id == null) {
                id = "unknown";
            }
            if ((log = fgLogs.get(id)) == null) {
                log = new FoundationLog(id);
                fgLogs.put(id, log);
            }
            return log;
        }
    }

    public static void log(IStatus status) {
        if (FoundationLog.isExpected(status)) {
            return;
        }
        ILog compatibilityLog = FoundationLogUtil.getCompatibilityLog();
        if (compatibilityLog != null) {
            compatibilityLog.log(status);
        } else {
            FoundationLog.internalLog(status);
        }
    }

    public static void logUnexpected(IStatus status) {
        ILog compatibilityLog = FoundationLogUtil.getCompatibilityLog();
        if (compatibilityLog != null) {
            compatibilityLog.log(status);
        } else {
            FoundationLog.internalLog(status);
        }
    }

    private static void internalLog(IStatus status) {
        if (status == null) {
            FoundationLog log = FoundationLog.getLog("com.ibm.team.foundation.common");
            log.error(Messages.getString("FoundationLog.ERROR_NULL_STATUS"), new NullPointerException());
            return;
        }
        FoundationLog log = FoundationLog.getLog(status.getPlugin());
        if (status.getSeverity() == 4) {
            log.unexpectedError(status.getMessage(), status.getException());
        } else {
            log.unexpectedWarn(status.getMessage(), status.getException());
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            FoundationLog.internalLog(child);
            ++n2;
        }
    }

    public static boolean isExpected(IStatus status) {
        if (!FoundationLog.internalIsExpected(status)) {
            return false;
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (!FoundationLog.isExpected(child)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean internalIsExpected(IStatus status) {
        if (status == null) {
            return false;
        }
        if (status instanceof FoundationStatus) {
            return ((FoundationStatus)status).isExpected();
        }
        int severity = status.getSeverity();
        if (severity != 4 && severity != 2) {
            return true;
        }
        Throwable x = status.getException();
        if (x == null) {
            return status.getChildren().length > 0;
        }
        return TeamFoundationException.isExpected(x);
    }

    private FoundationLog(String id) {
        this.fId = id;
    }

    public void error(String message, Throwable x) {
        if (x == null || !TeamFoundationException.isExpected(x)) {
            this.unexpectedError(message, x);
        }
    }

    public void unexpectedError(String message, Throwable x) {
        ILog compatibilityLog = FoundationLogUtil.getCompatibilityLog();
        if (compatibilityLog != null) {
            compatibilityLog.log((IStatus)new Status(4, this.fId, message, x));
        } else {
            Log log = LogFactory.getLog((String)this.fId);
            log.error((Object)message, x);
        }
    }

    public void warn(String message, Throwable x) {
        if (x == null || !TeamFoundationException.isExpected(x)) {
            this.unexpectedWarn(message, x);
        }
    }

    public void unexpectedWarn(String message, Throwable x) {
        ILog compatibilityLog = FoundationLogUtil.getCompatibilityLog();
        if (compatibilityLog != null) {
            compatibilityLog.log((IStatus)new Status(2, this.fId, message, x));
        } else {
            Log log = LogFactory.getLog((String)this.fId);
            log.warn((Object)message, x);
        }
    }
}

