/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class BaseCcComponentInfo {
    final CCaseObjInfo compObjInfo_Optional;
    final String vobTag;
    final String vobUuid;
    final String crdvmsUsel;
    final String relativePath_Optional;

    public BaseCcComponentInfo(CCaseObjInfo compObjInfo, String vobTag, String vobUuid, String crdeUsel, String relativePath) {
        this.compObjInfo_Optional = compObjInfo;
        this.vobTag = vobTag;
        this.vobUuid = vobUuid;
        this.crdvmsUsel = crdeUsel;
        this.relativePath_Optional = relativePath;
    }

    public static BaseCcComponentInfo valueOf(CCaseObjInfo compObjInfo, SrvcFeedback feedback) throws WvcmException {
        String vobTag;
        String vobUuid;
        CCaseLib cc = compObjInfo.getCCaseLib();
        String mtype = compObjInfo.getMtype();
        String crdvmsUsel = compObjInfo.getUniversalSelector();
        if (mtype.equals("versioned object base")) {
            vobUuid = ObjSelUtils.getObjSelName(crdvmsUsel);
            vobTag = cc.computeVobTagFromVobFamilyUuid(vobUuid, feedback);
        } else if (mtype.equals("directory version")) {
            vobUuid = ObjSelUtils.vobOidSubstring(crdvmsUsel);
            vobTag = cc.computeVobTagFromVobFamilyUuid(vobUuid, feedback);
        } else if (mtype.equals("component")) {
            vobUuid = ObjSelUtils.vobOidSubstring(crdvmsUsel);
            vobTag = cc.computeVobTagFromVobFamilyUuid(vobUuid, feedback);
        } else {
            throw new IllegalStateException("Unexpected mtype for component: " + mtype);
        }
        return new BaseCcComponentInfo(compObjInfo, vobTag, vobUuid, crdvmsUsel, null);
    }

    public String getViewRelativePath(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
        String result = this.relativePath_Optional;
        if (result != null) {
            return result;
        }
        String mtype = this.compObjInfo_Optional.getMtype();
        if (mtype.equals("versioned object base")) {
            result = this.vobTag;
        } else if (mtype.equals("directory version")) {
            Path crdPath = new Path(this.getCRDPathname(view, feedback));
            Path tagPath = new Path(CCaseLib.getPathIntoView(view.getViewTag()));
            IPath relativePath = crdPath.makeRelativeTo((IPath)tagPath).makeAbsolute();
            result = relativePath.toPortableString();
        } else if (mtype.equals("component")) {
            CCaseLib cc = this.compObjInfo_Optional.getCCaseLib();
            result = cc.getComponentRootDir(this.compObjInfo_Optional.getUniversalSelector(), feedback);
        } else {
            throw new IllegalStateException("Unexpected mtype for component: " + mtype);
        }
        return result;
    }

    public String getRelativePath(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
        String result = this.relativePath_Optional;
        if (result != null) {
            return result;
        }
        String mtype = this.compObjInfo_Optional.getMtype();
        if (mtype.equals("versioned object base")) {
            result = new String();
        } else if (mtype.equals("directory version")) {
            Path crdPath = new Path(this.getCRDPathname(view, feedback));
            Path tagPath = new Path(String.valueOf(CCaseLib.getPathIntoView(view.getViewTag())) + this.vobTag);
            IPath relativePath = crdPath.makeRelativeTo((IPath)tagPath);
            result = relativePath.toPortableString();
        } else if (mtype.equals("component")) {
            result = this.compObjInfo_Optional.getPathName();
        } else {
            throw new IllegalStateException("Unexpected mtype for component: " + mtype);
        }
        return result;
    }

    String getCRDPathname(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String mtype = this.compObjInfo_Optional.getMtype();
        CCaseLib cc = this.compObjInfo_Optional.getCCaseLib();
        if (mtype.equals("versioned object base")) {
            result = cc.computeVobTagFromVobFamilyUuid(this.compObjInfo_Optional.getPathName(), feedback);
        } else if (mtype.equals("directory version")) {
            result = this.getBaseCcSubVobCompRootDirPathname(view, feedback);
        } else if (mtype.equals("component")) {
            result = cc.getComponentRootDir(this.compObjInfo_Optional.getUniversalSelector(), feedback);
        } else {
            throw new IllegalStateException("Unexpected mtype for component: " + mtype);
        }
        return result;
    }

    public String lookupBaseCcSubVobCompRootDirPathname(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
        CTVersion rootVersion = CTVersion.valueOf(view.provider(), this.compObjInfo_Optional, view, this.compObjInfo_Optional.getPathName(), feedback);
        CTElement crde = rootVersion.getVersionHistory(feedback);
        CTLocation crdLoc = crde.lookupMyControllableResourceLoc(view, feedback);
        String result = crdLoc == null ? null : crdLoc.getDisplayName();
        return result;
    }

    public String getBaseCcSubVobCompRootDirPathname(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
        String result = this.lookupBaseCcSubVobCompRootDirPathname(view, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)"Could not compute the base CC sub VOB component root directory pathname given view {0} and component root directory main zero version universal selector {1}", (Object)view.getViewTag(), (Object)this.crdvmsUsel), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public String lookupDisplayName(CTProvider p, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String mtype = this.compObjInfo_Optional.getMtype();
        CCaseLib cc = p.getCCaseLib();
        if (mtype.equals("versioned object base")) {
            result = cc.computeVobTagFromVobFamilyUuid(this.compObjInfo_Optional.getPathName(), feedback);
        } else if (mtype.equals("directory version")) {
            result = this.lookupSubVobCompName(p, feedback);
        } else if (mtype.equals("component")) {
            result = cc.getComponentRootDir(this.compObjInfo_Optional.getUniversalSelector(), feedback);
        } else {
            throw new IllegalStateException("Unexpected mtype for component: " + mtype);
        }
        return result;
    }

    public String lookupSubVobCompName(CTProvider p, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String mtype = this.compObjInfo_Optional.getMtype();
        if ("directory version".equals(mtype)) {
            CTVersion version = CTVersion.valueOf(p, this.compObjInfo_Optional, feedback);
            CTElement element = version.getVersionHistory(feedback);
            result = p.getCCaseLib().getAttr("com.ibm.rational.interop.ClearCase.subVOB_Component", element.getUniversalSelector(feedback), feedback);
        }
        return result;
    }

    public boolean isSubVobComponent() {
        return "directory version".equals(this.compObjInfo_Optional.getMtype());
    }

    public boolean isUcmComponent() {
        return "component".equals(this.compObjInfo_Optional.getMtype());
    }
}

