/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AsyncSavePDBHMJob
extends Job {
    private static final int SCHEDULING_DELAY = 200;
    private volatile long latestRequest;
    private Object lockObj;
    private final PersistentBusyFlag busyFlag;
    private final ICorruptible corruptible;

    public AsyncSavePDBHMJob(String name, PersistentBusyFlag busyFlag, Object lockObj, ICorruptible corruptible) {
        super(name);
        this.setUser(false);
        this.setSystem(true);
        this.lockObj = lockObj;
        this.busyFlag = busyFlag;
        this.corruptible = corruptible;
    }

    public void requestSave() {
        this.latestRequest = System.currentTimeMillis();
        this.schedule(200L);
    }

    protected abstract PersistentDiskBackedHashMap<?, ?> getMapToPesist();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (System.currentTimeMillis() - this.latestRequest < 200L) {
            this.schedule(200L);
            return Status.CANCEL_STATUS;
        }
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.AsyncSavePDBHMJob_0, null);
        Object object = this.lockObj;
        synchronized (object) {
            PersistentDiskBackedHashMap<?, ?> toPersist = this.getMapToPesist();
            try {
                if (toPersist != null) {
                    toPersist.persist();
                    this.busyFlag.setComplete(result);
                }
            }
            catch (DBHMException e) {
                this.corruptible.setCorrupt(true, "Save failed", e);
                result.add(FileSystemStatusUtil.getStatusFor(4, Messages.AsyncSavePDBHMJob_1, e));
            }
            catch (IOException e) {
                result.add(FileSystemStatusUtil.getStatusFor(4, Messages.AsyncSavePDBHMJob_2, e));
            }
        }
        return result;
    }

    public boolean belongsTo(Object family) {
        if (ICopyFileAreaManager.instance == family) {
            return true;
        }
        return super.belongsTo(family);
    }
}

