/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.INonEFS;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.ContentMeta;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.api.storage.IRetryRequest;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.ContentHash;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class FileStorage
implements INonEFS {
    public static final boolean PLATFORM_SUPPORTS_EXEC_BIT = !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private final IFileStorage storage;

    public FileStorage(IFileStorage storage) {
        this.storage = storage;
        ((FileStorageWrapper)storage).setUnderlyingStorage(this);
    }

    protected final ISandbox getSandbox() {
        return this.storage.getShareable().getSandbox();
    }

    protected final IRelativeLocation getLocalPath() {
        return this.storage.getShareable().getLocalPath();
    }

    public final IFileStorage getStorage() {
        return this.storage;
    }

    public void lock(IProgressMonitor mon) {
    }

    public void unlock() {
    }

    public abstract void backup(IBackupHandler var1, BackupDilemmaHandler var2, IProgressMonitor var3) throws FileSystemException;

    public abstract void create(boolean var1, Object var2, IProgressMonitor var3) throws FileSystemException;

    public abstract void delete(IProgressMonitor var1) throws FileSystemException;

    public abstract void deregisterRepositoryProvider(IProgressMonitor var1) throws FileSystemException;

    public abstract String getActualName();

    public abstract void resolveChildStorage(FileStorageWrapper var1, String var2, ResourceType var3);

    public abstract Collection<IFileStorage> getChildren(boolean var1, IProgressMonitor var2) throws FileSystemException;

    public abstract IRelativeLocation getIDEPath();

    public abstract long getLocalTimeStamp() throws FileSystemException;

    public abstract long getModificationStamp() throws FileSystemException;

    public abstract IFileStorage getParent();

    public abstract ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind var1);

    public abstract boolean isExecutable(IProgressMonitor var1) throws FileSystemException;

    public abstract boolean isRepositoryProviderRegistered(IProgressMonitor var1) throws FileSystemException;

    public abstract void move(FileStorage var1, IProgressMonitor var2) throws FileSystemException;

    public abstract void preserveHistory(IProgressMonitor var1) throws FileSystemException;

    public abstract void refreshCachedSubTree(int var1, IProgressMonitor var2) throws FileSystemException;

    public abstract void registerRepositorProvider(IProgressMonitor var1) throws FileSystemException;

    public boolean requiresBackup(IProgressMonitor monitor) throws FileSystemException {
        return false;
    }

    public abstract boolean setExecutable(boolean var1, IProgressMonitor var2);

    public abstract boolean storageExists(IProgressMonitor var1) throws FileSystemException;

    public abstract boolean supportsExecBit();

    public boolean supportsSymbolicLinks() {
        return false;
    }

    public abstract boolean contains(ISchedulingRule var1);

    public abstract boolean isConflicting(ISchedulingRule var1);

    public abstract Object getAdapter(Class var1);

    public abstract boolean shouldBeIgnored(IProgressMonitor var1);

    protected abstract IFileStore getFileStore();

    public abstract boolean setWritable(boolean var1, IProgressMonitor var2);

    @Override
    public IFileStorage getChild(String name, IProgressMonitor newChild) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public ResourceType getResourceType(IProgressMonitor progress) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public long getSize(IProgressMonitor progress) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public boolean isFile(IProgressMonitor progress) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public boolean isFolder(IProgressMonitor progress) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public boolean isReadOnly(IProgressMonitor progress) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public boolean isSymbolicLink(IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public boolean isBrokenSymbolicLink(IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public boolean verifySymbolicLinkTargetType(boolean directory, IProgressMonitor monitor) throws FileSystemException {
        return true;
    }

    @Override
    public String convertIntoLocalForm(String target) {
        return target;
    }

    @Override
    public void create(String targetPath, IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public void setSymLinkTarget(String targetPath, IProgressMonitor newChild) throws FileSystemException {
        throw new IllegalStateException();
    }

    @Override
    public String getSymLinkTarget(IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException();
    }

    public void setLocalTimeStamp(long timeStamp, IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException();
    }

    public abstract InputStream getContents(IFileOptions var1) throws ContentRetrievalFailure;

    public abstract void create(IFileOptions var1, InputStream var2, IProgressMonitor var3) throws FileSystemException;

    public abstract void setContents(IFileOptions var1, InputStream var2, Shed var3, IProgressMonitor var4) throws FileSystemException;

    public IRetryRequest recoverFromUploadFailure(Exception e, IProgressMonitor progress) {
        return null;
    }

    public InputStream getLocalChangeDetectionStream(IFileOptions fileOptions) throws ContentRetrievalFailure {
        return this.getContents(fileOptions);
    }

    public InputStream getContents(IFileOptions fileOptions, InputStream inputStream) throws ContentRetrievalFailure {
        return inputStream;
    }

    public ContentMeta setContentsCalcMeta(IFileOptions optionsForWrite, InputStream in, Shed backupShed, IProgressMonitor progress) throws TeamRepositoryException {
        DigestComputingInputStream hashedIn = ContentHash.getDigestComputingStream((InputStream)in);
        this.setContents(optionsForWrite, (InputStream)hashedIn, backupShed, progress);
        return new ContentMeta(ContentHash.valueOf((byte[])hashedIn.getFinalDigest()), hashedIn.getContentSize());
    }
}

