/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.ManagedFileTree;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ManagedFileSystem
extends FileSystem {
    private static final IFileStore NULL_ROOT = EFS.getNullFileSystem().getStore((IPath)Path.ROOT);
    private static final boolean caseSensitive = EFS.getLocalFileSystem().isCaseSensitive();
    private static ManagedFileSystem instance;
    public static final String SCHEME_MANAGED = "sourcecontrol";
    public static final String DEFAULT_CFA = "default";

    public static ManagedFileSystem getInstance() {
        ManagedFileSystem tmpInstance = instance;
        if (tmpInstance != null) {
            return tmpInstance;
        }
        instance = new ManagedFileSystem();
        return instance;
    }

    public ManagedFileSystem() {
        instance = this;
    }

    public IFileStore getStore(URI uri) {
        try {
            ManagedLocation loc = ManagedFileSystem.expandUri(uri);
            if (loc == null) {
                return NULL_ROOT;
            }
            IFileStore baseStore = EFS.getStore((URI)loc.getBaseStoreURI());
            return new ManagedFileStore(loc.getCfaRoot(), loc.getSharePath(), baseStore);
        }
        catch (CoreException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Could not find base file system implementation for " + uri, e);
            return NULL_ROOT;
        }
    }

    public static ManagedLocation expandUri(URI uri) {
        URI baseStoreURI;
        ILocation cfaLocation;
        int numSegments;
        Path fullPath;
        block8: {
            Assert.isLegal((boolean)SCHEME_MANAGED.equals(uri.getScheme()));
            try {
                fullPath = new Path(uri.getPath());
                if (fullPath.segmentCount() >= 1) break block8;
                LoggingHelper.error("com.ibm.team.filesystem.client", "Invalid URI: " + uri, new Exception().fillInStackTrace());
                return null;
            }
            catch (URISyntaxException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not find base file system implementation for " + uri, e);
                return null;
            }
        }
        SharingManager mgr = null;
        if (fullPath.segment(0).equals(DEFAULT_CFA)) {
            numSegments = 0;
            mgr = SharingManager.getInstance();
            cfaLocation = mgr.getIDEWorkAreaRoot();
        } else {
            numSegments = Integer.parseInt(fullPath.segment(0));
            IPath cfaPath = fullPath.removeLastSegments(fullPath.segmentCount() - numSegments - 1).removeFirstSegments(1).makeUNC(fullPath.isUNC());
            cfaLocation = new PathLocation(cfaPath);
        }
        RelativeLocation sharePath = new RelativeLocation(fullPath.removeFirstSegments(numSegments + 1).setDevice(null).makeUNC(false).makeAbsolute().segments());
        if (uri.getQuery() != null) {
            baseStoreURI = new URI(uri.getQuery());
        } else {
            if (mgr == null) {
                mgr = SharingManager.getInstance();
            }
            IPath path = (IPath)mgr.getIDEWorkAreaRoot().append(sharePath).getAdapter(IPath.class);
            baseStoreURI = URIUtil.toURI((IPath)path);
        }
        return new ManagedLocation(cfaLocation, sharePath, baseStoreURI);
    }

    public static URI getManagedURI(ILocation cfaLocation, IRelativeLocation shareLocation, URI baseStoreURI) {
        IPath cfaPath = null;
        if (cfaLocation != null) {
            cfaPath = (IPath)cfaLocation.getAdapter(IPath.class);
        }
        IPath sharePath = shareLocation.toPath();
        String path = cfaPath == null ? new Path(null, "/default").append(sharePath).makeUNC(false).makeAbsolute().toString() : new Path(cfaPath.getDevice(), Integer.toString(cfaPath.segmentCount())).append(cfaPath).append(sharePath).makeUNC(cfaPath.isUNC()).makeAbsolute().toString();
        if (path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        try {
            return new URI(SCHEME_MANAGED, null, "jazz", -1, path, baseStoreURI == null ? null : baseStoreURI.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI getCanonicalManagedURI(ILocation cfaPath, IRelativeLocation sharePath, URI baseStoreURI) {
        IPath defaultRootPath;
        ILocation defaultRoot = SharingManager.getInstance().getIDEWorkAreaRoot();
        if (cfaPath != null && cfaPath.equals(defaultRoot)) {
            cfaPath = null;
        }
        if (baseStoreURI != null && defaultRoot != null && (defaultRootPath = (IPath)defaultRoot.append(sharePath).getAdapter(IPath.class)) != null && defaultRootPath.equals((Object)URIUtil.toPath((URI)baseStoreURI))) {
            baseStoreURI = null;
        }
        return ManagedFileSystem.getManagedURI(cfaPath, sharePath, baseStoreURI);
    }

    public static URI getBasicURI(URI managedURI) {
        ManagedLocation location;
        block4: {
            Assert.isLegal((boolean)SCHEME_MANAGED.equals(managedURI.getScheme()));
            try {
                if (managedURI.getQuery() != null) {
                    return new URI(managedURI.getQuery());
                }
                location = ManagedFileSystem.expandUri(managedURI);
                ILocation fullPath = location.getCfaRoot().append(location.sharePath);
                ILocation defaultRoot = SharingManager.getInstance().getIDEWorkAreaRoot();
                if (!fullPath.getParent().sameLocation(defaultRoot, caseSensitive)) break block4;
                return null;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Could not find base file system implementation for " + managedURI, e);
            }
        }
        return location.getBaseStoreURI();
    }

    public boolean isCaseSensitive() {
        return caseSensitive;
    }

    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) {
        if (root instanceof ManagedFileStore && ManagedFileSystem.trackingChanges()) {
            ManagedFileTree tree = new ManagedFileTree((ManagedFileStore)root);
            try {
                if (tree.populate(monitor)) {
                    return tree;
                }
            }
            catch (CoreException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            }
            catch (FileSystemException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
        }
        return null;
    }

    public int attributes() {
        return EFS.getLocalFileSystem().attributes();
    }

    public boolean canDelete() {
        return EFS.getLocalFileSystem().canDelete();
    }

    public boolean canWrite() {
        return EFS.getLocalFileSystem().canWrite();
    }

    static boolean trackingChanges() {
        return SharingManager.getInstance().isChangeMonitoringEnabled() && !FileSystemCore.isShutDown();
    }

    public static class ManagedLocation {
        private final ILocation cfaRoot;
        private final IRelativeLocation sharePath;
        private final URI baseStore;

        public ManagedLocation(ILocation cfaRoot, IRelativeLocation sharePath, URI baseStore) {
            this.cfaRoot = cfaRoot;
            this.sharePath = sharePath;
            this.baseStore = baseStore;
        }

        public ILocation getCfaRoot() {
            return this.cfaRoot;
        }

        public IRelativeLocation getSharePath() {
            return this.sharePath;
        }

        public URI getBaseStoreURI() {
            return this.baseStore;
        }
    }
}

