/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.checkin;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.checkin.UploadHandler;
import com.ibm.team.filesystem.client.operations.IUploadFailure;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IStatus;

public class UploadFailure
implements IUploadFailure {
    private IShareable shareable;
    private Throwable rootCause;
    private UploadHandler uploadHandler;
    private boolean skipFailure;

    public UploadFailure(IShareable shareable, UploadHandler uploadHandler, Throwable e) {
        this.shareable = shareable;
        this.uploadHandler = uploadHandler;
        this.rootCause = e;
        this.skipFailure = false;
    }

    @Override
    public IShareable getShareable() {
        return this.shareable;
    }

    protected Throwable getRootCause() {
        return this.rootCause;
    }

    public UploadHandler getUploadHandler() {
        return this.uploadHandler;
    }

    @Override
    public IStatus getStatus() {
        return FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_15, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), this.rootCause);
    }

    @Override
    public final boolean isAtomicCommit() {
        return this.uploadHandler.isAtomicCommitRequired();
    }

    @Override
    public final void setSkipFailure(boolean skipUploadFailure) {
        if (this.isAtomicCommit() && skipUploadFailure) {
            throw new IllegalStateException("Can't skip failures if commit is atomic");
        }
        this.skipFailure = skipUploadFailure;
    }

    @Override
    public boolean isSkipFailure() {
        return this.skipFailure;
    }
}

