/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAListReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class GlobalConfigurationLockRequest
extends CopyFileAreaLockRequest {
    private final Collection<? extends IConfigurationDescriptor> configurationsToLock;
    private final boolean expandToIncludeEntireCopyFileArea;

    public GlobalConfigurationLockRequest(Set<? extends IConfigurationDescriptor> configurationsToLock2, boolean expandToIncludeEntireCopyFileArea) {
        this.configurationsToLock = configurationsToLock2;
        this.expandToIncludeEntireCopyFileArea = expandToIncludeEntireCopyFileArea;
    }

    @Override
    public void addLocks(Set<? super AbstractLock> rules, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.configurationsToLock.size());
        if (this.configurationsToLock.isEmpty()) {
            progress.done();
            return;
        }
        rules.add(CFAListReadLock.INSTANCE);
        if (this.expandToIncludeEntireCopyFileArea) {
            HashSet<ILocation> hashSet = new HashSet<ILocation>();
            for (IConfigurationDescriptor iConfigurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(iConfigurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    ILocation root = cfa.getRoot();
                    if (!hashSet.add(root)) continue;
                    rules.add(new GlobalCFALock(root));
                }
            }
        } else {
            for (IConfigurationDescriptor iConfigurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(iConfigurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    ILocation root = cfa.getRoot();
                    rules.add(new ComponentLock(root, iConfigurationDescriptor.getConnectionHandle(), iConfigurationDescriptor.getComponentHandle()));
                }
            }
        }
        progress.done();
    }

    @Override
    public boolean validateLocks(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.configurationsToLock.size());
        if (this.configurationsToLock.isEmpty()) {
            progress.done();
            return true;
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            HashSet<ILocation> hashSet = new HashSet<ILocation>();
            for (IConfigurationDescriptor iConfigurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(iConfigurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    ILocation root = cfa.getRoot();
                    if (!hashSet.add(root) || CopyFileAreaManager.instance.batchingLock.isLocked(new GlobalCFALock(root))) continue;
                    progress.done();
                    return false;
                }
            }
        } else {
            for (IConfigurationDescriptor iConfigurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea cfa : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(iConfigurationDescriptor, (IProgressMonitor)progress.newChild(1))) {
                    ILocation root = cfa.getRoot();
                    if (CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(root, iConfigurationDescriptor.getConnectionHandle(), iConfigurationDescriptor.getComponentHandle()))) continue;
                    progress.done();
                    return false;
                }
            }
        }
        progress.done();
        return true;
    }
}

