/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.core;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MetadataChangeTracker
implements IMetadataChangeTracker {
    private static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    private static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    private final PersistentHeapManager heapMgr;
    private final ChangeDiskBackedMapManager mapMgr;
    private final ISharingMetadata metadata;
    private final IPath metadataRoot;

    public MetadataChangeTracker(ISharingMetadata metadata, IPath metadataRoot, PersistentBusyFlag persistentMetadataFlag, ReadWriteLock globalLock) {
        this.metadata = metadata;
        this.metadataRoot = metadataRoot;
        this.heapMgr = new PersistentHeapManager();
        this.mapMgr = new ChangeDiskBackedMapManager(globalLock, persistentMetadataFlag, metadata);
    }

    void close() throws FileSystemException {
        this.mapMgr.closeAll();
    }

    private void notifyTracker(IComponentHandle component, IContextHandle connection) {
        LocalChangeTracker tracker = LocalChangeManager.getInstance().findTracker(connection, component, this.metadata.getRoot());
        if (tracker != null) {
            tracker.metadataChanged();
        }
    }

    private boolean isIgnored(IRelativeLocation path, SubMonitor monitor) throws FileSystemException {
        SharingManager mgr = SharingManager.getInstance();
        Shareable shareable = new Shareable(this.metadata.getRoot(), path, ResourceType.FILE);
        mgr.disableChangeMonitoring();
        try {
            boolean bl = shareable.shouldBeIgnored((IProgressMonitor)monitor);
            return bl;
        }
        finally {
            mgr.enableChangeMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMetadataChangeTracker.IChangeType> getLocalChanges(IComponentHandle component, IContextHandle connection, IProgressMonitor progress) throws FileSystemException {
        LockableMap<UUID, IItemType> map = this.getMapFor(component, connection, false);
        HashMap<UUID, InverseFileItemInfo> infoMap = new HashMap<UUID, InverseFileItemInfo>();
        try {
            ArrayList<IMetadataChangeTracker.IChangeType> infos;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
            Map<UUID, IItemType> map2 = map.entries();
            synchronized (map2) {
                int mapSize = map.entries().size();
                infos = new ArrayList<IMetadataChangeTracker.IChangeType>(mapSize);
                monitor.beginTask(Messages.MetadataChangeTracker_LOADING_CHANGES, mapSize);
                block15: for (Map.Entry<UUID, IItemType> e : map.entries().entrySet()) {
                    boolean isFlagChange;
                    IRelativeLocation currentMovedFromPath;
                    IRelativeLocation originalPath;
                    IRelativeLocation currentPath;
                    int changeType;
                    IVersionableHandle item = (IVersionableHandle)e.getValue().createItemHandle(e.getKey(), null);
                    InverseFileItemInfo itemInfo = this.getInverseInfo(item, component, connection, infoMap);
                    if (itemInfo == null) {
                        FileSystemException ex = new FileSystemException(NLS.bind((String)Messages.MetadataChangeTracker_8, (Object)item.getItemId().toString()));
                        ex.fillInStackTrace();
                        this.metadata.setCorrupt(true, ex.getMessage(), (Throwable)((Object)ex));
                        throw ex;
                    }
                    if (itemInfo.getVersionableHandle().getStateId() == null) {
                        changeType = 4;
                    } else if (itemInfo.getLocalName() == null) {
                        if (this.metadata.getPathForShareRoot(itemInfo.getVersionableHandle(), component, connection) == null) {
                            InverseFileItemInfo parentInfo = this.getInverseInfo((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap);
                            if (parentInfo == null) {
                                FileSystemException ex = new FileSystemException(NLS.bind((String)Messages.MetadataChangeTracker_8, (Object)itemInfo.getParent().getItemId().toString()));
                                ex.fillInStackTrace();
                                this.metadata.setCorrupt(true, ex.getMessage(), (Throwable)((Object)ex));
                                throw ex;
                            }
                            changeType = parentInfo.getLocalName() == null ? 2 : 1;
                        } else {
                            changeType = 1;
                        }
                    } else {
                        changeType = this.noPathChange(itemInfo) ? 0 : 3;
                    }
                    switch (changeType) {
                        case 2: {
                            currentPath = null;
                            originalPath = null;
                            currentMovedFromPath = null;
                            break;
                        }
                        case 1: {
                            currentPath = this.computeDeletionPath(item, component, connection, infoMap);
                            if (this.isIgnored(currentPath, monitor.newChild(1))) continue block15;
                            originalPath = this.computeOriginalPath(item, component, connection, infoMap);
                            currentMovedFromPath = null;
                            break;
                        }
                        case 0: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            if (this.isIgnored(currentPath, monitor.newChild(1))) continue block15;
                            originalPath = this.computeOriginalPath(item, component, connection, infoMap);
                            currentMovedFromPath = null;
                            break;
                        }
                        case 4: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            if (this.isIgnored(currentPath, monitor.newChild(1))) continue block15;
                            originalPath = null;
                            currentMovedFromPath = null;
                            break;
                        }
                        case 3: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            IRelativeLocation rootPath = this.metadata.getPathForShareRoot(item, component, connection);
                            currentMovedFromPath = rootPath != null ? rootPath.getParent().append(itemInfo.getName()) : this.computeDeletionPath((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap).append(itemInfo.getName());
                            SubMonitor moveMon = monitor.newChild(1);
                            moveMon.setWorkRemaining(2);
                            boolean targetIgnored = this.isIgnored(currentPath, moveMon.newChild(1));
                            boolean sourceIgnored = this.isIgnored(currentMovedFromPath, moveMon.newChild(1));
                            if (sourceIgnored && targetIgnored) continue block15;
                            if (sourceIgnored && !targetIgnored) {
                                changeType = 4;
                                originalPath = null;
                                currentMovedFromPath = null;
                                break;
                            }
                            if (!sourceIgnored && targetIgnored) {
                                changeType = 1;
                                originalPath = this.computeOriginalPath(item, component, connection, infoMap);
                                currentPath = currentMovedFromPath;
                                currentMovedFromPath = null;
                                break;
                            }
                            Assert.isTrue((!sourceIgnored && !targetIgnored ? 1 : 0) != 0);
                            originalPath = this.computeOriginalPath(item, component, connection, infoMap);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    IFolderHandle localParent = itemInfo.getLocalParent();
                    IFolderHandle remoteParent = itemInfo.getParent();
                    boolean isContentChanged = !itemInfo.isFolder() && (itemInfo.isContentChanged() || itemInfo.getOriginalLineDelimiter() != itemInfo.getLineDelimiter());
                    boolean bl = isFlagChange = itemInfo.isExecutable() != itemInfo.isOriginalExecutable() || itemInfo.isDirectoryLink() != itemInfo.isOriginalDirectoryLink() || itemInfo.getOriginalContentType() == null && itemInfo.getContentType() != null || itemInfo.getOriginalContentType() != null && !itemInfo.getOriginalContentType().equals(itemInfo.getContentType()) || !itemInfo.getChangedProperties().isEmpty() || !itemInfo.getRemovedProperties().isEmpty();
                    if (changeType == 0 && !isContentChanged && !isFlagChange) {
                        throw new IllegalStateException();
                    }
                    infos.add(new ChangeType(itemInfo.getVersionableHandle(), changeType, localParent, remoteParent, currentPath, originalPath, currentMovedFromPath, isContentChanged, isFlagChange));
                }
            }
            ArrayList<IMetadataChangeTracker.IChangeType> arrayList = infos;
            return arrayList;
        }
        catch (DBHMException e) {
            this.metadata.setCorrupt(true, "Failure during getLocalChanges()", e);
            throw new FileSystemException(Messages.MetadataChangeTracker_4, e);
        }
        finally {
            this.releaseMap(map);
        }
    }

    private IRelativeLocation computeLocalPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemException {
        ArrayList<String> segments = null;
        while (true) {
            IRelativeLocation rootPath;
            if ((rootPath = this.metadata.getPathForShareRoot(item, component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                String[] segmentsReversed = new String[segments.size()];
                int j = 0;
                int i = max;
                while (i >= 0) {
                    segmentsReversed[j] = (String)segments.get(i);
                    ++j;
                    --i;
                }
                return rootPath.append(new RelativeLocation(segmentsReversed));
            }
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            if (info == null) {
                this.metadata.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (item == null ? "null item" : item.getItemId().getUuidValue()), null);
                throw new IllegalStateException("Path to " + (item == null ? "null item" : item.getItemId().getUuidValue()) + " does not resolve");
            }
            String name = info.getLocalName();
            if (name == null) {
                this.metadata.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (item == null ? "null item" : item.getItemId().getUuidValue()), null);
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            name.length();
            segments.add(name);
            item = info.getLocalParent();
        }
    }

    private IRelativeLocation computeOriginalPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemException {
        ArrayList<String> segments = null;
        while (true) {
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            String name = info.getName();
            IRelativeLocation rootPath = this.metadata.getPathForShareRoot(item, component, connection);
            if (rootPath != null) {
                if (name != null && !name.equals(info.getLocalName()) && !info.isLoadedWithAnotherName()) {
                    rootPath = rootPath.getParent();
                    if (segments == null) {
                        return rootPath.append(name);
                    }
                    segments.add(name);
                } else if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                String[] segmentsReversed = new String[segments.size()];
                int j = 0;
                int i = max;
                while (i >= 0) {
                    segmentsReversed[j] = (String)segments.get(i);
                    ++j;
                    --i;
                }
                return rootPath.append(new RelativeLocation(segmentsReversed));
            }
            if (name == null) {
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            name.length();
            segments.add(name);
            item = info.getParent();
        }
    }

    private IRelativeLocation computeDeletionPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemException {
        ArrayList<String> segments = null;
        boolean computingRemote = true;
        while (true) {
            String name;
            InverseFileItemInfo info;
            IRelativeLocation rootPath;
            if ((rootPath = this.metadata.getPathForShareRoot(item, component, connection)) != null) {
                if (computingRemote) {
                    info = this.getInverseInfo(item, component, connection, cache);
                    name = info.getName();
                    if (name != null && info.getLocalName() == null && !name.equals(rootPath.getName()) && !info.isLoadedWithAnotherName()) {
                        rootPath = rootPath.getParent();
                        if (segments == null) {
                            return rootPath.append(name);
                        }
                        segments.add(name);
                    } else if (segments == null) {
                        return rootPath;
                    }
                } else if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                String[] segmentsReversed = new String[segments.size()];
                int j = 0;
                int i = max;
                while (i >= 0) {
                    segmentsReversed[j] = (String)segments.get(i);
                    ++j;
                    --i;
                }
                return rootPath.append(new RelativeLocation(segmentsReversed));
            }
            info = this.getInverseInfo(item, component, connection, cache);
            name = info.getLocalName();
            if (computingRemote) {
                if (name != null) {
                    computingRemote = false;
                } else {
                    name = info.getName();
                }
            }
            if (name == null) {
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            name.length();
            segments.add(name);
            item = computingRemote ? info.getParent() : info.getLocalParent();
        }
    }

    private InverseFileItemInfo getInverseInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemException {
        InverseFileItemInfo info = cache.get(item.getItemId());
        if (info != null) {
            return info;
        }
        info = this.metadata.getFileItemInfo(item, component, connection);
        cache.put(item.getItemId(), info);
        return info;
    }

    private static boolean isUnchanged(String oldStr, String newStr) {
        if (oldStr == newStr) {
            return true;
        }
        if (oldStr == null || newStr == null) {
            return false;
        }
        return oldStr.equals(newStr);
    }

    private static boolean isUnchanged(IVersionableHandle oldHandle, IVersionableHandle newHandle, boolean compareState) {
        if (oldHandle == newHandle) {
            return true;
        }
        if (oldHandle == null || newHandle == null) {
            return false;
        }
        if (compareState && !MetadataChangeTracker.isUnchanged(oldHandle.getStateId(), newHandle.getStateId())) {
            return false;
        }
        return oldHandle.sameItemId((IItemHandle)newHandle);
    }

    private static boolean isUnchanged(UUID oldState, UUID newState) {
        if (oldState == newState) {
            return true;
        }
        if (oldState == null || newState == null) {
            return false;
        }
        return oldState.equals((Object)newState);
    }

    private boolean itemUnchanged(InverseFileItemInfo info1, InverseFileItemInfo info2) {
        if (info1 == info2) {
            return true;
        }
        if (info1 == null || info2 == null) {
            return false;
        }
        return MetadataChangeTracker.isUnchanged((IVersionableHandle)info1.getParent(), (IVersionableHandle)info2.getParent(), false) && MetadataChangeTracker.isUnchanged(info1.getName(), info2.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info1.getLocalParent(), (IVersionableHandle)info2.getLocalParent(), false) && (MetadataChangeTracker.isUnchanged(info1.getLocalName(), info2.getLocalName()) || info1.isLoadedWithAnotherName() && info2.isLoadedWithAnotherName()) && info1.isContentChanged() == info2.isContentChanged() && MetadataChangeTracker.isUnchanged(info1.getContentType(), info2.getContentType()) && info1.getLineDelimiter() == info2.getLineDelimiter() && MetadataChangeTracker.isUnchanged(info1.getOriginalContentType(), info2.getOriginalContentType()) && info1.getOriginalLineDelimiter() == info2.getOriginalLineDelimiter() && info1.isExecutable() == info2.isExecutable() && info1.isOriginalExecutable() == info2.isOriginalExecutable() && info1.isDirectoryLink() == info2.isDirectoryLink() && info1.isOriginalDirectoryLink() == info2.isOriginalDirectoryLink() && info1.getOriginalProperties().equals(info2.getOriginalProperties()) && info1.getChangedProperties().equals(info2.getChangedProperties()) && info1.getRemovedProperties().equals(info2.getRemovedProperties());
    }

    private boolean noChange(InverseFileItemInfo info) throws FileSystemException {
        if (info == null) {
            return true;
        }
        return info.getVersionableHandle().hasStateId() && info.getOriginalLineDelimiter() == info.getLineDelimiter() && info.isExecutable() == info.isOriginalExecutable() && info.isDirectoryLink() == info.isOriginalDirectoryLink() && !info.isContentChanged() && MetadataChangeTracker.isUnchanged(info.getOriginalContentType(), info.getContentType()) && this.noPathChange(info) && info.getChangedProperties().isEmpty() && info.getRemovedProperties().isEmpty();
    }

    private boolean noPathChange(InverseFileItemInfo info) throws FileSystemException {
        if (info == null) {
            return true;
        }
        return (MetadataChangeTracker.isUnchanged(info.getLocalName(), info.getName()) || info.isLoadedWithAnotherName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info.getLocalParent(), (IVersionableHandle)info.getParent(), false);
    }

    private LockableMap<UUID, IItemType> getMapFor(IComponentHandle component, IContextHandle connection) throws FileSystemException {
        return this.getMapFor(component, connection, true);
    }

    private LockableMap<UUID, IItemType> getMapFor(IComponentHandle component, IContextHandle connection, boolean exclusive) throws FileSystemException {
        Path path = new Path(SCM_CHANGED_INFOS_PREFIX + component.getItemId().getUuidValue() + "_" + connection.getItemId().getUuidValue() + SCM_CHANGED_INFOS_SUFFIX);
        try {
            return this.mapMgr.loadMap((IPath)path, exclusive, (IPath)path);
        }
        catch (DBHMException e) {
            this.metadata.setCorrupt(true, "Failed to get map for " + path.toString(), e);
            throw new FileSystemException(Messages.DiskBackedMapManager_0, e);
        }
    }

    private void releaseMap(LockableMap<UUID, IItemType> map) throws FileSystemException {
        this.mapMgr.releaseMap(map);
    }

    InverseFileItemInfo handleFileItemInfoSet(IVersionableHandle item, IComponentHandle component, IContextHandle connection, InverseFileItemInfo oldInfo, InverseFileItemInfo newInfo) throws FileSystemException {
        boolean noChangeNewInfo = this.noChange(newInfo);
        if (this.noChange(oldInfo) != noChangeNewInfo) {
            try {
                LockableMap<UUID, IItemType> map = this.getMapFor(component, connection);
                try {
                    if (noChangeNewInfo) {
                        map.entries().remove(item.getItemId());
                    } else {
                        map.entries().put(item.getItemId(), item.getItemType());
                    }
                }
                finally {
                    this.releaseMap(map);
                }
            }
            catch (DBHMException e) {
                this.metadata.setCorrupt(true, "Failure when setting item info", e);
                throw new FileSystemException(Messages.MetadataChangeTracker_6, e);
            }
            this.notifyTracker(component, connection);
        } else if (!this.itemUnchanged(newInfo, oldInfo)) {
            this.notifyTracker(component, connection);
        }
        return oldInfo;
    }

    protected class ChangeDiskBackedMapManager
    extends DiskBackedMapManager<UUID, IItemType> {
        public ChangeDiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag flag, ICorruptible corruptible) {
            super(lock, flag, corruptible);
        }

        @Override
        protected LockableMap<UUID, IItemType> getLockableMap(IPath path, IPath realPath) {
            return new ChangeMap(path);
        }
    }

    protected class ChangeMap
    extends LockableMap<UUID, IItemType> {
        public ChangeMap(IPath path) {
            super(path, MetadataChangeTracker.this.metadataRoot.append(path).toFile());
        }

        @Override
        protected void initEntries() {
            try {
                this.entries = new ChangedDescriptorsStore(MetadataChangeTracker.this.metadataRoot.append(this.getPath()).toFile(), MetadataChangeTracker.this.heapMgr);
            }
            catch (DBHMException e) {
                MetadataChangeTracker.this.metadata.setCorrupt(true, e.getMessage(), e);
                throw e;
            }
        }
    }

    protected static class ChangeType
    implements IMetadataChangeTracker.IChangeType {
        private IVersionableHandle item;
        private int changeType;
        private IFolderHandle currentParent;
        private IFolderHandle previousParent;
        private IRelativeLocation currentPath;
        private IRelativeLocation originalPath;
        private IRelativeLocation currentMovedFromPath;
        private boolean isContentChange;
        private boolean isFlagChange;

        public ChangeType(IVersionableHandle item, int changeType, IFolderHandle currentParent, IFolderHandle previousParent, IRelativeLocation currentPath, IRelativeLocation originalpath, IRelativeLocation currentMovedFromPath, boolean isContentChange, boolean isFlagChange) {
            this.item = item;
            this.changeType = changeType;
            this.currentParent = currentParent;
            this.previousParent = previousParent;
            this.currentPath = currentPath;
            this.originalPath = originalpath;
            this.currentMovedFromPath = currentMovedFromPath;
            this.isContentChange = isContentChange;
            this.isFlagChange = isFlagChange;
        }

        @Override
        public IFolderHandle getCurrentParent() {
            return this.currentParent;
        }

        @Override
        public IRelativeLocation getCurrentPath() {
            return this.currentPath;
        }

        @Override
        public IRelativeLocation getOriginalPath() {
            return this.originalPath;
        }

        @Override
        public IVersionableHandle getItem() {
            return this.item;
        }

        @Override
        public IFolderHandle getPreviousParent() {
            return this.previousParent;
        }

        @Override
        public int getType() {
            return this.changeType;
        }

        @Override
        public boolean isContentChange() {
            return this.isContentChange;
        }

        @Override
        public boolean isFlagChange() {
            return this.isFlagChange;
        }

        @Override
        public IRelativeLocation getCurrentMovedFromPath() {
            return this.currentMovedFromPath;
        }
    }

    protected static class ChangedDescriptorsStore
    extends Store<UUID, IItemType> {
        private static final int METADATA_VERSION = 0;

        public ChangedDescriptorsStore(File file, PersistentHeapManager mgr) {
            super(file, mgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(0);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 0) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 0);
            }
        }

        private long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                UUID id = (UUID)o;
                dos.writeUTF(id.getUuidValue());
                return this.persistStream(out);
            }
            if (o == IFolder.ITEM_TYPE) {
                return 1L;
            }
            if (o == ISymbolicLink.ITEM_TYPE) {
                return 2L;
            }
            return 0L;
        }

        protected void freeObject(long offset, int flags) throws IOException {
            if ((flags & 1) != 0) {
                super.freeObject(offset, flags);
            }
        }

        protected Object readObject(long offset, int flags) throws IOException, ClassNotFoundException {
            if ((flags & 1) != 0) {
                return super.readObject(offset, flags);
            }
            if (offset == 1L) {
                return IFolder.ITEM_TYPE;
            }
            if (offset == 2L) {
                return ISymbolicLink.ITEM_TYPE;
            }
            return IFileItem.ITEM_TYPE;
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            DataInputStream dis = new DataInputStream(in);
            return UUID.valueOf((String)dis.readUTF());
        }
    }
}

