/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.operations.IEncodingDownloadFailure;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IStatus;

public class EncodingDownloadFailure
implements IEncodingDownloadFailure {
    private DeferredInformation deferredInformation;
    private IStatus status;

    public EncodingDownloadFailure(DeferredInformation deferredUpdateInformation) {
        this.deferredInformation = deferredUpdateInformation;
        this.status = null;
    }

    @Override
    public String getEncoding() {
        return this.deferredInformation.getEncoding();
    }

    @Override
    public IShareable getShareable() {
        return this.deferredInformation.getShareable();
    }

    @Override
    public boolean hasDirection() {
        return this.deferredInformation.hasAlternateDownloadDirection();
    }

    @Override
    public void setAlternativeEncoding(String alternativeEncoding) {
        if (alternativeEncoding == null) {
            throw new IllegalArgumentException("alternativeEncoding cannot be null");
        }
        if (!Charset.isSupported(alternativeEncoding)) {
            throw new UnsupportedCharsetException(alternativeEncoding);
        }
        this.deferredInformation.setAlternateEncoding(alternativeEncoding);
    }

    @Override
    public void setIgnoreEncoding(boolean ignoreEncoding) {
        if (ignoreEncoding) {
            this.deferredInformation.setAlternativeLineDelimiter(FileLineDelimiter.LINE_DELIMITER_NONE);
        } else {
            this.deferredInformation.setAlternativeLineDelimiter(null);
        }
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    public DeferredInformation getDeferredUpdateInformation() {
        return this.deferredInformation;
    }
}

