/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.ContentMeta;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.internal.content.DeletedContent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.DeferredUpdateInformation;
import com.ibm.team.filesystem.client.internal.load.EncodingDownloadFailure;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.SilentProgressMonitor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class MergeLoadMutator
extends FileSystemOperation
implements ILoadMutator {
    private IDownloadListener downloadMonitor;
    protected IFileContentManagerSession contentSession = null;
    private IConnection connection;
    private IComponent component;
    private IContextHandle connectionHandle;
    private final ISandbox sandbox;
    private LoadTree loadTree;
    private ITeamRepository repo;
    private Map<UUID, ILoadLocation> loadLocations;
    private LoadDilemmaHandler problemHandler;
    private Shed shed;
    private Set<IRemovedShare> sharesToRemove;
    private ILoadFilter filter;

    public MergeLoadMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler) {
        super(loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler);
        this.problemHandler = loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler;
        this.sandbox = sandbox;
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
    }

    @Override
    public void configureLoad(int options, IConnection connection, IComponent component, List<? extends ILoadLocation> itemsToLoad, LoadTree loadTree, IDownloadListener downloadMonitor, ILoadFilter filter) {
        if (connection == null) {
            throw new IllegalArgumentException("Invalid connection");
        }
        if (component == null) {
            throw new IllegalArgumentException("Invalid component");
        }
        if (itemsToLoad == null) {
            throw new IllegalArgumentException("Invalid items to load");
        }
        if (loadTree == null) {
            throw new IllegalArgumentException("Invalid load tree");
        }
        this.connection = connection;
        this.component = component;
        this.repo = connection.teamRepository();
        this.loadTree = loadTree;
        this.loadLocations = new HashMap<UUID, ILoadLocation>();
        this.downloadMonitor = downloadMonitor;
        this.filter = filter;
        for (ILoadLocation iLoadLocation : itemsToLoad) {
            if (!component.sameItemId((IItemHandle)iLoadLocation.getComponent())) {
                throw new IllegalArgumentException("Items to be loaded not for component " + component.getName());
            }
            if (!this.sandbox.equals(iLoadLocation.getSandbox())) {
                throw new IllegalArgumentException("Items to be loaded must be for the same sandbox " + this.sandbox.getRoot().toString() + " and " + iLoadLocation.getSandbox().toString());
            }
            this.loadLocations.put(iLoadLocation.getRootToLoad().getItemId(), iLoadLocation);
        }
        this.connectionHandle = connection instanceof IWorkspaceConnection ? (IContextHandle)((IWorkspaceConnection)connection).getResolvedWorkspace().getItemHandle() : ((IBaselineConnection)connection).getBaseline();
    }

    @Override
    public void configureShareRemoval(Set<IRemovedShare> sharesToRemove) {
        this.sharesToRemove = sharesToRemove;
    }

    protected void beginning() throws TeamRepositoryException, FileSystemException {
    }

    @Override
    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        ThreadCheck.checkLongOpsAllowed();
        int work = this.sharesToRemove == null ? 0 : 5;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(work += this.loadTree == null ? 0 : 95));
        if (this.sharesToRemove != null) {
            this.removeShares((IProgressMonitor)progress.newChild(5));
        }
        if (this.loadTree != null) {
            this.load((IProgressMonitor)progress.newChild(95));
        }
    }

    private void removeShares(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.sharesToRemove.size());
        for (IRemovedShare shareToRemove : this.sharesToRemove) {
            IShare share = shareToRemove.getShare();
            mon.setTaskName(NLS.bind((String)Messages.LoadOperation_8, (Object)share.getPath().toString(), (Object[])new Object[0]));
            if (shareToRemove.isToBeDeleted()) {
                MergeLoadMutator.deleteShare(share, this.shed, (IProgressMonitor)mon.newChild(1));
            } else {
                ResourceType type = ResourceType.FOLDER;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (descriptor != null) {
                    type = ResourceType.getResourceType(descriptor.getRootVersionable());
                }
                Shareable shareable = (Shareable)share.getSandbox().findShareable(share.getPath(), type);
                shareable.unshare((IProgressMonitor)mon.newChild(1));
            }
            if (!mon.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        mon.done();
    }

    protected final void load(IProgressMonitor monitor) throws TeamRepositoryException {
        List updates = this.loadTree.getFileAreaUpdates();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)215);
        this.contentSession = FileSystemCore.getContentManager(this.repo).createSession("", true, updates.size(), (IProgressMonitor)progress.newChild(155));
        HashMap<UUID, IRelativeLocation> foldersToVerify = new HashMap<UUID, IRelativeLocation>();
        HashMap<UUID, HashMap<String, UUID>> allFolderChildren = new HashMap<UUID, HashMap<String, UUID>>();
        DeferredUpdateInformation[] pathsToUpdate = new DeferredUpdateInformation[updates.size()];
        HashSet<Shareable> linksToRefresh = new HashSet<Shareable>();
        HashSet<Shareable> linksToRecompute = new HashSet<Shareable>();
        ArrayList<IShareable> shares = new ArrayList<IShareable>();
        HashSet<IShareable> inconsistentShares = new HashSet<IShareable>();
        ArrayList<IShareable> ignoresToUpdate = new ArrayList<IShareable>();
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(this.sandbox.getRoot());
        if (cfa == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_25, (Object)this.sandbox.getRoot().toString(), (Object[])new Object[0]));
        }
        try {
            int i = -1;
            HashSet<Shareable> versionablesLoaded = new HashSet<Shareable>();
            HashSet syncdChanges = new HashSet();
            HashSet<UUID> filteredItems = new HashSet<UUID>();
            CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)progress);
            LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
            for (FileAreaUpdate update : updates) {
                ResourceType shareableType;
                Shareable shareable;
                IRelativeLocation path;
                Shareable parentShareable;
                Shareable shareableLoaded;
                this.checkCancelled(monitor);
                ++i;
                IComponentHandle componentHandle = update.getComponent();
                if (!componentHandle.sameItemId((IItemHandle)this.component)) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_13, (Object)this.component.getName(), (Object[])new Object[0])));
                    break;
                }
                if (update.getChangeType() != 1) {
                    throw new IllegalStateException("Mutator is intended to only load new files/folders");
                }
                IVersionableHandle versionableState = update.afterState();
                ResourceType type = ResourceType.getResourceType(versionableState);
                boolean isShare = false;
                ILoadLocation loadLocation = this.loadLocations.get(update.getItem().getItemId());
                if (loadLocation != null) {
                    IShare share;
                    shareableLoaded = this.getExistingShareable(cfa, update.getItem(), (IProgressMonitor)cMon);
                    parentShareable = update.getDestinationParent() == null ? null : this.getExistingShareable(cfa, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)cMon);
                    if (parentShareable == null) {
                        isShare = true;
                        path = loadLocation.getLoadPath();
                        shareable = new Shareable(this.sandbox, path, type);
                        Shareable localParent = new Shareable(this.sandbox, path.getParent(), ResourceType.FOLDER);
                        if (!localParent.exists((IProgressMonitor)progress.newChild(1))) {
                            SharingManager.getInstance().disableChangeMonitoring();
                            try {
                                localParent.getFileStorage().create(true, null, (IProgressMonitor)cMon);
                            }
                            finally {
                                SharingManager.getInstance().enableChangeMonitoring();
                            }
                        }
                    } else {
                        path = parentShareable.getLocalPath().append(update.getName());
                        shareable = new Shareable(this.sandbox, path, type);
                    }
                    ArrayList<IShare> sharesToRefresh = new ArrayList<IShare>(2);
                    if (shareable.exists((IProgressMonitor)cMon) && (share = shareable.getShare((IProgressMonitor)cMon)) != null && !syncdChanges.contains(share.getShareable())) {
                        sharesToRefresh.add(share);
                    }
                    if (shareableLoaded != null && (share = shareableLoaded.getShare((IProgressMonitor)cMon)) != null && !syncdChanges.contains(share.getShareable())) {
                        sharesToRefresh.add(share);
                    }
                    if (!sharesToRefresh.isEmpty()) {
                        localChangeManager.refreshChanges(sharesToRefresh.toArray(new IShare[sharesToRefresh.size()]), ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)cMon);
                    }
                } else {
                    shareableLoaded = this.getExistingShareable(cfa, update.getItem(), (IProgressMonitor)cMon);
                    parentShareable = this.getExistingShareable(cfa, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)cMon);
                    if (parentShareable == null) {
                        if (filteredItems.contains(update.getDestinationParent().getItemId())) {
                            filteredItems.add(update.getItem().getItemId());
                        } else {
                            this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_19, (Object)update.getName(), (Object[])new Object[0]), null));
                        }
                        if (shareableLoaded == null) continue;
                        MergeLoadMutator.deleteSubtree(shareableLoaded, type, this.shed, (IProgressMonitor)cMon);
                        shareableLoaded.forget((IProgressMonitor)cMon);
                        continue;
                    }
                    if (this.filter != null && !this.filter.include(update.getName())) {
                        filteredItems.add(update.getItem().getItemId());
                        continue;
                    }
                    path = parentShareable.getLocalPath().append(update.getName());
                    shareable = new Shareable(this.sandbox, path, type);
                    HashMap<String, UUID> contents = allFolderChildren.get(update.getDestinationParent().getItemId());
                    if (contents != null) {
                        contents.put(update.getName(), update.getItem().getItemId());
                    }
                }
                if (isShare) {
                    shares.add(shareable);
                }
                if (shareableLoaded != null) {
                    if (isShare != shareableLoaded.isShare((IProgressMonitor)cMon)) {
                        MergeLoadMutator.deleteSubtree(shareableLoaded, type, this.shed, (IProgressMonitor)cMon);
                        shareableLoaded.forget((IProgressMonitor)cMon);
                    } else {
                        IShareable existingParent = shareableLoaded.getParent();
                        if (existingParent == null && parentShareable != null || existingParent != null && update.parent() == null && existingParent.getRemote((IProgressMonitor)cMon) != null || existingParent != null && update.parent() != null && !update.parent().sameItemId((IItemHandle)existingParent.getRemote((IProgressMonitor)cMon)) || !shareable.getLocalPath().getName().equals(shareableLoaded.getLocalPath().getName()) || isShare && !shareable.getLocalPath().equals(shareableLoaded.getLocalPath())) {
                            MergeLoadMutator.deleteSubtree(shareableLoaded, type, this.shed, (IProgressMonitor)cMon);
                            shareableLoaded.forget((IProgressMonitor)cMon);
                        }
                    }
                } else {
                    SharingManager.getInstance().forget(this.sandbox.getRoot(), this.connectionHandle, (IComponentHandle)this.component, update.getItem(), (IProgressMonitor)cMon);
                }
                if (!this.sandbox.isCaseSensitive()) {
                    if (versionablesLoaded.contains(shareable)) {
                        this.recordInconsistentShare(shareable, inconsistentShares, (IProgressMonitor)cMon);
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_20, (Object)path, (Object[])new Object[0]), null));
                        continue;
                    }
                    versionablesLoaded.add(shareable);
                }
                if ((shareableType = shareable.getResourceType((IProgressMonitor)cMon)) == null) {
                    if (type == ResourceType.FOLDER) {
                        this.createNewFolder(cfa, isShare, shareable, update, (IProgressMonitor)cMon);
                        if (update.getDestinationParent() != null && allFolderChildren.containsKey(update.getDestinationParent().getItemId())) {
                            allFolderChildren.put(versionableState.getItemId(), new HashMap());
                        }
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (type == ResourceType.FILE) {
                        pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, isShare, null);
                        this.createNewFile(pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    if (type != ResourceType.SYMBOLIC_LINK) continue;
                    this.createNewLink(cfa, isShare, shareable, update, linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                IVersionableHandle oldVersionable = shareable.getRemote((IProgressMonitor)cMon);
                boolean typesMatch = shareableType == type;
                IFileStorage fs = shareable.getFileStorage();
                boolean namesMatch = path.getName().equals(fs.getActualName());
                if (!(typesMatch && (oldVersionable == null || versionableState.sameItemId((IItemHandle)oldVersionable)) && (this.sandbox.isCaseSensitive() || fs.storageExists((IProgressMonitor)cMon) && namesMatch))) {
                    MergeLoadMutator.deleteSubtree(shareable, shareableType, this.shed, (IProgressMonitor)cMon);
                    shareable.forget((IProgressMonitor)cMon);
                    if (!typesMatch || !this.sandbox.isCaseSensitive() && !namesMatch) {
                        shareable = new Shareable(shareable.getSandbox(), path, type);
                    }
                    if (type == ResourceType.FOLDER) {
                        this.createNewFolder(cfa, isShare, shareable, update, (IProgressMonitor)cMon);
                        if (update.getDestinationParent() != null && allFolderChildren.containsKey(update.getDestinationParent().getItemId())) {
                            allFolderChildren.put(versionableState.getItemId(), new HashMap());
                        }
                        this.contentSession.decrementTransferCount(1L);
                    } else if (type == ResourceType.FILE) {
                        pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, isShare, null);
                        this.createNewFile(pathsToUpdate[i], (IProgressMonitor)cMon);
                    } else if (type == ResourceType.SYMBOLIC_LINK) {
                        this.createNewLink(cfa, isShare, shareable, update, linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                        this.contentSession.decrementTransferCount(1L);
                    }
                } else {
                    FileItemInfo proxy;
                    InverseFileItemInfo inverseInfo;
                    boolean isDirty;
                    boolean bl = isDirty = !versionableState.sameStateId((IItemHandle)oldVersionable);
                    if (type == ResourceType.FILE) {
                        isDirty |= localChangeManager.isContentDirty(shareable, (IProgressMonitor)cMon);
                        ILocalChange change = localChangeManager.getPendingChange(shareable, (IProgressMonitor)cMon);
                        isDirty |= change != null && change.getType() != 0;
                    } else if (type == ResourceType.FOLDER) {
                        foldersToVerify.put(versionableState.getItemId(), path);
                        allFolderChildren.put(versionableState.getItemId(), new HashMap());
                    } else if (type == ResourceType.SYMBOLIC_LINK) {
                        LinkInfo oldTargetInfo = shareable.getFileStorage().getLinkInfo((IProgressMonitor)cMon);
                        String remoteTarget = update.getLinkTarget();
                        remoteTarget = shareable.getFileStorage().convertTargetIntoLocalForm(remoteTarget);
                        boolean remoteIsDirectoryLink = update.isDirectoryLink();
                        String localTarget = oldTargetInfo.getTarget();
                        boolean localIsDirectoryLink = false;
                        if (oldTargetInfo.getType() == LinkType.NONE) {
                            FileItemInfo existingInfo = shareable.getFileItemInfo((IProgressMonitor)progress.newChild(1));
                            if (existingInfo != null) {
                                localIsDirectoryLink = existingInfo.isDirectoryLink();
                            }
                        } else {
                            localIsDirectoryLink = oldTargetInfo.getType() == LinkType.DIRECTORY;
                        }
                        isDirty = !remoteTarget.equals(localTarget) || remoteIsDirectoryLink != localIsDirectoryLink;
                    }
                    boolean propertiesNeedUpdate = isDirty;
                    if (!isDirty && (inverseInfo = cfa.getItemInfo(versionableState, componentHandle, this.connectionHandle, false)) != null) {
                        propertiesNeedUpdate |= !inverseInfo.getChangedProperties().isEmpty();
                        propertiesNeedUpdate |= !inverseInfo.getRemovedProperties().isEmpty();
                    }
                    if (isDirty || propertiesNeedUpdate) {
                        if (isShare) {
                            SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, versionableState, this.getClientDataForSharingDescriptor());
                            if (!isDirty && propertiesNeedUpdate) {
                                MetadataProperties properties = new MetadataProperties(update.getMetadataProperties());
                                cfa.setProperties(this.connectionHandle, (IComponentHandle)this.component, versionableState, properties, (IProgressMonitor)cMon);
                            } else if (type == ResourceType.FOLDER) {
                                FileItemInfo proxy2 = new FileItemInfoProxy((IVersionableHandle)((IFolderHandle)versionableState), update.getDestinationParent(), update.getName(), PathUtils.isLoadedWithAnotherName(this.sandbox, path, update.getName())).getFileItemInfo();
                                SharingManager.getInstance().share(shareable, descriptor, proxy2, new MetadataProperties(update.getMetadataProperties()), 2, (IProgressMonitor)cMon);
                                this.contentSession.decrementTransferCount(1L);
                            } else if (type == ResourceType.FILE) {
                                FileItemInfo proxy3 = cfa.getItemInfo(path);
                                if (isDirty) {
                                    Date existingFileModificationTime = new Date(shareable.getFileStorage().getLocalTimeStamp());
                                    SharingManager.getInstance().share(shareable, descriptor, proxy3, null, 2, (IProgressMonitor)cMon);
                                    pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, false, existingFileModificationTime);
                                    this.modifyFile(shareable, pathsToUpdate[i], this.component, inconsistentShares, (IProgressMonitor)cMon);
                                }
                            } else if (type == ResourceType.SYMBOLIC_LINK && isDirty) {
                                this.modifyLink(cfa, isShare, versionableState, update, shareable, this.loadLocations.containsKey(update.getItem().getItemId()), linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                            }
                        } else if (type == ResourceType.FOLDER) {
                            proxy = new FileItemInfoProxy((IVersionableHandle)((IFolderHandle)versionableState), update.getDestinationParent(), update.getName()).getFileItemInfo();
                            cfa.setItemMetaData(shareable.getLocalPath(), proxy, ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(update.getMetadataProperties()), (IProgressMonitor)cMon);
                            this.contentSession.decrementTransferCount(1L);
                        } else if (type == ResourceType.FILE) {
                            Date existingFileModificationTime = new Date(shareable.getFileStorage().getLocalTimeStamp());
                            pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, isShare, existingFileModificationTime);
                            this.modifyFile(shareable, pathsToUpdate[i], this.component, inconsistentShares, (IProgressMonitor)cMon);
                        } else if (type == ResourceType.SYMBOLIC_LINK) {
                            this.modifyLink(cfa, isShare, versionableState, update, shareable, this.loadLocations.containsKey(update.getItem().getItemId()), linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                            linksToRefresh.add(shareable);
                        }
                    } else if (isShare) {
                        proxy = cfa.getItemInfo(path);
                        assert (proxy != null);
                        SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, versionableState, this.getClientDataForSharingDescriptor());
                        SharingManager.getInstance().share(shareable, descriptor, proxy, null, 2, (IProgressMonitor)cMon);
                        this.contentSession.decrementTransferCount(1L);
                    } else {
                        this.contentSession.decrementTransferCount(1L);
                    }
                }
                if (!update.getName().equals(".jazzignore") || parentShareable == null) continue;
                ignoresToUpdate.add(parentShareable);
            }
        }
        finally {
            this.contentSession.join();
            try {
                if (!progress.isCanceled()) {
                    this.doDilemmaHandling(pathsToUpdate, (IProgressMonitor)progress.newChild(10));
                }
            }
            finally {
                if (progress.isCanceled()) {
                    progress.subTask(Messages.MergeLoadMutator_11);
                } else if (this.component != null) {
                    progress.subTask(NLS.bind((String)Messages.MergeLoadMutator_12, (Object)this.component.getName(), (Object[])new Object[0]));
                } else {
                    progress.subTask(Messages.MergeLoadMutator_10);
                }
                this.updateContentLoadedMetaData(cfa, pathsToUpdate, updates, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(25)));
                this.refreshLinks(linksToRefresh, linksToRecompute, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(5)));
            }
        }
        IStatus[] failures = this.getDownloadFailures(pathsToUpdate);
        if (failures.length > 0) {
            boolean seriousFailure = false;
            IStatus[] iStatusArray = failures;
            int n = failures.length;
            int filteredItems = 0;
            while (filteredItems < n) {
                IStatus failure = iStatusArray[filteredItems];
                if (failure.getSeverity() == 4 || failure.getSeverity() == 8) {
                    seriousFailure = true;
                }
                this.collectStatus(failure);
                ++filteredItems;
            }
            if (seriousFailure) {
                failures = this.getErrors();
                RepositoryUtils.throwAppropriateException(Messages.MergeLoadMutator_4, failures);
            }
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!ignoresToUpdate.isEmpty()) {
            SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(ignoresToUpdate, null);
        }
        this.removeExtraneousContent(cfa, shares, foldersToVerify, allFolderChildren, (IProgressMonitor)progress.newChild(5));
        this.removeExtraneousMetadata(cfa, allFolderChildren, (IProgressMonitor)progress.newChild(5));
        SubMonitor iterProgress = progress.newChild(5);
        iterProgress.setWorkRemaining(shares.size() * 2);
        ISyncTime syncTime = ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState());
        for (IShareable shareInfo : shares) {
            if (inconsistentShares.contains(shareInfo)) continue;
            cfa.setConfigurationState(this.connectionHandle, (IComponentHandle)this.component, shareInfo.getVersionable((IProgressMonitor)iterProgress.newChild(1)), syncTime, (IProgressMonitor)iterProgress.newChild(1));
        }
        this.handleDeletedContent(pathsToUpdate, (IProgressMonitor)progress.newChild(5));
        progress.done();
    }

    private void handleDeletedContent(DeferredUpdateInformation[] pathsToUpdate, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)pathsToUpdate.length);
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        ArrayList<IShareable> contentDeleted = new ArrayList<IShareable>();
        DeferredUpdateInformation[] deferredUpdateInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            DeferredUpdateInformation deferredUpdateInformation = deferredUpdateInformationArray[n2];
            if (deferredUpdateInformation != null && deferredUpdateInformation.contentDeleted()) {
                IShareable shareable = deferredUpdateInformation.getShareable();
                contentDeleted.add(shareable);
                try {
                    lcm.computeChanges(shareable, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemException e) {
                    LoggingHelper.log("com.ibm.team.filesystem.client", e);
                }
            }
            ++n2;
        }
        if (!contentDeleted.isEmpty()) {
            int response = this.problemHandler.deletedContent(contentDeleted);
            if (response == 1) {
                throw new OperationCanceledException();
            }
            if (response != 0) {
                for (IShareable sharable : contentDeleted) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.MergeLoadMutator_26, (Object)sharable.getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
    }

    private Map<String, byte[]> getClientDataForSharingDescriptor() {
        HashMap<String, byte[]> additionalInfo = null;
        if (this.filter != null) {
            try {
                additionalInfo = new HashMap<String, byte[]>(1);
                additionalInfo.put("com.ibm.team.filesystem.client.LoadFilter", LoadFilter.toBytes(this.filter));
            }
            catch (IOException e) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
            }
        }
        return additionalInfo;
    }

    private void recordInconsistentShare(Shareable shareable, HashSet<IShareable> inconsistentShares, IProgressMonitor monitor) throws FileSystemException {
        IShare share = shareable.getShare(monitor);
        if (share == null) {
            inconsistentShares.add(shareable);
        } else {
            inconsistentShares.add(share.getShareable());
        }
    }

    private void removeExtraneousMetadata(ICopyFileArea cfa, HashMap<UUID, HashMap<String, UUID>> allFolderChildren, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)allFolderChildren.size());
        for (Map.Entry<UUID, HashMap<String, UUID>> entry : allFolderChildren.entrySet()) {
            SubMonitor subProgress = monitor.newChild(1);
            IFolderHandle folderHandle = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)this.repo, entry.getKey(), null);
            HashMap<String, UUID> namesOfChildrenLoaded = entry.getValue();
            InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)folderHandle, (IComponentHandle)this.component, this.connectionHandle, false);
            if (info != null) {
                HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(info.getRemoteChildren());
                subProgress.setWorkRemaining(children.size());
                for (Map.Entry child : children.entrySet()) {
                    UUID childLoaded = namesOfChildrenLoaded.get(child.getKey());
                    if (childLoaded != null && ((IVersionableHandle)child.getValue()).getItemId().equals((Object)childLoaded)) continue;
                    cfa.forget(this.connectionHandle, (IComponentHandle)this.component, (IVersionableHandle)child.getValue(), (IProgressMonitor)subProgress.newChild(1));
                }
            }
            subProgress.done();
        }
    }

    private void removeExtraneousContent(ICopyFileArea cfa, ArrayList<IShareable> shares, HashMap<UUID, IRelativeLocation> foldersToVerify, HashMap<UUID, HashMap<String, UUID>> allFolderChildren, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)foldersToVerify.size());
        for (Map.Entry<UUID, IRelativeLocation> entry : foldersToVerify.entrySet()) {
            IRelativeLocation parentFolder = entry.getValue();
            HashMap<String, Object> expectedContents = allFolderChildren.get(entry.getKey());
            if (expectedContents == null) {
                expectedContents = new HashMap();
            }
            List<IShareable> actualContents = this.getActualContents(this.sandbox, parentFolder);
            SubMonitor subProgress = monitor.newChild(1);
            subProgress.setWorkRemaining(actualContents.size());
            for (IShareable child : actualContents) {
                SubMonitor subSubProgress = subProgress.newChild(1);
                subSubProgress.setWorkRemaining(100);
                if (expectedContents.containsKey(child.getLocalPath().getName())) continue;
                cfa.forget(child.getLocalPath(), (IProgressMonitor)subSubProgress.newChild(40));
                if (child.shouldBeIgnored((IProgressMonitor)subSubProgress.newChild(10))) continue;
                if (!this.isSpecialCase(child, (IProgressMonitor)subSubProgress.newChild(1))) {
                    MergeLoadMutator.deleteSubtree((Shareable)child, child.getResourceType((IProgressMonitor)subSubProgress.newChild(1)), this.shed, (IProgressMonitor)subSubProgress.newChild(48));
                    continue;
                }
                LocalChangeManager.getInstance().computeChanges(child, (IProgressMonitor)subSubProgress.newChild(49));
            }
        }
    }

    protected List<IShareable> getActualContents(ISandbox sandbox, IRelativeLocation parentFolder) {
        File folder = (File)sandbox.getRoot().append(parentFolder).getAdapter(File.class);
        File[] members = folder.listFiles();
        if (members != null) {
            ArrayList<IShareable> actualContents = new ArrayList<IShareable>(members.length);
            int i = 0;
            while (i < members.length) {
                actualContents.add(SharingManager.getInstance().findShareable(sandbox, parentFolder.append(members[i].getName()), members[i].isDirectory() ? ResourceType.FOLDER : ResourceType.FILE));
                ++i;
            }
            return actualContents;
        }
        return Collections.EMPTY_LIST;
    }

    private void doDilemmaHandling(DeferredUpdateInformation[] pathsToUpdate, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        ArrayList<EncodingDownloadFailure> encodingFailures = new ArrayList<EncodingDownloadFailure>();
        DeferredUpdateInformation[] deferredUpdateInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            DeferredUpdateInformation deferredUpdateInformation = deferredUpdateInformationArray[n2];
            if (deferredUpdateInformation != null && deferredUpdateInformation.getFailure() != null) {
                Throwable rootCause = deferredUpdateInformation.getFailure();
                int digParanoiaCount = 0;
                while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                    if (cause == null) break;
                    rootCause = cause;
                    ++digParanoiaCount;
                }
                if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                    encodingFailures.add(new EncodingDownloadFailure(deferredUpdateInformation));
                } else if (rootCause instanceof CharacterCodingException) {
                    encodingFailures.add(new EncodingDownloadFailure(deferredUpdateInformation));
                } else if (rootCause instanceof OperationCanceledException) {
                    throw new OperationCanceledException();
                }
            }
            ++n2;
        }
        if (encodingFailures.size() > 0) {
            for (EncodingDownloadFailure failure : encodingFailures) {
                failure.setIgnoreEncoding(true);
            }
            boolean moreContentUploaded = false;
            this.contentSession = FileSystemCore.getContentManager(this.repo).createSession("", true, encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            try {
                for (EncodingDownloadFailure failure : encodingFailures) {
                    if (!failure.hasDirection()) continue;
                    DeferredUpdateInformation info = (DeferredUpdateInformation)failure.getDeferredUpdateInformation();
                    IVersionableHandle fileItemState = info.getFileItemState();
                    this.contentSession.retrieveContent((IFileItemHandle)fileItemState, info.getContent(), info.getEncoding(), info.getLineDelimiter(), new DownloadHandler(info, this));
                    moreContentUploaded = true;
                }
            }
            finally {
                if (moreContentUploaded) {
                    this.contentSession.join();
                }
            }
            SubMonitor iterProgress = progress.newChild(25);
            iterProgress.setWorkRemaining(encodingFailures.size());
            for (EncodingDownloadFailure failure : encodingFailures) {
                if (!failure.getDeferredUpdateInformation().isLineDelimiterIgnored() || failure.getDeferredUpdateInformation().getFailure() != null) continue;
                failure.getDeferredUpdateInformation().convert((IProgressMonitor)iterProgress.newChild(1));
            }
        }
    }

    protected void createNewLink(ICopyFileArea copyFileArea, boolean isShare, Shareable shareable, FileAreaUpdate update, HashSet<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setTaskName(Messages.MergeLoadMutator_15);
        ISandbox sandbox = shareable.getSandbox();
        IRelativeLocation path = shareable.getLocalPath();
        String originalTarget = update.getLinkTarget();
        final boolean isDirectory = update.isDirectoryLink();
        final IFileStorage fileStorage = shareable.getFileStorage();
        final String target = fileStorage.convertTargetIntoLocalForm(originalTarget);
        if (fileStorage != null) {
            if (fileStorage.supportSymbolicLinks()) {
                final IStatus[] warning = new IStatus[]{null};
                SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                    @Override
                    public void run() throws FileSystemException {
                        try {
                            fileStorage.create(target == null ? "" : target, isDirectory, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (FileSystemException e) {
                            warning[0] = MergeLoadMutator.this.getSymlinkWarning(e);
                        }
                    }
                });
                if (warning[0] == null) {
                    linksToRefresh.add(shareable);
                } else {
                    linksToRecompute.add(shareable);
                    Status highLevelStatus = new Status(warning[0].getSeverity(), warning[0].getPlugin(), NLS.bind((String)Messages.MergeLoadMutator_27, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{warning[0].getMessage()}));
                    this.collectStatus((IStatus)highLevelStatus);
                }
            } else {
                linksToRecompute.add(shareable);
                this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.MergeLoadMutator_21, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{target}), null));
            }
            ISymbolicLinkHandle versionableState = (ISymbolicLinkHandle)update.afterState();
            MetadataProperties properties = new MetadataProperties(update.getMetadataProperties());
            if (isShare) {
                FileItemInfoProxy proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, update.parent(), update.getName(), PathUtils.isLoadedWithAnotherName(sandbox, path, update.getName()));
                proxy.setTarget(fileStorage.getModificationStamp(), originalTarget, target, isDirectory);
                SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, (IVersionableHandle)versionableState, this.getClientDataForSharingDescriptor());
                SharingManager.getInstance().share(shareable, descriptor, proxy.getFileItemInfo(), properties, 2, (IProgressMonitor)progress.newChild(1));
            } else {
                FileItemInfo parentInfo = copyFileArea.getItemInfo(path.getParent());
                FileItemInfoProxy proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, (IFolderHandle)parentInfo.getVersionableHandle(), update.getName());
                proxy.setTarget(fileStorage.getModificationStamp(), originalTarget, target, isDirectory);
                copyFileArea.setItemMetaData(shareable.getLocalPath(), proxy.getFileItemInfo(), ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)progress.newChild(1));
            }
        }
        monitor.done();
        this.checkCancelled(monitor);
    }

    private IStatus getSymlinkWarning(FileSystemException e) throws FileSystemException {
        if (!(e.getCause() instanceof CoreException)) {
            throw e;
        }
        CoreException ce = (CoreException)e.getCause();
        IStatus status = ce.getStatus();
        if (status.getSeverity() != 2 && status.getSeverity() != 1) {
            throw e;
        }
        return ce.getStatus();
    }

    private void modifyLink(ICopyFileArea copyFileArea, boolean isShare, IVersionableHandle symbolicLinkHandle, FileAreaUpdate updateInfo, Shareable shareable, boolean isUndo, HashSet<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean isDirectory = updateInfo.isDirectoryLink();
        this.shed.forceBackup(shareable, (IProgressMonitor)monitor);
        IFileStorage linkStorage = shareable.getFileStorage();
        String linkTarget = linkStorage.convertTargetIntoLocalForm(updateInfo.getLinkTarget());
        if (linkStorage.supportSymbolicLinks()) {
            IStatus warning;
            block14: {
                warning = null;
                SharingManager.getInstance().disableChangeMonitoring();
                try {
                    try {
                        linkStorage.setTarget(this.shed, linkTarget == null ? "" : linkTarget, isDirectory, (IProgressMonitor)monitor.newChild(50));
                    }
                    catch (FileSystemException e) {
                        warning = this.getSymlinkWarning(e);
                        SharingManager.getInstance().enableChangeMonitoring();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    SharingManager.getInstance().enableChangeMonitoring();
                    throw throwable;
                }
                SharingManager.getInstance().enableChangeMonitoring();
            }
            if (warning == null) {
                linksToRefresh.add(shareable);
            } else {
                linksToRecompute.add(shareable);
                Status highLevelStatus = new Status(warning.getSeverity(), warning.getPlugin(), NLS.bind((String)Messages.MergeLoadMutator_27, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{warning.getMessage()}));
                this.collectStatus((IStatus)highLevelStatus);
            }
        } else {
            linksToRecompute.add(shareable);
            this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.MergeLoadMutator_22, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{linkTarget}), null));
        }
        InverseFileItemInfo oldInfo = copyFileArea.getItemInfo(symbolicLinkHandle, (IComponentHandle)this.component, this.connectionHandle, false);
        IFolderHandle parent = null;
        String name = null;
        boolean loadedWithAnotherName = false;
        if (isUndo && oldInfo != null) {
            parent = oldInfo.getParent();
            name = oldInfo.getName();
            loadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
        } else {
            parent = updateInfo.parent();
            name = updateInfo.getName();
            if (isShare) {
                loadedWithAnotherName = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), name);
            }
        }
        FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(symbolicLinkHandle, parent, name, loadedWithAnotherName);
        newInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), updateInfo.getLinkTarget(), linkTarget, isDirectory);
        FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
        MetadataProperties properties = new MetadataProperties(updateInfo.getMetadataProperties());
        if (isShare) {
            SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, symbolicLinkHandle, this.getClientDataForSharingDescriptor());
            SharingManager.getInstance().share(shareable, descriptor, newInfo, properties, 2, (IProgressMonitor)monitor.newChild(10));
        } else {
            copyFileArea.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)monitor.newChild(10));
        }
    }

    protected boolean isSpecialCase(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        return false;
    }

    private IStatus[] getDownloadFailures(DeferredUpdateInformation[] pathsToUpdate) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        boolean reportedSupportedCharSets = false;
        DeferredUpdateInformation[] deferredUpdateInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IStatus status;
                DeferredUpdateInformation deferredUpdateInformation;
                block8: {
                    block10: {
                        Throwable rootCause;
                        block11: {
                            block9: {
                                deferredUpdateInformation = deferredUpdateInformationArray[n2];
                                if (deferredUpdateInformation == null) break block7;
                                if (deferredUpdateInformation.getFailure() == null) break block8;
                                rootCause = deferredUpdateInformation.getFailure();
                                int paranoiaCount = 0;
                                while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                                    if (cause == null) break;
                                    rootCause = cause;
                                    ++paranoiaCount;
                                }
                                if (!(rootCause instanceof UnsupportedEncodingException) && !(rootCause instanceof UnsupportedCharsetException)) break block9;
                                if (!reportedSupportedCharSets) {
                                    StringBuffer charSetsAvailable = new StringBuffer();
                                    for (String charsetName : Charset.availableCharsets().keySet()) {
                                        charSetsAvailable.append(charsetName).append(' ');
                                    }
                                    IStatus infoStatus = FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.MergeLoadMutator_3, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                                    errors.add(infoStatus);
                                    reportedSupportedCharSets = true;
                                }
                                status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_5, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), deferredUpdateInformation.getFailure());
                                break block10;
                            }
                            if (!(rootCause instanceof CharacterCodingException)) break block11;
                            status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_1, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), deferredUpdateInformation.getFailure());
                            break block10;
                        }
                        if (rootCause instanceof OperationCanceledException) break block7;
                        status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_6, (Object)deferredUpdateInformation.getPath(), (Object[])new Object[0]), deferredUpdateInformation.getFailure());
                    }
                    errors.add(status);
                    break block7;
                }
                if (deferredUpdateInformation.isLineDelimiterIgnored()) {
                    IFileContent contentInfo = deferredUpdateInformation.getFileAreaUpdate().getOptionalContent();
                    status = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.MergeLoadMutator_23, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{contentInfo.getCharacterEncoding(), contentInfo.getLineDelimiter().toString()}));
                    errors.add(status);
                }
            }
            ++n2;
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    private void updateContentLoadedMetaData(ICopyFileArea cfa, DeferredUpdateInformation[] pathsToUpdate, List<FileAreaUpdate> updates, IProgressMonitor progress) throws FileSystemException {
        Shareable shareable;
        FileAreaUpdate update;
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(pathsToUpdate.length * 2 + 10));
        Shareable[] shareablesForUpdate = new Shareable[pathsToUpdate.length];
        int i = 0;
        while (i < pathsToUpdate.length) {
            if (pathsToUpdate[i] == null || !pathsToUpdate[i].contentUpdated()) {
                subProgress.worked(1);
            } else {
                update = updates.get(i);
                shareablesForUpdate[i] = shareable = new Shareable(pathsToUpdate[i].getSandbox(), pathsToUpdate[i].getPath(), ResourceType.getResourceType(update.afterState()));
                this.refresh(shareable, 0, (IProgressMonitor)subProgress.newChild(1));
            }
            ++i;
        }
        i = 0;
        while (i < pathsToUpdate.length) {
            if (pathsToUpdate[i] == null || !pathsToUpdate[i].contentUpdated()) {
                subProgress.worked(1);
            } else {
                update = updates.get(i);
                shareable = shareablesForUpdate[i];
                if (shareable == null) {
                    shareablesForUpdate[i] = shareable = new Shareable(pathsToUpdate[i].getSandbox(), pathsToUpdate[i].getPath(), ResourceType.getResourceType(update.afterState()));
                }
                this.updateMetaInfoForPath(cfa, update.getComponent(), update.afterState(), shareable, pathsToUpdate[i], (IProgressMonitor)subProgress.newChild(1));
            }
            ++i;
        }
        this.contentLoadCompleted((IProgressMonitor)subProgress.newChild(10));
        subProgress.done();
    }

    private void refreshLinks(Set<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(linksToRefresh.size() + linksToRecompute.size()));
        for (Shareable shareable : linksToRefresh) {
            try {
                new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException fileSystemException) {}
        }
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        for (Shareable shareable : linksToRecompute) {
            try {
                lcm.computeChanges(shareable, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException fileSystemException) {}
        }
    }

    private void refresh(Shareable shareable, final int depth, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                    @Override
                    public void run() throws FileSystemException {
                        file.refreshCachedSubTree(depth, (IProgressMonitor)new SilentProgressMonitor((IProgressMonitor)progress.newChild(100)));
                    }
                });
            }
            catch (FileSystemException e) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
        }
    }

    private void updateMetaInfoForPath(ICopyFileArea copyFileArea, IComponentHandle componentHandle, IVersionableHandle fileItem, Shareable shareable, DeferredUpdateInformation updateInfo, IProgressMonitor monitor) throws FileSystemException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        IFileStorage file = shareable.getFileStorage();
        IFolderHandle parent = updateInfo.getRemoteParent();
        String name = updateInfo.getRemoteName();
        boolean loadedWithAnotherName = false;
        if (updateInfo.isShare()) {
            loadedWithAnotherName = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), updateInfo.getPath(), name);
        }
        FileContent content = (FileContent)updateInfo.getContent();
        FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(fileItem, parent, name, loadedWithAnotherName);
        newInfoProxy.setContentInfo(file.getModificationStamp(), updateInfo.getHash(), updateInfo.getContentSize(), content);
        newInfoProxy.setExecutable(updateInfo.isExecutable(), updateInfo.isExecutable());
        newInfoProxy.setContentType(updateInfo.getFileAreaUpdate().getContentType());
        FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
        MetadataProperties properties = updateInfo.getMetadataProperties();
        if (updateInfo.isShare()) {
            SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, fileItem, this.getClientDataForSharingDescriptor());
            SharingManager.getInstance().share(shareable, descriptor, newInfo, properties, 2, (IProgressMonitor)progress.newChild(10));
        } else {
            copyFileArea.setItemMetaData(updateInfo.getPath(), newInfo, ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)progress.newChild(10));
        }
        file.setExecutable(updateInfo.isExecutable(), (IProgressMonitor)progress.newChild(10));
        this.contentLoadCompleted(shareable, (IProgressMonitor)progress.newChild(30));
        progress.done();
    }

    protected void contentLoadCompleted(Shareable shareable, IProgressMonitor progress) throws FileSystemException {
    }

    protected void contentLoadCompleted(IProgressMonitor progress) throws FileSystemException {
    }

    private Shareable getExistingShareable(ICopyFileArea copyFileArea, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemException {
        IRelativeLocation path = copyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)this.component, item, monitor);
        return path == null ? null : new Shareable(this.sandbox, path, ResourceType.getResourceType(item));
    }

    protected void createNewFile(DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (deferredUpdateInformation.getContent() != null) {
            this.contentSession.retrieveContent((IFileItemHandle)deferredUpdateInformation.getFileItemState(), deferredUpdateInformation.getContent(), new DownloadHandler(deferredUpdateInformation, this));
        } else {
            this.storeFileContents(deferredUpdateInformation, deferredUpdateInformation.getContent(), new ByteArrayInputStream(new byte[0]));
            File localFile = (File)deferredUpdateInformation.getShareable().getAdapter(File.class);
            deferredUpdateInformation.processModificationStamp(localFile);
        }
    }

    protected void createNewFolder(ICopyFileArea copyFileArea, boolean isShare, Shareable shareable, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setTaskName(Messages.MergeLoadMutator_15);
        ISandbox sandbox = shareable.getSandbox();
        IRelativeLocation path = shareable.getLocalPath();
        final IFileStorage fileStorage = shareable.getFileStorage();
        if (fileStorage != null) {
            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                @Override
                public void run() throws FileSystemException {
                    fileStorage.create(false, null, (IProgressMonitor)progress.newChild(1));
                }
            });
            IFolderHandle versionableState = (IFolderHandle)update.afterState();
            MetadataProperties properties = new MetadataProperties(update.getMetadataProperties());
            if (isShare) {
                FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, update.parent(), update.getName(), PathUtils.isLoadedWithAnotherName(sandbox, path, update.getName())).getFileItemInfo();
                SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, (IVersionableHandle)versionableState, this.getClientDataForSharingDescriptor());
                SharingManager.getInstance().share(shareable, descriptor, proxy, properties, 2, (IProgressMonitor)progress.newChild(1));
            } else {
                FileItemInfo parentInfo = copyFileArea.getItemInfo(path.getParent());
                if (parentInfo == null) {
                    throw new IllegalStateException(NLS.bind((String)"Metadata is missing for parent of {0}", (Object)path.toString(), (Object[])new Object[0]));
                }
                FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, (IFolderHandle)parentInfo.getVersionableHandle(), update.getName()).getFileItemInfo();
                copyFileArea.setItemMetaData(shareable.getLocalPath(), proxy, ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)progress.newChild(1));
            }
        }
        monitor.done();
        this.checkCancelled(monitor);
    }

    protected static void deleteSubtree(final Shareable shareable, final ResourceType typeHint, final Shed backupShed, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

            @Override
            public void run() throws FileSystemException {
                IFileStorage fileStorage = null;
                if (shareable.getFileStorage().storageExists((IProgressMonitor)monitor.newChild(1))) {
                    fileStorage = shareable.getFileStorage();
                } else if (!shareable.getSandbox().isCaseSensitive()) {
                    IFileStorage parentStorage = shareable.getFileStorage().getParent();
                    if (parentStorage != null) {
                        fileStorage = parentStorage.getChild(shareable.getLocalPath().getName(), (IProgressMonitor)monitor.newChild(1));
                        if (fileStorage != null && !fileStorage.storageExists((IProgressMonitor)monitor.newChild(1))) {
                            fileStorage = null;
                        }
                    } else {
                        ILocation parentPath = shareable.getFullPath().getParent();
                        File parentFile = (File)parentPath.getAdapter(File.class);
                        String[] childrenNames = parentFile.list();
                        if (childrenNames != null) {
                            String name = shareable.getLocalPath().getName().toUpperCase().toLowerCase();
                            String[] stringArray = childrenNames;
                            int n = childrenNames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Shareable realShareable;
                                String childName = stringArray[n2];
                                if (childName.length() == name.length() && childName.toUpperCase().toLowerCase().equals(name) && (realShareable = (Shareable)SharingManager.getInstance().findShareable(parentPath.append(childName), typeHint)) != null) {
                                    fileStorage = realShareable.getFileStorage();
                                }
                                ++n2;
                            }
                        }
                    }
                }
                if (fileStorage == null) {
                    fileStorage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), shareable.getLocalPath(), typeHint);
                }
                fileStorage.delete(backupShed, (IProgressMonitor)monitor.newChild(50));
            }
        });
    }

    protected void modifyFile(Shareable shareable, DeferredUpdateInformation deferredUpdateInformation, IComponent component, HashSet<IShareable> inconsistentShares, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.shed.forceBackup(shareable, (IProgressMonitor)progress.newChild(99));
        }
        catch (FileSystemException fileSystemException) {
            this.recordInconsistentShare(shareable, inconsistentShares, (IProgressMonitor)progress.newChild(1));
            this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_24, (Object)shareable.getLocalPath(), (Object[])new Object[]{component.getName()}), null));
            return;
        }
        IVersionableHandle fileItem = deferredUpdateInformation.getFileItemState();
        this.contentSession.retrieveContent((IFileItemHandle)fileItem, deferredUpdateInformation.getContent(), new DownloadHandler(deferredUpdateInformation, this));
    }

    protected void deleteIncompleteFile(final ILocation copyFileAreaRoot, final IRelativeLocation path) throws FileSystemException {
        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

            @Override
            public void run() throws FileSystemException {
                File file = (File)copyFileAreaRoot.append(path).getAdapter(File.class);
                if (!file.exists()) {
                    return;
                }
                if (!file.delete()) {
                    throw new FileSystemException(NLS.bind((String)Messages.MergeLoadMutator_0, (Object)path, (Object[])new Object[0]));
                }
            }
        });
    }

    private ContentMeta storeFileContents(final DeferredUpdateInformation deferredUpdateInformation, final IFileContent content, final InputStream in) throws TeamRepositoryException {
        final ContentMeta[] result = new ContentMeta[1];
        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemRunnable(){

            @Override
            public void run() throws TeamRepositoryException {
                ILocation copyFileAreaRoot = deferredUpdateInformation.getSandbox().getRoot();
                IRelativeLocation path = deferredUpdateInformation.getPath();
                if (MergeLoadMutator.this.downloadMonitor != null) {
                    if (content != null) {
                        MergeLoadMutator.this.downloadMonitor.downloadStarted(copyFileAreaRoot, path, content.getEstimatedConvertedLength());
                    } else {
                        MergeLoadMutator.this.downloadMonitor.downloadStarted(copyFileAreaRoot, path, 0L);
                    }
                }
                try {
                    ILocation location = copyFileAreaRoot.append(path);
                    OutputStream out = MergeLoadMutator.this.getFileOutputStream(location);
                    try {
                        IFileOptions fileOptions = FileOptionsFactory.getFileOptions(true, deferredUpdateInformation.getLineDelimiter(), deferredUpdateInformation.getEncoding(), deferredUpdateInformation.getFileAreaUpdate().getMetadataProperties());
                        DigestComputingInputStream hashComputingStream = ContentHash.getDigestComputingStream((InputStream)LocalFileStorage.getFileAccessExtension().prepareContentsToSet(fileOptions, in));
                        ContentManager.read((InputStream)hashComputingStream, (OutputStream)out);
                        result[0] = new ContentMeta(ContentHash.valueOf((byte[])hashComputingStream.getFinalDigest()), hashComputingStream.getContentSize());
                    }
                    catch (Throwable throwable) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (SecurityException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.MergeLoadMutator_8, (Object)path, (Object[])new Object[]{e.getMessage()}), e);
                }
                catch (SocketException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.MergeLoadMutator_7, (Object)path, (Object[])new Object[]{e.getMessage()}), e);
                }
                catch (IOException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.MergeLoadMutator_8, (Object)path, (Object[])new Object[]{e.getMessage()}), e);
                }
            }
        });
        return result[0];
    }

    protected OutputStream getFileOutputStream(ILocation location) throws IOException {
        FileOutputStream out;
        File file = (File)location.getAdapter(File.class);
        try {
            out = new FileOutputStream(file);
        }
        catch (IOException e) {
            if (!file.canWrite()) {
                file.setWritable(true, true);
                file.getParentFile().setWritable(true, true);
                out = new FileOutputStream(file);
            }
            throw e;
        }
        return out;
    }

    @Override
    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemStatusException {
        if (errors.length == 0) {
            return;
        }
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.MergeLoadMutator_9, (Object)errors.length, (Object[])new Object[0]), null);
        throw new FileSystemStatusException((IStatus)result);
    }

    private static void deleteShare(IShare share, Shed backupShed, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        IShareable shareable = share.getShareable();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        MergeLoadMutator.deleteSubtree((Shareable)shareable, ResourceType.getResourceType(share.getSharingDescriptor().getRootVersionable()), backupShed, (IProgressMonitor)monitor.newChild(75));
        SharingManager.getInstance().forget((Shareable)shareable, (IProgressMonitor)monitor.newChild(25));
    }

    @Override
    public InputStream prepareContentsToSet(IFileOptions fileOptions, InputStream in) throws FileSystemException {
        return LocalFileStorage.getFileAccessExtension().prepareContentsToSet(fileOptions, in);
    }

    protected static class DownloadHandler
    extends FileDownloadHandler {
        DeferredUpdateInformation deferredUpdateInformation;
        MergeLoadMutator mutator;

        public DownloadHandler(DeferredUpdateInformation deferredUpdateInformation, MergeLoadMutator mutator) {
            this.deferredUpdateInformation = deferredUpdateInformation;
            this.mutator = mutator;
        }

        @Override
        public void downloadStreamAcquired(IFileItemHandle h, IFileContent content, InputStream in) throws TeamRepositoryException {
            boolean completed = false;
            try {
                this.deferredUpdateInformation.reset();
                ContentMeta contentStats = this.mutator.storeFileContents(this.deferredUpdateInformation, content, in);
                completed = true;
                this.deferredUpdateInformation.setContentUpdated(contentStats.getHash(), contentStats.getLength());
                File localFile = (File)this.deferredUpdateInformation.getShareable().getAdapter(File.class);
                this.deferredUpdateInformation.processModificationStamp(localFile);
            }
            finally {
                if (!completed) {
                    this.mutator.deleteIncompleteFile(this.deferredUpdateInformation.getSandbox().getRoot(), this.deferredUpdateInformation.getPath());
                }
            }
        }

        @Override
        public void downloadFailed(IFileItemHandle h, IFileContent content, Exception e) {
            this.deferredUpdateInformation.setFailure(e);
            if (DeletedContent.isRootCauseDeletedContent(e)) {
                InputStream in = DeletedContent.getDeletedContentInputStream(this.deferredUpdateInformation.getEncoding());
                try {
                    this.downloadStreamAcquired(h, content, in);
                    this.deferredUpdateInformation.setContentUpdated(content.getHash(), content.getRawLength());
                    this.deferredUpdateInformation.setContentDeleted();
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    this.deferredUpdateInformation.setFailure(e);
                }
            }
        }
    }
}

