/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemovedShare
implements IRemovedShare {
    private final int uncommittedChangeCount;
    private final IShare share;
    private boolean toDelete;

    public RemovedShare(IShare share, IProgressMonitor monitor) throws FileSystemException {
        this.share = share;
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        LocalChangeManager.getInstance().refreshChanges(new IShare[]{share}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
        this.uncommittedChangeCount = lcm.getPendingChanges(new IShare[]{share}).length;
        this.toDelete = false;
    }

    @Override
    public boolean isToBeDeleted() {
        return this.toDelete;
    }

    @Override
    public void isToBeDeleted(boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Override
    public int getUncommittedChangeCount() {
        return this.uncommittedChangeCount;
    }

    @Override
    public IRelativeLocation getLocalPath() {
        return this.share.getPath();
    }

    @Override
    public ILocation getFullPath() {
        return this.share.getSandbox().getRoot().append(this.share.getPath());
    }

    public int hashCode() {
        int result = 1;
        result *= 31;
        result = 31 * result + (this.share != null && this.share.getSandbox() != null ? this.share.getSandbox().hashCode() : 0);
        result = 31 * result + (this.share != null && this.share.getPath() != null ? this.share.getPath().hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemovedShare other = (RemovedShare)obj;
        if (this.share == null) {
            return other.share == null;
        }
        if (other.share == null) {
            return false;
        }
        if (this.share.getSandbox() == null ? other.share.getSandbox() != null : !this.share.getSandbox().equals(other.share.getSandbox())) {
            return false;
        }
        return !(this.share.getPath() == null ? other.share.getPath() != null : !this.share.getPath().equals(other.share.getPath()));
    }

    @Override
    public IShare getShare() {
        return this.share;
    }
}

