/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.BaselineContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class BaselineNamespace
extends ItemNamespace {
    private ITeamRepository repository;
    private UUID baselineId;

    private BaselineNamespace(ITeamRepository repo, UUID baseline) {
        this.repository = repo;
        this.baselineId = baseline;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.baselineId == null ? 0 : this.baselineId.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaselineNamespace other = (BaselineNamespace)obj;
        if (this.baselineId == null ? other.baselineId != null : !this.baselineId.equals((Object)other.baselineId)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals(other.repository));
    }

    public ItemId<IBaseline> getBaselineId() {
        return new ItemId(IBaseline.ITEM_TYPE, this.baselineId);
    }

    @Override
    public IContextHandle getContextHandle() {
        return (IContextHandle)IBaseline.ITEM_TYPE.createItemHandle(this.baselineId, null);
    }

    @Override
    public ItemId<IComponent> fetchComponentId(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBaselineConnection baselineConnection = (IBaselineConnection)this.getConnection((IProgressMonitor)progress.newChild(100));
        return new ItemId((IItemHandle)baselineConnection.getComponent());
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getBaselineConnection((IBaselineHandle)this.getBaselineId().toHandle(), (IProgressMonitor)progress);
    }

    @Override
    public IItemContext createContext(IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineConnection baselineConnection = (IBaselineConnection)this.getConnection(monitor);
        return new BaselineContext(baselineConnection);
    }

    @Override
    public boolean hasConnection() {
        return true;
    }

    @Override
    public boolean hasVersionableTree() {
        return true;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean handlesAuditables() {
        return false;
    }

    @Override
    public boolean handlesSimpleItems() {
        return false;
    }

    @Override
    public boolean handlesVersionables() {
        return true;
    }

    public static BaselineNamespace create(ITeamRepository repo, UUID baselineId) {
        return (BaselineNamespace)ItemNamespace.commonNamespace(new BaselineNamespace(repo, baselineId));
    }

    public static BaselineNamespace create(ITeamRepository repo, ItemId<IBaseline> baseline) {
        if (repo == null || baseline == null) {
            throw new NullPointerException();
        }
        return (BaselineNamespace)ItemNamespace.commonNamespace(new BaselineNamespace(repo, baseline.getItemUUID()));
    }

    public static BaselineNamespace create(ITeamRepository repo, IBaselineHandle baseline) {
        if (repo == null || baseline == null) {
            throw new NullPointerException();
        }
        return (BaselineNamespace)ItemNamespace.commonNamespace(new BaselineNamespace(repo, baseline.getItemId()));
    }

    public static BaselineNamespace create(IBaselineConnection baseline) {
        if (baseline == null) {
            throw new NullPointerException();
        }
        return (BaselineNamespace)ItemNamespace.commonNamespace(BaselineNamespace.create(baseline.teamRepository(), (ItemId<IBaseline>)new ItemId((IItemHandle)baseline.getBaseline())));
    }
}

