/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.RepositoryContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ItemFetcher {
    private ItemFetcher() {
    }

    public static <T extends IItem> List<ItemId<T>> getValidHandles(ITeamRepository repository, Collection<ItemId<T>> itemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList handles = NewCollection.arrayList();
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repository, itemIds, (IProgressMonitor)monitor);
        for (ItemId<T> nextId : itemIds) {
            IItem nextFetched = (IItem)fetched.get(nextId);
            if (nextFetched == null || !nextFetched.getItemType().equals(nextId.getItemType())) continue;
            handles.add(nextId);
        }
        return handles;
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(IItemContext context, Collection<ItemId<T>> items, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemFetcher.fetchCurrents(context, items, FetchProfile.createFullProfile(), refresh, monitor);
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(IItemContext context, Collection<ItemId<T>> items, FetchProfile profile, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return context.fetchCurrents(items, profile, refresh, monitor);
    }

    public static <T extends IItem> Map<ItemLocator<T>, T> fetchCurrents(Collection<ItemLocator<T>> items, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        HashMap result = NewCollection.hashMap();
        Map<ItemNamespace, List<ItemId<T>>> groupByNamespace = ItemLocator.groupByNamespace(items);
        progress.setWorkRemaining(groupByNamespace.size());
        for (Map.Entry<ItemNamespace, List<ItemId<T>>> next : groupByNamespace.entrySet()) {
            SubMonitor namespaceProgress = progress.newChild(1).setWorkRemaining(100);
            IItemContext nextContext = next.getKey().getContext((IProgressMonitor)namespaceProgress.newChild(5));
            Map<ItemId<T>, T> fetched = ItemFetcher.fetchCurrents(nextContext, (Collection)next.getValue(), refresh, (IProgressMonitor)namespaceProgress.newChild(95));
            for (Map.Entry<ItemId<T>, T> nextResult : fetched.entrySet()) {
                result.put(ItemLocator.create(next.getKey(), nextResult.getKey()), (IItem)nextResult.getValue());
            }
        }
        return result;
    }

    public static <T extends IItem> T fetchCurrent(IItemContext context, ItemId<T> item, FetchProfile profile, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)((IItem)RepoFetcher.getItem(ItemFetcher.fetchCurrents(context, Collections.singletonList(item), profile, refresh, monitor), item));
    }

    public static <T extends IItem> T fetchCurrent(IItemContext context, ItemId<T> item, boolean refresh, IProgressMonitor monitor) throws ItemNotFoundException, TeamRepositoryException {
        return (T)((IItem)RepoFetcher.getItem(ItemFetcher.fetchCurrents(context, Collections.singletonList(item), refresh, monitor), item));
    }

    public static <T extends IItem> T fetchCurrent(ItemLocator<T> item, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemFetcher.fetchCurrent(item, false, monitor);
    }

    public static <T extends IItem> T fetchCurrent(ItemLocator<T> item, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IItemContext context = item.getNamespace().getContext((IProgressMonitor)progress.newChild(1));
        return ItemFetcher.fetchCurrent(context, item.getItemId(), refresh, (IProgressMonitor)progress.newChild(1));
    }

    public static <T extends IItem> Map<ItemId<T>, StateId<T>> fetchStateIds(IItemContext context, List<ItemId<T>> item, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return context.getStates(item, refresh, monitor);
    }

    public static <T extends IItem> StateId<T> fetchStateId(IItemContext context, ItemId<T> item, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return (StateId)RepoFetcher.getItem(ItemFetcher.fetchStateIds(context, Collections.singletonList(item), refresh, monitor), item);
    }

    public static <T extends IItem> StateId<T> fetchStateId(ITeamRepository context, ItemId<T> item, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return (StateId)RepoFetcher.getItem(ItemFetcher.fetchStateIds(new RepositoryContext(context), Collections.singletonList(item), refresh, monitor), item);
    }
}

