/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.NullWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateReport;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.DeliveryRequiresHistoryReorderingException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.ItemLockedInStreamException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DeliverOperation
extends ChangeHistoryChangeSetsOperation
implements IDeliverOperation {
    private DeliverDilemmaHandler problemHandler;
    public Map<DeliverDescriptor, DeliverOperationRequest> deliverRequests = new HashMap<DeliverDescriptor, DeliverOperationRequest>();
    private boolean flowComponents = true;
    private boolean populateUpdateReport = false;
    private IWorkspaceUpdateReporter changes;

    public DeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler;
        this.deliverRequests = new HashMap<DeliverDescriptor, DeliverOperationRequest>();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeliverOperation_0, (int)100);
        this.changes = this.populateUpdateReport ? new WorkspaceUpdateReport() : new NullWorkspaceUpdateReporter();
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        ArrayList<IContextHandle> targets = new ArrayList<IContextHandle>();
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedDeliverConfigurations(this.deliverRequests.values(), determinants, targets, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, targets, determinants, (IProgressMonitor)progress.newChild(1));
        HashMap<IStreamLockReport, IWorkspaceConnection> locksToRelease = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        HashMap<IStreamLockReport, IWorkspaceConnection> locksBeingHeld = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        try {
            SubMonitor loopProgress;
            this.runPreConditionsOnly(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
            if (this.flowComponents) {
                progress.subTask(Messages.DeliverOperation_1);
                loopProgress = progress.newChild(10).setWorkRemaining(this.deliverRequests.size() * 4);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    IChangeHistorySyncReport report = deliverRequest.getSyncReport();
                    List componentOps = FlowUtils.getComponentSynchronizationOps((boolean)deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)loopProgress.newChild(1)), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace(), (IChangeHistorySyncReport)report);
                    if (componentOps.size() <= 0) continue;
                    if (!deliverRequest.getWorkspace().isStream()) {
                        ArrayList csToClose = new ArrayList();
                        for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                            if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                            csToClose.addAll(deliverRequest.getWorkspace().activeChangeSets(componentOp.getComponent()));
                        }
                        deliverRequest.getWorkspace().closeChangeSets(csToClose, (IProgressMonitor)loopProgress.newChild(1));
                    }
                    deliverRequest.getTargetWorkspace().applyComponentOperations(componentOps, (IProgressMonitor)loopProgress.newChild(1));
                    this.changes.recordComponentOps(deliverRequest.getTargetWorkspace(), componentOps);
                    boolean updateFlowTable = deliverRequest.getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)deliverRequest.getTargetWorkspace().getResolvedWorkspace()) != null;
                    SubMonitor loopProgress2 = loopProgress.newChild(1).setWorkRemaining(componentOps.size() * 2);
                    for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                        if (updateFlowTable) {
                            if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                                if (!FlowUtils.hasComponentSyncState((IComponentHandle)componentOp.getComponent(), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace())) {
                                    FlowUtils.addComponentSyncState((IWorkspaceConnection)deliverRequest.getWorkspace(), (IConnection)deliverRequest.getTargetWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)loopProgress2.newChild(1));
                                }
                            } else if (componentOp instanceof IFlowNodeConnection.IComponentDeletionOp && FlowUtils.hasComponentSyncState((IComponentHandle)componentOp.getComponent(), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace())) {
                                FlowUtils.removeComponentSyncState((IWorkspaceConnection)deliverRequest.getWorkspace(), (IConnection)deliverRequest.getTargetWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)loopProgress2.newChild(1));
                            }
                        }
                        deliverRequest.clearChanges(componentOp.getComponent(), (IProgressMonitor)loopProgress2.newChild(1));
                    }
                }
            }
            loopProgress = progress.newChild(88).setWorkRemaining(this.deliverRequests.size() * 20);
            progress.subTask(Messages.DeliverOperation_0);
            int ignoreLocks = 3;
            ArrayList<DeliverOperationRequest> deliverRequests2 = new ArrayList<DeliverOperationRequest>(this.deliverRequests.values());
            int i = 0;
            while (i < deliverRequests2.size()) {
                DeliverOperationRequest deliverRequest = (DeliverOperationRequest)deliverRequests2.get(i);
                IChangeHistorySyncReport report = deliverRequest.getSyncReport();
                if (deliverRequest.getChangeSets().size() > 0 || deliverRequest.getBaselines().size() > 0) {
                    IWorkspaceConnection targetWorkspaceConnection = deliverRequest.getTargetWorkspace();
                    try {
                        IWorkspaceConnection workspaceConnection = deliverRequest.getWorkspace();
                        List componentLocks = ((IWorkspaceOperationRunner)workspaceConnection).runDeliverWithPrecondition(new IWorkspaceOperationRunner.IWorkspaceOperationRunnable(){

                            public void run(IProgressMonitor monitor) throws TeamRepositoryException {
                                DeliverOperation.this.verifyUncheckedInChanges(monitor);
                            }
                        }, targetWorkspaceConnection, report, deliverRequest.getBaselines(), deliverRequest.getChangeSets(), (IProgressMonitor)loopProgress.newChild(18));
                        this.changes.recordBaselines(targetWorkspaceConnection, deliverRequest.getBaselines(), (IProgressMonitor)loopProgress.newChild(1));
                        this.changes.recordChangeSets(targetWorkspaceConnection, deliverRequest.getChangeSets(), (IProgressMonitor)loopProgress.newChild(1));
                        if (componentLocks.size() > 0) {
                            locksToRelease.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)targetWorkspaceConnection.getResolvedWorkspace(), (Collection)componentLocks), targetWorkspaceConnection);
                        }
                    }
                    catch (ItemLockedInStreamException e) {
                        IStreamLockReport lockReport = e.getLockReport();
                        if (lockReport != null) {
                            locksBeingHeld.put(lockReport, targetWorkspaceConnection);
                            if (ignoreLocks == 3) {
                                ignoreLocks = this.getProblemHandler().lockBeingHeld(lockReport, targetWorkspaceConnection, deliverRequests2.size() - i - 1);
                                switch (ignoreLocks) {
                                    case 3: {
                                        break;
                                    }
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        throw new OperationCanceledException(e.getMessage());
                                    }
                                    case 2: {
                                        throw new FileSystemException(e);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        }
                        throw e;
                    }
                    catch (DeliveryRequiresHistoryReorderingException e) {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor((IProgressMonitor)loopProgress, 2);
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)subProgressMonitor, (int)3);
                        IWorkspaceConnection source = deliverRequest.getWorkspace();
                        IComponentHandle componentHandle = e.getComponent();
                        IComponent component = (IComponent)source.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
                        int deliveryRequiresHistoryReordering = this.getProblemHandler().deliveryRequiresHistoryReordering(source, targetWorkspaceConnection, component);
                        switch (deliveryRequiresHistoryReordering) {
                            case 3: {
                                break;
                            }
                            case 0: {
                                IUpdateReport updateReport = source.harmonizeHistory(targetWorkspaceConnection, e.getComponent(), (IProgressMonitor)subMonitor.newChild(1));
                                UpdateOperation updateOperation = new UpdateOperation(source, Collections.singletonList(updateReport), 3, this.problemHandler, null);
                                this.disableVerifyInSync(updateOperation);
                                try {
                                    updateOperation.run((IProgressMonitor)subMonitor.newChild(1));
                                }
                                catch (FileSystemException e2) {
                                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e2)));
                                }
                                catch (TeamRepositoryException e2) {
                                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e2));
                                }
                                break;
                            }
                            case 1: {
                                throw new OperationCanceledException(e.getMessage());
                            }
                            case 2: {
                                throw new FileSystemException(e);
                            }
                        }
                    }
                }
                ++i;
            }
            this.getProblemHandler().locksWereHeld(locksBeingHeld);
            Map<IStreamLockReport, IWorkspaceConnection> locksToRelease2 = this.getProblemHandler().locksToRelease(locksToRelease);
            if (locksToRelease2.size() > 0) {
                UnlockOperation unlockOperation = new UnlockOperation(this.getProblemHandler().getLockDilemmaHandler());
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locksToRelease2.entrySet()) {
                    List<LockEntry> locksEntries = LockEntry.createEntries(entry.getValue().teamRepository(), entry.getKey());
                    for (LockEntry lockEntry : locksEntries) {
                        unlockOperation.unlock(lockEntry.getWorkspaceConnection((IProgressMonitor)progress.newChild(1)), lockEntry.getComponent(), lockEntry.getVersionable(), lockEntry.getContributor());
                    }
                }
                unlockOperation.run((IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
            progress.done();
        }
    }

    private void verifyNonDefaultTargets() throws FileSystemException, TeamRepositoryException {
        int result;
        ArrayList<IWorkspaceConnection> nonDefaultTargets = new ArrayList<IWorkspaceConnection>(1);
        for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            IWorkspaceConnection source = deliverRequest.getWorkspace();
            IWorkspaceConnection target = deliverRequest.getTargetWorkspace();
            ConnectionDescriptor defaultTarget = FlowUtils.getDefaultFlowTargetDescriptor((IWorkspaceConnection)source);
            if (defaultTarget != null && defaultTarget.connectionHandle.sameItemId((IItemHandle)target.getResolvedWorkspace())) continue;
            nonDefaultTargets.add(target);
        }
        if (nonDefaultTargets.size() > 0 && (result = this.getProblemHandler().notDefaultTarget(nonDefaultTargets)) != 0) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemException(Messages.DeliverOperation_2);
        }
    }

    private void verifyComponentFlowing(SubMonitor newChild) throws FileSystemException, TeamRepositoryException {
        ArrayList<IComponentHandle> added = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> removed = new ArrayList<IComponentHandle>();
        ArrayList<UUID> affectedComponents = new ArrayList<UUID>();
        for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            if (deliverRequest.isComponentContext()) continue;
            List componentOps = FlowUtils.getComponentSynchronizationOps((boolean)deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)newChild), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace(), (IChangeHistorySyncReport)deliverRequest.getSyncReport());
            for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                IComponentHandle component = componentOp.getComponent();
                affectedComponents.add(component.getItemId());
                if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    added.add(component);
                    continue;
                }
                if (!(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                removed.add(component);
            }
        }
        if (added.size() > 0 || removed.size() > 0) {
            int result = this.getProblemHandler().componentsToBeAddedOrRemoved(added, removed);
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 2) {
                throw new FileSystemException(Messages.DeliverOperation_3);
            }
            if (result == 3) {
                this.setFlowComponents(false);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    List<IComponentHandle> impactedComponents = deliverRequest.getAffectedComponents((IProgressMonitor)newChild);
                    for (IComponentHandle componentHandle : impactedComponents) {
                        if (!affectedComponents.contains(componentHandle.getItemId())) continue;
                        deliverRequest.clearChanges(componentHandle, (IProgressMonitor)newChild);
                    }
                }
            }
        }
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report) {
        DeliverOperationRequest request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        ArrayList components = new ArrayList();
        try {
            components.addAll(sourceWorkspace.getComponents());
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        this.deliverRequests.put(new DeliverDescriptor(sourceWorkspace, targetWorkspace), request);
        for (IComponentHandle componentHandle : components) {
            this.deliver(sourceWorkspace, targetWorkspace, report, componentHandle);
        }
        request.setWorkspaceContext(true);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, IComponentHandle component, boolean flowAll) {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && request.isWorkspaceContext()) {
            return;
        }
        if (request == null) {
            ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), components);
            request.setComponentContext(!flowAll);
            this.deliverRequests.put(deliverKey, request);
        }
        if (!request.getComponents().contains(component)) {
            request.setReport(report);
            request.addComponent(component);
            this.selectWhatToDeliver(sourceWorkspace, targetWorkspace, component, report, request);
        }
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, IComponentHandle component) {
        this.deliver(sourceWorkspace, targetWorkspace, report, component, false);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, List<? extends IChangeSetHandle> changeSets) {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && (request.isWorkspaceContext() || request.isComponentContext())) {
            return;
        }
        if (request == null) {
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
            this.deliverRequests.put(deliverKey, request);
        }
        request.addChangeSet(changeSets);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) throws TeamRepositoryException {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && request.isWorkspaceContext()) {
            return;
        }
        if (request == null) {
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
            this.deliverRequests.put(deliverKey, request);
        }
        request.addChangeSet(changeSets);
        request.addBaseline(baselines);
        request.addComponent(components);
    }

    protected void setFlowComponents(boolean flowComponents) {
        this.flowComponents = flowComponents;
    }

    protected Collection<DeliverOperationRequest> getDeliverRequests() {
        return this.deliverRequests.values();
    }

    protected DeliverDilemmaHandler getProblemHandler() {
        return this.problemHandler;
    }

    protected Set<ConfigurationFacade> getAffectedDeliverConfigurations(Collection<DeliverOperationRequest> requests, List<IAuditable> determinants, List<IContextHandle> targets, IProgressMonitor monitor) throws TeamRepositoryException {
        Set<ConfigurationFacade> descriptors = this.getAffectedConfigurations(requests, determinants, monitor);
        for (DeliverOperationRequest deliverOperationRequest : requests) {
            targets.add((IContextHandle)deliverOperationRequest.getTargetWorkspace().getResolvedWorkspace());
            targets.add((IContextHandle)deliverOperationRequest.getWorkspace().getResolvedWorkspace());
        }
        return descriptors;
    }

    protected Set<ConfigurationFacade> getAffectedConfigurations(Collection<? extends OperationRequest> acceptRequests, List<IAuditable> determinants, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)acceptRequests.size());
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        for (OperationRequest operationRequest : acceptRequests) {
            configurations.addAll(operationRequest.getAffectedConfigurations(determinants, (IProgressMonitor)monitor.newChild(1)));
        }
        return configurations;
    }

    protected final void verifyUncheckedInChanges(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedDeliverConfigurations(this.getDeliverRequests(), new ArrayList<IAuditable>(3), new ArrayList<IContextHandle>(3), (IProgressMonitor)progress.newChild(1));
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, false, (IProgressMonitor)progress.newChild(99));
    }

    private void selectWhatToDeliver(IWorkspaceConnection source, IWorkspaceConnection target, IComponentHandle component, IChangeHistorySyncReport report, OperationRequest request) {
        try {
            List outgoingBaselines;
            IBaselineHandle sourceBasis = source.getComponentInfo(component).basis();
            IBaselineHandle targetBasis = target.getComponentInfo(component).basis();
            if (!sourceBasis.sameItemId((IItemHandle)targetBasis) && (outgoingBaselines = ItemLists.handlesToIds((Collection)report.outgoingBaselines(component))).contains(ItemId.create((IItemHandle)sourceBasis))) {
                request.addBaseline(sourceBasis);
                request.addChangeSet(report.outgoingChangeSetsAfterBasis(component));
                return;
            }
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
        request.addChangeSet(report.outgoingChangeSets(component));
    }

    @Override
    public void runPreConditionsOnly(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations(this.getDeliverRequests(), new ArrayList<IAuditable>(3), (IProgressMonitor)progress.newChild(10));
        this.runPreConditionsOnly(affectedConfigurations, (IProgressMonitor)progress.newChild(90));
    }

    private void runPreConditionsOnly(Collection<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)25);
        this.verifyInSync(affectedConfigurations, (IProgressMonitor)progress.newChild(15));
        this.verifyNonDefaultTargets();
        this.verifyComponentFlowing(progress.newChild(5));
        this.verifyUncheckedInChanges((IProgressMonitor)progress.newChild(5));
    }

    private void verifyInSync(Collection<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + affectedConfigurations.size()));
        IVerifyInSyncOperation op = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        for (ConfigurationFacade configuration : affectedConfigurations) {
            op.addToVerify(configuration.getConnection((IProgressMonitor)progress.newChild(1)), configuration.getComponentHandle());
        }
        op.run((IProgressMonitor)progress.newChild(100));
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.DeliverOperation_REFRESHING_LOCAL_FILESYSTEM, (int)(this.deliverRequests.size() * 2));
        for (Map.Entry<DeliverDescriptor, DeliverOperationRequest> entry : this.deliverRequests.entrySet()) {
            DeliverOperationRequest deliverRequest = entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, entry.getKey().source, deliverRequest.getChangeSets(), (IProgressMonitor)monitor.newChild(1));
            ChangeSetRefreshUtils.refreshForBaselineChange(refresher, affectedAreas.keySet(), entry.getKey().source, deliverRequest.getBaselines(), (IProgressMonitor)monitor.newChild(1));
            if (!this.flowComponents) {
                monitor.newChild(1);
                continue;
            }
            IChangeHistorySyncReport report = deliverRequest.getSyncReport();
            List componentOps = FlowUtils.getComponentSynchronizationOps((boolean)deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)monitor.newChild(1)), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace(), (IChangeHistorySyncReport)report);
            if (componentOps.size() <= 0) continue;
            SubMonitor opsMon = monitor.newChild(1);
            opsMon.setWorkRemaining(componentOps.size());
            for (IFlowNodeConnection.IComponentOp op : componentOps) {
                IConnection conn;
                if (op instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    conn = ((IFlowNodeConnection.IComponentAdditionOp)op).getSeedConnection();
                } else if (op instanceof IFlowNodeConnection.IComponentReplacementOp) {
                    conn = ((IFlowNodeConnection.IComponentReplacementOp)op).getSeedConnection();
                } else {
                    opsMon.newChild(1);
                    continue;
                }
                refresher.addToRefresh(affectedAreas.keySet(), conn.getContextHandle(), op.getComponent(), (IProgressMonitor)opsMon.newChild(1));
            }
        }
        monitor.done();
    }

    @Override
    public IWorkspaceUpdateReport getUpdateReport() {
        if (this.changes == null) {
            throw new IllegalStateException();
        }
        return this.changes.getReport();
    }

    @Override
    public void setPopulateUpdateReport(boolean shouldPopulate) {
        if (this.changes != null) {
            throw new IllegalStateException();
        }
        this.populateUpdateReport = shouldPopulate;
    }

    public static class DeliverDescriptor {
        public IWorkspaceConnection source;
        public IWorkspaceConnection target;

        public DeliverDescriptor(IWorkspaceConnection source, IWorkspaceConnection target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof DeliverDescriptor)) {
                return false;
            }
            return ((DeliverDescriptor)other).source.equals((Object)this.source) && ((DeliverDescriptor)other).target.equals((Object)this.target);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }
    }

    public static class DeliverOperationRequest
    extends OperationRequest {
        private IWorkspaceConnection targetWorkspace;
        private boolean workspaceContext = false;
        private boolean componentContext = false;

        public DeliverOperationRequest(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) {
            super(workspace, syncReport, baselines, changeSets, components, targetWorkspace);
            this.targetWorkspace = targetWorkspace;
        }

        public IWorkspaceConnection getTargetWorkspace() {
            return this.targetWorkspace;
        }

        public boolean isWorkspaceContext() {
            return this.workspaceContext;
        }

        public void setWorkspaceContext(boolean workspaceContext) {
            this.workspaceContext = workspaceContext;
        }

        public boolean isComponentContext() {
            return this.componentContext;
        }

        public void setComponentContext(boolean componentContext) {
            this.componentContext = componentContext;
        }
    }
}

