/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.queries;

import com.ibm.team.filesystem.client.internal.queries.ChangeSetHasAfterStateFilter;
import com.ibm.team.filesystem.client.internal.queries.ChangeSetHasBeforeStateFilter;
import com.ibm.team.filesystem.client.internal.queries.ChangeSetsForItemQuery;
import com.ibm.team.filesystem.client.internal.queries.FilteredQuery;
import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;

public class QueryPool {
    private QueryPool() {
    }

    public static IQuery getChangeSetsForItemQuery(ITeamRepository repo, ItemId itemId) {
        return new ChangeSetsForItemQuery(repo, itemId);
    }

    public static IQuery getChangeSetsContainingAfterState(ITeamRepository repo, StateId itemState) {
        return new FilteredQuery(QueryPool.getChangeSetsForItemQuery(repo, itemState.getItemId()), new ChangeSetHasAfterStateFilter(itemState));
    }

    public static IQuery getChangeSetsContainingBeforeState(ITeamRepository repo, StateId itemState) {
        return new FilteredQuery(QueryPool.getChangeSetsForItemQuery(repo, itemState.getItemId()), new ChangeSetHasBeforeStateFilter(itemState));
    }

    public static IQuery getIntermediateChangeSetsForItemQuery(ITeamRepository repo, ItemId itemId) {
        return new ChangeSetsForItemQuery(repo, itemId, true);
    }
}

