/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentSeed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsFlowTargetChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspaceDetails;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutComponent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsReadScope;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.GetWorkspaceDetailsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.RestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class WorkspaceUtil {
    private static final String putWorkspaceRequest = "postPutWorkspace";

    public static PutWorkspaceResultDTO putWorkspace(ParmsPutWorkspace parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.workspace.repositoryUrl);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        IWorkspace workspace = wc.getResolvedWorkspace();
        if (RestUtils.isSet((String)parms.name) && !workspace.getName().equals(parms.name)) {
            wc.setName(parms.name, (IProgressMonitor)monitor.newChild(5));
        }
        if (RestUtils.isSet((String)parms.description) && !parms.description.equals(workspace.getDescription())) {
            wc.setDescription(parms.description, (IProgressMonitor)monitor.newChild(5));
        }
        IReadScope scope = IScmService.DEFAULT_VISIBILITY;
        if (parms.readScope != null) {
            scope = WorkspaceUtil.createVisibility(parms.readScope);
        }
        IAuditableHandle newOwner = IScmService.NOOP_OWNER;
        if (RestUtils.isSet((String)parms.newOwnerItemId)) {
            if (wc.isStream()) {
                if (!RestUtils.isSet((String)parms.newOwnerItemType)) {
                    throw new IllegalArgumentException("require project area type to be set for streams");
                }
                ItemType itemType = ItemUtil.itemTypeFor((String)parms.newOwnerItemType, (String)ProcessPackage.eINSTANCE.getNsURI());
                if (itemType == null) {
                    throw new IllegalArgumentException("invalid newOwnerItemType : " + parms.newOwnerItemType);
                }
                IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
                newOwner = processAreaHandle;
            } else {
                newOwner = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            }
        }
        if (scope != IScmService.DEFAULT_VISIBILITY || newOwner != IScmService.NOOP_OWNER) {
            wc.setOwnerAndVisibility(newOwner, scope, (IProgressMonitor)monitor.newChild(5));
        }
        PutWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createPutWorkspaceResultDTO();
        try {
            WorkspaceUtil.applyComponentChanges(wc, parms.configurationChanges, result, (IProgressMonitor)monitor.newChild(50));
            WorkspaceUtil.applyFlowTableChanges(wc, parms, syncViewProxy, (IProgressMonitor)monitor.newChild(10));
            result.setWorkspace(CoreUtil.translateWorkspace(wc, true, true, true, true, (IProgressMonitor)monitor.newChild(10)));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static void applyFlowTableChanges(IWorkspaceConnection connection, ParmsPutWorkspace parms, ISyncViewProxy syncViewProxy, IProgressMonitor monitor) throws TeamRepositoryException {
        ConnectionDescriptor defaultFlowTarget;
        IWorkspaceHandle defaultWorkspaceHandle;
        int n;
        int n2;
        Object[] objectArray;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
        boolean changed = false;
        if (parms.flowTargetsToRemove != null && parms.flowTargetsToRemove.length > 0) {
            objectArray = parms.flowTargetsToRemove;
            n2 = parms.flowTargetsToRemove.length;
            n = 0;
            while (n < n2) {
                Object workspace = objectArray[n];
                IWorkspaceHandle workspaceHandle = ((ParmsWorkspace)workspace).getWorkspaceHandle();
                FlowTableUtil.removeCollaboration(flowTable, workspaceHandle);
                ++n;
            }
            changed = true;
        }
        if (parms.flowTargets != null && parms.flowTargets.length > 0) {
            objectArray = parms.flowTargets;
            n2 = parms.flowTargets.length;
            n = 0;
            while (n < n2) {
                Object change = objectArray[n];
                IWorkspaceHandle flowTarget = ((ParmsFlowTargetChange)change).workspace.getWorkspaceHandle();
                if (flowTable.getAcceptFlow((IFlowNodeHandle)flowTarget) != null || flowTable.getDeliverFlow((IFlowNodeHandle)flowTarget) != null) {
                    flowTable.setComponentScopes((IFlowNodeHandle)flowTarget, ((ParmsFlowTargetChange)change).getComponentScopes());
                    changed = true;
                } else {
                    IWorkspaceConnection remote = ((ParmsFlowTargetChange)change).workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
                    FlowTableUtil.addCollaboration(flowTable, connection, remote);
                    flowTable.setComponentScopes((IFlowNodeHandle)flowTarget, ((ParmsFlowTargetChange)change).getComponentScopes());
                    changed = true;
                }
                ++n;
            }
        }
        if (parms.defaultFlowTarget != null && !(defaultWorkspaceHandle = parms.defaultFlowTarget.getWorkspaceHandle()).sameItemId((IItemHandle)((defaultFlowTarget = FlowUtils.getDefaultFlowTargetDescriptor((IWorkspaceConnection)connection)) == null ? null : defaultFlowTarget.connectionHandle))) {
            FlowTableUtil.setDefaultCollaboration(flowTable, defaultWorkspaceHandle);
            changed = true;
        }
        boolean currentChanged = false;
        IWorkspaceConnection newCurrentConnection = null;
        if (parms.currentFlowTarget != null) {
            newCurrentConnection = parms.currentFlowTarget.getWorkspaceConnection(monitor);
            ConnectionDescriptor oldCurrentConnection = FlowTableUtil.getCurrentCollaborationDescriptor(connection);
            if (!newCurrentConnection.getContextHandle().sameItemId((IItemHandle)(oldCurrentConnection == null ? null : oldCurrentConnection.connectionHandle))) {
                FlowTableUtil.setCurrentCollaboration(flowTable, (IWorkspaceHandle)newCurrentConnection.getResolvedWorkspace());
                currentChanged = true;
                changed = true;
            }
        }
        if (changed) {
            connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(29));
        }
        if (currentChanged) {
            syncViewProxy.setWorkspaceCollaboration(connection.getResolvedWorkspace(), newCurrentConnection, false, (IProgressMonitor)progress.newChild(1));
        }
    }

    public static void putComponent(ParmsPutComponent parms, IProgressMonitor progress) throws TeamRepositoryException {
        IAuditableHandle newOwner;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.componentItemId), null);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        if (RestUtils.isSet((String)parms.name)) {
            wm.renameComponent(componentHandle, parms.name, (IProgressMonitor)monitor.newChild(1));
        }
        IReadScope newViz = parms.readScope != null ? WorkspaceUtil.createVisibility(parms.readScope) : IScmService.DEFAULT_VISIBILITY;
        if (RestUtils.isSet((String)parms.newOwnerItemId)) {
            if (parms.newOwnerItemType.equals(IContributor.ITEM_TYPE.getName())) {
                newOwner = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            } else {
                ItemType itemType = ItemUtil.itemTypeFor((String)parms.newOwnerItemType, (String)ProcessPackage.eINSTANCE.getNsURI());
                newOwner = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            }
        } else {
            newOwner = IScmService.NOOP_OWNER;
        }
        if (newViz != IScmService.DEFAULT_VISIBILITY || newOwner != IScmService.NOOP_OWNER) {
            wm.setComponentOwnerAndVisibility(componentHandle, newOwner, newViz, (IProgressMonitor)monitor.newChild(1));
        }
    }

    public static IReadScope createVisibility(ParmsReadScope readScope) {
        if ("contributor_deferring_scope".equals(readScope.scope)) {
            IContributorDeferringScope scope = IReadScope.FACTORY.createContributorDeferringScope();
            scope.setScope((IAuditableHandle)((IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)readScope.defer_to), null)));
            return scope;
        }
        if ("private_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createPrivateScope();
        }
        if ("process_area_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createProcessAreaScope();
        }
        if ("public_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createPublicScope();
        }
        if ("team_area_private_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createTeamAreaPrivateScope();
        }
        throw new IllegalArgumentException("Bad scope: " + readScope);
    }

    public static WorkspaceDetailsDTO postWorkspace(ParmsPostWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection created;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection seedConnection = null;
        if (parms.seed != null) {
            seedConnection = parms.seed.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        }
        if (parms.isStream.booleanValue()) {
            ItemType itemType = ItemUtil.itemTypeFor((String)parms.processAreaType, (String)ProcessPackage.eINSTANCE.getNsURI());
            IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.processAreaId), null);
            created = wm.createStream(processAreaHandle, parms.name, parms.description, (IProgressMonitor)monitor.newChild(10));
            if (seedConnection != null) {
                ArrayList<IFlowNodeConnection.IComponentAdditionOp> ops = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
                List components = seedConnection.getComponents();
                for (IComponentHandle component : components) {
                    ops.add(seedConnection.componentOpFactory().addComponent(component, (IConnection)seedConnection, false));
                }
                created.applyComponentOperations(ops, (IProgressMonitor)monitor.newChild(60));
            }
        } else {
            IContributorHandle owner = RepositoryUtils.getLoggedInContributor(repo);
            created = wm.createWorkspace(owner, parms.name, parms.description, seedConnection, seedConnection, (IProgressMonitor)monitor.newChild(70));
        }
        if (parms.readScope != null) {
            IReadScope scope = WorkspaceUtil.createVisibility(parms.readScope);
            created.setOwnerAndVisibility(IScmService.NOOP_OWNER, scope, (IProgressMonitor)monitor.newChild(10));
        }
        return CoreUtil.translateWorkspace(created, true, true, true, true, (IProgressMonitor)monitor.newChild(1));
    }

    private static void applyComponentChanges(IWorkspaceConnection connection, ParmsConfigurationChanges parms, PutWorkspaceResultDTO result, IProgressMonitor progress) throws TeamRepositoryException {
        if (parms == null) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(55 + 10 * parms.components.length));
        ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        workspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
        workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        workspaceUpdateDilemmaHandler.validate(putWorkspaceRequest, "workspaceUpdateDilemmaHandler");
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(workspaceUpdateDilemmaHandler, parms.pendingChangesDilemmaHandler, result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), null, null, null, null, null, null, null, null, null, (IProgressMonitor)monitor.newChild(5));
        IWorkspaceUpdateOperation workspaceUpdateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, workspaceUpdateOperation);
        ITeamRepository repo = connection.teamRepository();
        ParmsComponentChange[] parmsComponentChangeArray = parms.components;
        int n = parms.components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentHandle component;
            IComponentHandle component2;
            IConnection seedConnection;
            ParmsComponentChange command = parmsComponentChangeArray[n2];
            if (command.cmd.equals("addComponent")) {
                if (command.componentItemId == null) {
                    workspaceUpdateOperation.addComponent(connection, command.name);
                } else if (command.seed != null) {
                    seedConnection = WorkspaceUtil.getSeedConnection(command.componentItemId, command.seed, (IProgressMonitor)monitor.newChild(10));
                    component2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)seedConnection.teamRepository(), UUID.valueOf((String)command.componentItemId), null);
                    if (seedConnection instanceof IBaselineConnection) {
                        workspaceUpdateOperation.replace(connection, (IBaselineConnection)seedConnection);
                    } else {
                        workspaceUpdateOperation.replace(connection, (IWorkspaceConnection)seedConnection, Collections.singletonList(component2));
                    }
                } else {
                    component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)command.componentItemId), null);
                    workspaceUpdateOperation.addComponent(connection, repo, component);
                }
            } else if (command.cmd.equals("removeComponent")) {
                component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)command.componentItemId), null);
                workspaceUpdateOperation.removeComponent(connection, component);
            } else if (command.cmd.equals("replaceComponent")) {
                seedConnection = WorkspaceUtil.getSeedConnection(command.componentItemId, command.seed, (IProgressMonitor)monitor.newChild(10));
                component2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)seedConnection.teamRepository(), UUID.valueOf((String)command.componentItemId), null);
                if (seedConnection instanceof IBaselineConnection) {
                    workspaceUpdateOperation.replace(connection, (IBaselineConnection)seedConnection);
                } else {
                    workspaceUpdateOperation.replace(connection, (IWorkspaceConnection)seedConnection, Collections.singletonList(component2));
                }
            }
            ++n2;
        }
        workspaceUpdateOperation.run((IProgressMonitor)monitor.newChild(50));
        for (ConfigurationFacade descriptor : workspaceUpdateOperation.getComponentsAdded()) {
            result.getComponentsAdded().add(CoreUtil.translateConfigurationDescriptor(descriptor));
        }
        for (IComponent comp : workspaceUpdateOperation.getComponentsCreated()) {
            ComponentDTO compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
            compDto.setName(comp.getName());
            compDto.setItemId(comp.getItemId().getUuidValue());
            result.getComponentsCreated().add(compDto);
        }
    }

    private static IConnection getSeedConnection(String componentItemId, ParmsComponentSeed seed, IProgressMonitor progress) throws TeamRepositoryException {
        if (seed != null) {
            UUID componentId = UUID.valueOf((String)componentItemId);
            ITeamRepository repo = CommonUtil.getTeamRepository(seed.repositoryUrl);
            if (seed.itemTypeId.equals("workspace")) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
                IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspaceHandle, progress);
                for (IComponentHandle component : workspaceConnection.getComponents()) {
                    if (!component.getItemId().equals((Object)componentId)) continue;
                    return workspaceConnection;
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_3, (Object)workspaceConnection.getName()));
            }
            if (seed.itemTypeId.equals("baseline")) {
                IBaselineHandle bh = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
                IBaselineConnection baselineConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(bh, progress);
                if (baselineConnection.getComponent().getItemId().equals((Object)componentId)) {
                    return baselineConnection;
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_2, (Object)baselineConnection.getName()));
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IBaselineSetHandle sh = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
            IBaselineSet snapShot = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)sh, 0, (IProgressMonitor)monitor.newChild(25));
            List baselines = repo.itemManager().fetchCompleteItems(snapShot.getBaselines(), 0, (IProgressMonitor)monitor.newChild(25));
            for (IBaseline baseline : baselines) {
                if (!baseline.getComponent().getItemId().equals((Object)componentId)) continue;
                return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(baseline, (IProgressMonitor)monitor.newChild(50));
            }
            throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_1, (Object)snapShot.getName()));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static GetWorkspaceDetailsResultDTO getWorkspaceDetails(ParmsGetWorkspaceDetails parms, IProgressMonitor progress) {
        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * parms.workspaces.length * 4));
        result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsResultDTO();
        toFetch = new HashMap<ITeamRepository, ArrayList<IWorkspaceHandle>>();
        var8_5 = parms.workspaces;
        var7_6 = parms.workspaces.length;
        var6_8 = 0;
        while (var6_8 < var7_6) {
            request = var8_5[var6_8];
            try {
                if (!(request.includeComponents.booleanValue() || request.includeFlowTargets.booleanValue() || request.refresh.booleanValue())) {
                    repo = CommonUtil.getTeamRepository(request.workspace.repositoryUrl);
                    workspacesToFetch = (ArrayList<IWorkspaceHandle>)toFetch.get(repo);
                    if (workspacesToFetch == null) {
                        workspacesToFetch = new ArrayList<IWorkspaceHandle>();
                        toFetch.put(repo, workspacesToFetch);
                    }
                    workspacesToFetch.add(request.workspace.getWorkspaceHandle());
                } else {
                    connection = request.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(1));
                    if (request.refresh.booleanValue()) {
                        connection.refresh((IProgressMonitor)monitor.newChild(1));
                    }
                    details = CoreUtil.translateWorkspace(connection, request.includeComponents, request.includeFlowTargets, request.includeComponentOwner, request.includeComponentReadScope, (IProgressMonitor)monitor.newChild(2));
                    result.getWorkspaceDetails().add(details);
                }
            }
            catch (TeamRepositoryException e) {
                error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                error.setMessage(e.getMessage());
                repo = null;
                try {
                    repo = CommonUtil.getTeamRepository(request.workspace.repositoryUrl);
                }
                catch (TeamRepositoryException v0) {}
                if (repo != null) {
                    error.setRepositoryId(CoreUtil.translateRepositoryId(repo));
                }
                error.setRepositoryUrl(request.workspace.repositoryUrl);
                error.setWorkspaceId(request.workspace.workspaceItemId);
                result.getErrors().add(error);
            }
            ++var6_8;
        }
        if (!toFetch.isEmpty()) {
            block7: for (Map.Entry<K, V> workspacesToFetchEntry : toFetch.entrySet()) {
                repository = (ITeamRepository)workspacesToFetchEntry.getKey();
                repoUrl = repository.getRepositoryURI();
                repoId = CoreUtil.translateRepositoryId(repository);
                try {
                    fetched = repository.itemManager().fetchCompleteItemsPermissionAware((List)workspacesToFetchEntry.getValue(), 0, (IProgressMonitor)monitor.newChild(3 * ((List)workspacesToFetchEntry.getValue()).size()));
                    for (IWorkspace workspace : fetched.getRetrievedItems()) {
                        details = CoreUtil.translateWorkspace((ITeamRepository)workspacesToFetchEntry.getKey(), workspace, monitor.newChild(1));
                        result.getWorkspaceDetails().add(details);
                    }
                    for (IItemHandle item : fetched.getNotFoundItems()) {
                        error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                        error.setMessage(Messages.WorkspaceUtil_0);
                        error.setRepositoryId(repoId);
                        error.setRepositoryUrl(repoUrl);
                        error.setWorkspaceId(item.getItemId().getUuidValue());
                        result.getErrors().add(error);
                    }
                    for (IItemHandle item : fetched.getPermissionDeniedItems()) {
                        error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                        error.setMessage(Messages.WorkspaceUtil_1);
                        error.setRepositoryId(repoId);
                        error.setRepositoryUrl(repoUrl);
                        error.setWorkspaceId(item.getItemId().getUuidValue());
                        result.getErrors().add(error);
                    }
                    continue;
                }
                catch (TeamRepositoryException e) {
                    ** for (workspaceHandle : (List)workspacesToFetchEntry.getValue())
                }
lbl-1000:
                // 1 sources

                {
                    error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                    error.setMessage(e.getMessage());
                    error.setRepositoryId(repoId);
                    error.setRepositoryUrl(repoUrl);
                    error.setWorkspaceId(workspaceHandle.getItemId().getUuidValue());
                    result.getErrors().add(error);
                    continue;
lbl84:
                    // 1 sources

                }
            }
        }
        return result;
    }

    public static void setVersionablePermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, ParmsComponentSeed seed, IPermissionContextProvider contextProvider, SubMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IConnection connection = WorkspaceUtil.getSeedConnection(componentHandle.getItemId().getUuidValue(), seed, (IProgressMonitor)monitor.newChild(1));
        connection.setVersionablePermissions(versionables, componentHandle, contextProvider, (IProgressMonitor)monitor.newChild(99));
    }
}

