/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtils {
    public static String getString(List<String> path) {
        return PathUtils.getString(path.toArray(new String[path.size()]));
    }

    public static IPath getPath(String[] path) {
        return new Path(PathUtils.getString(path));
    }

    public static String getString(String[] path) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean samePath(ILocation copyFileAreaRoot1, boolean caseSensitive1, ILocation copyFileAreaRoot2, boolean caseSensitive2) {
        return copyFileAreaRoot1.sameLocation(copyFileAreaRoot2, caseSensitive1 & caseSensitive2);
    }

    public static boolean sameRelativePath(IRelativeLocation relativePath1, boolean caseSensitive1, IRelativeLocation relativePath2, boolean caseSensitive2) {
        return relativePath1.sameLocation(relativePath2, caseSensitive1 && caseSensitive2);
    }

    public static boolean isLoadedWithAnotherName(ISandbox sandbox, IRelativeLocation path, String remoteName) {
        boolean isLoadedWithAnotherName = sandbox.isCaseSensitive() ? !path.getName().equals(remoteName) : (remoteName == null ? true : !path.getName().toLowerCase().equals(remoteName.toLowerCase()));
        return isLoadedWithAnotherName;
    }

    public static String getRealPath(String path) {
        try {
            return ManagedFileStore.getResolvedPath(path);
        }
        catch (CoreException coreException) {
            return new File(path).getAbsolutePath();
        }
    }
}

