/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.operations;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class LockEntry {
    private ITeamRepository repo;
    private IWorkspaceHandle workspaceHandle;
    private IWorkspaceConnection workspaceConnection;
    private IComponentHandle componentHandle;
    private IVersionableHandle versionableHandle;
    private IContributorHandle contributorHandle;

    public LockEntry(ITeamRepository repo, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        this.repo = repo;
        this.workspaceHandle = workspaceHandle;
        this.componentHandle = componentHandle;
        this.versionableHandle = versionableHandle;
        this.contributorHandle = contributorHandle;
    }

    public LockEntry(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        this(workspaceConnection.teamRepository(), (IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), componentHandle, versionableHandle, contributorHandle);
        this.workspaceConnection = workspaceConnection;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public IWorkspaceHandle getStream() {
        return this.workspaceHandle;
    }

    public IComponentHandle getComponent() {
        return this.componentHandle;
    }

    public IVersionableHandle getVersionable() {
        return this.versionableHandle;
    }

    public IContributorHandle getContributor() {
        return this.contributorHandle;
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.workspaceConnection == null) {
            this.workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).getWorkspaceConnection(this.workspaceHandle, monitor);
        }
        return this.workspaceConnection;
    }

    public static List<LockEntry> createEntries(ITeamRepository repo, IStreamLockReport streamLockReport) {
        ArrayList<LockEntry> list = new ArrayList<LockEntry>();
        IWorkspaceHandle stream = streamLockReport.getStream();
        for (IComponentLockReport componentLockReport : streamLockReport.getComponentLocks()) {
            IComponentHandle componentHandle = componentLockReport.getComponent();
            for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                list.add(new LockEntry(repo, stream, componentHandle, versionableLock.getVersionable(), versionableLock.getContributor()));
            }
        }
        return list;
    }
}

